/*
 * Decompiled with CFR 0.152.
 */
package icy.sequence.edit;

import icy.gui.dialog.MessageDialog;
import icy.painter.Overlay;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.sequence.edit.AbstractSequenceEdit;
import java.awt.Image;
import java.util.Set;
import javax.swing.undo.CannotUndoException;

public class DefaultSequenceEdit
extends AbstractSequenceEdit {
    Sequence previous;
    Set<ROI> previousRois;
    Set<Overlay> previousOverlays;

    public DefaultSequenceEdit(Sequence previous, Sequence sequence, Image icon) {
        super(sequence, icon);
        this.previous = previous;
        this.previousRois = previous.getROISet();
        this.previousOverlays = previous.getOverlaySet();
    }

    public DefaultSequenceEdit(Sequence previous, Sequence sequence) {
        this(previous, sequence, null);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        Sequence sequence = this.getSequence();
        sequence.beginUpdate();
        try {
            try {
                sequence.copyFrom(this.previous, true);
                for (ROI roi : this.previousRois) {
                    if (sequence.contains(roi)) continue;
                    sequence.addROI(roi);
                }
                for (ROI roi : sequence.getROIs()) {
                    if (this.previousRois.contains(roi)) continue;
                    sequence.removeROI(roi);
                }
                for (Overlay overlay : this.previousOverlays) {
                    if (sequence.contains(overlay)) continue;
                    sequence.addOverlay(overlay);
                }
                for (Overlay overlay : sequence.getOverlays()) {
                    if (this.previousOverlays.contains(overlay)) continue;
                    sequence.removeOverlay(overlay);
                }
            }
            catch (InterruptedException e) {
                MessageDialog.showDialog("Undo operation interrupted", e.getLocalizedMessage(), 0);
                sequence.endUpdate();
            }
        }
        finally {
            sequence.endUpdate();
        }
    }

    @Override
    public boolean canRedo() {
        return false;
    }
}

