/*
 * Decompiled with CFR 0.152.
 */
package icy.util;

import icy.file.FileUtil;
import icy.network.NetworkUtil;
import icy.system.IcyExceptionHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipUtil {
    public static byte[] pack(Deflater packer, byte[] rawData, int level) {
        Deflater compressor;
        if (packer != null) {
            compressor = packer;
            compressor.reset();
        } else {
            compressor = new Deflater();
        }
        if (level != -1) {
            compressor.setLevel(level);
        }
        compressor.setInput(rawData);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(rawData.length);
        byte[] buf = new byte[65536];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            if (count == 0) break;
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    public static byte[] pack(byte[] rawData) {
        return ZipUtil.pack(null, rawData, -1);
    }

    public static byte[] unpack(Inflater unpacker, byte[] packedData) throws DataFormatException {
        Inflater decompressor;
        if (unpacker != null) {
            decompressor = unpacker;
            decompressor.reset();
        } else {
            decompressor = new Inflater();
        }
        decompressor.setInput(packedData);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(packedData.length);
        byte[] buf = new byte[65536];
        while (!decompressor.finished()) {
            int count = decompressor.inflate(buf);
            if (count == 0) break;
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    public static byte[] unpack(byte[] packedData) throws DataFormatException {
        return ZipUtil.unpack(null, packedData);
    }

    public static boolean extract(String zipFile, String outputDirectory) {
        boolean ok = true;
        try {
            ZipFile file = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    if (FileUtil.createDir(String.valueOf(outputDirectory) + "/" + entry.getName())) continue;
                    System.err.println("ZipUtil.extract(" + zipFile + "," + outputDirectory + ") error :");
                    System.err.println("Can't create directory : '" + outputDirectory + "/" + entry.getName() + "'");
                    ok = false;
                    break;
                }
                if (FileUtil.save(String.valueOf(outputDirectory) + "/" + entry.getName(), NetworkUtil.download(file.getInputStream(entry)), true)) continue;
                System.err.println("ZipUtil.extract(" + zipFile + "," + outputDirectory + ") failed.");
                ok = false;
                break;
            }
            file.close();
        }
        catch (IOException ioe) {
            System.err.println("ZipUtil.extract(" + zipFile + "," + outputDirectory + ") error :");
            IcyExceptionHandler.showErrorMessage(ioe, false);
            ok = false;
        }
        return ok;
    }

    public static boolean extract(String zipFile) {
        return ZipUtil.extract(zipFile, String.valueOf(FileUtil.getDirectory(zipFile)) + FileUtil.getFileName(zipFile, false));
    }

    public static void isValid(String zipFile) throws IOException {
        try (ZipFile file = new ZipFile(zipFile);){
            Enumeration<? extends ZipEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                entry.getName();
            }
        }
    }

    public static boolean isValid(String zipFile, boolean showError) {
        try {
            ZipUtil.isValid(zipFile);
        }
        catch (IOException e) {
            if (showError) {
                System.err.println("ZipUtil.isValid(" + zipFile + ") error :");
                IcyExceptionHandler.showErrorMessage(e, false);
            }
            return false;
        }
        return true;
    }
}

