/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations.expressions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import plugins.ylemontag.mathoperations.Expression;
import plugins.ylemontag.mathoperations.Functor;

public class ExpressionFunction
extends Expression {
    private String _function;
    private Expression[] _arguments;
    private static Map<String, Integer> _functionIndex = null;

    public ExpressionFunction(String function, List<Expression> arguments) {
        this._function = function;
        this._arguments = new Expression[arguments.size()];
        int k = 0;
        Iterator<Expression> iterator = arguments.iterator();
        while (iterator.hasNext()) {
            Expression e;
            this._arguments[k] = e = iterator.next();
            ++k;
        }
    }

    public String getFunction() {
        return this._function;
    }

    public int getArgumentCount() {
        return this._arguments.length;
    }

    public Expression getArgument(int k) {
        return this._arguments[k];
    }

    @Override
    public boolean equals(Expression expr) {
        if (!(expr instanceof ExpressionFunction)) {
            return false;
        }
        ExpressionFunction e = (ExpressionFunction)expr;
        if (!this._function.equals(e._function) || this._arguments.length != e._arguments.length) {
            return false;
        }
        for (int k = 0; k < this._arguments.length; ++k) {
            if (this._arguments[k].equals(e._arguments[k])) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getRepresentation(boolean smartParenthesis) {
        String retVal = this._function + "(";
        for (int k = 0; k < this._arguments.length; ++k) {
            if (k != 0) {
                retVal = retVal + ",";
            }
            retVal = retVal + this._arguments[k].getRepresentation(smartParenthesis);
        }
        retVal = retVal + ")";
        return retVal;
    }

    @Override
    public SortedSet<String> getVariables() {
        TreeSet<String> retVal = new TreeSet<String>();
        for (int k = 0; k < this._arguments.length; ++k) {
            retVal.addAll(this._arguments[k].getVariables());
        }
        return retVal;
    }

    @Override
    public boolean isValidFunctor(String[] variables) {
        if (!this.isCurrentFunctionKnown()) {
            return false;
        }
        for (int k = 0; k < this._arguments.length; ++k) {
            if (this._arguments[k].isValidFunctor(variables)) continue;
            return false;
        }
        return true;
    }

    private boolean isCurrentFunctionKnown() {
        ExpressionFunction.createFunctionIndex();
        Integer expectedArguments = _functionIndex.get(this._function);
        return expectedArguments != null && expectedArguments == this._arguments.length;
    }

    private static void createFunctionIndex() {
        if (_functionIndex != null) {
            return;
        }
        HashMap<String, Integer> retVal = new HashMap<String, Integer>();
        retVal.put("max", 2);
        retVal.put("min", 2);
        retVal.put("abs", 1);
        retVal.put("sign", 1);
        retVal.put("sqrt", 1);
        retVal.put("exp", 1);
        retVal.put("log", 1);
        retVal.put("log10", 1);
        retVal.put("cos", 1);
        retVal.put("sin", 1);
        retVal.put("tan", 1);
        retVal.put("acos", 1);
        retVal.put("asin", 1);
        retVal.put("atan", 1);
        retVal.put("cosh", 1);
        retVal.put("sinh", 1);
        retVal.put("tanh", 1);
        retVal.put("round", 1);
        retVal.put("floor", 1);
        retVal.put("ceil", 1);
        _functionIndex = retVal;
    }

    @Override
    public Functor getFunctor(String[] variables) {
        if (!this.isCurrentFunctionKnown()) {
            throw new Expression.BadFunctor(String.format("Function '%s' does not exist is called with a wrong number of arguments.", this._function));
        }
        String pattern = this._function + "(";
        final Functor.FunPtr[] funPtr = new Functor.FunPtr[this._arguments.length];
        for (int k = 0; k < this._arguments.length; ++k) {
            if (k > 0) {
                pattern = pattern + ",";
            }
            Functor currentFunctor = this._arguments[k].getFunctor(variables);
            pattern = pattern + currentFunctor.getFormatPattern();
            funPtr[k] = currentFunctor.getFunctionPointer();
        }
        pattern = pattern + ")";
        if (this._function.equals("max")) {
            return new Functor(variables.length, pattern, new Functor.FunPtr(){

                @Override
                public double apply(double[] in) {
                    return Math.max(funPtr[0].apply(in), funPtr[1].apply(in));
                }
            });
        }
        if (this._function.equals("min")) {
            return new Functor(variables.length, pattern, new Functor.FunPtr(){

                @Override
                public double apply(double[] in) {
                    return Math.min(funPtr[0].apply(in), funPtr[1].apply(in));
                }
            });
        }
        if (this._function.equals("abs")) {
            return new Functor(variables.length, pattern, new Functor.FunPtr(){

                @Override
                public double apply(double[] in) {
                    return Math.abs(funPtr[0].apply(in));
                }
            });
        }
        if (this._function.equals("sign")) {
            return new Functor(variables.length, pattern, new Functor.FunPtr(){

                @Override
                public double apply(double[] in) {
                    return Math.signum(funPtr[0].apply(in));
                }
            });
        }
        if (this._function.equals("sqrt")) {
            return new Functor(variables.length, pattern, new Functor.FunPtr(){

                @Override
                public double apply(double[] in) {
                    return Math.sqrt(funPtr[0].apply(in));
                }
            });
        }
        if (this._function.equals("exp")) {
            return new Functor(variables.length, pattern, new Functor.FunPtr(){

                @Override
                public double apply(double[] in) {
                    return Math.exp(funPtr[0].apply(in));
                }
            });
        }
        if (this._function.equals("log")) {
            return new Functor(variables.length, pattern, new Functor.FunPtr(){

                @Override
                public double apply(double[] in) {
                    return Math.log(funPtr[0].apply(in));
                }
            });
        }
        if (this._function.equals("log10")) {
            return new Functor(variables.length, pattern, new Functor.FunPtr(){

                @Override
                public double apply(double[] in) {
                    return Math.log10(funPtr[0].apply(in));
                }
            });
        }
        if (this._function.equals("cos")) {
            return new Functor(variables.length, pattern, new Functor.FunPtr(){

                @Override
                public double apply(double[] in) {
                    return Math.cos(funPtr[0].apply(in));
                }
            });
        }
        if (this._function.equals("sin")) {
            return new Functor(variables.length, pattern, new Functor.FunPtr(){

                @Override
                public double apply(double[] in) {
                    return Math.sin(funPtr[0].apply(in));
                }
            });
        }
        if (this._function.equals("tan")) {
            return new Functor(variables.length, pattern, new Functor.FunPtr(){

                @Override
                public double apply(double[] in) {
                    return Math.tan(funPtr[0].apply(in));
                }
            });
        }
        if (this._function.equals("acos")) {
            return new Functor(variables.length, pattern, new Functor.FunPtr(){

                @Override
                public double apply(double[] in) {
                    return Math.acos(funPtr[0].apply(in));
                }
            });
        }
        if (this._function.equals("asin")) {
            return new Functor(variables.length, pattern, new Functor.FunPtr(){

                @Override
                public double apply(double[] in) {
                    return Math.asin(funPtr[0].apply(in));
                }
            });
        }
        if (this._function.equals("atan")) {
            return new Functor(variables.length, pattern, new Functor.FunPtr(){

                @Override
                public double apply(double[] in) {
                    return Math.atan(funPtr[0].apply(in));
                }
            });
        }
        if (this._function.equals("cosh")) {
            return new Functor(variables.length, pattern, new Functor.FunPtr(){

                @Override
                public double apply(double[] in) {
                    return Math.cosh(funPtr[0].apply(in));
                }
            });
        }
        if (this._function.equals("sinh")) {
            return new Functor(variables.length, pattern, new Functor.FunPtr(){

                @Override
                public double apply(double[] in) {
                    return Math.sinh(funPtr[0].apply(in));
                }
            });
        }
        if (this._function.equals("tanh")) {
            return new Functor(variables.length, pattern, new Functor.FunPtr(){

                @Override
                public double apply(double[] in) {
                    return Math.tanh(funPtr[0].apply(in));
                }
            });
        }
        if (this._function.equals("round")) {
            return new Functor(variables.length, pattern, new Functor.FunPtr(){

                @Override
                public double apply(double[] in) {
                    return Math.round(funPtr[0].apply(in));
                }
            });
        }
        if (this._function.equals("floor")) {
            return new Functor(variables.length, pattern, new Functor.FunPtr(){

                @Override
                public double apply(double[] in) {
                    return Math.floor(funPtr[0].apply(in));
                }
            });
        }
        if (this._function.equals("ceil")) {
            return new Functor(variables.length, pattern, new Functor.FunPtr(){

                @Override
                public double apply(double[] in) {
                    return Math.ceil(funPtr[0].apply(in));
                }
            });
        }
        throw new RuntimeException("Unreachable code point");
    }
}

