/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.MHTracker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import plugins.nchenouard.particletracking.MHTracker.Association;
import plugins.nchenouard.particletracking.MHTracker.Cluster;
import plugins.nchenouard.particletracking.MHTracker.Family;
import plugins.nchenouard.particletracking.MHTracker.GlobalHypothesis;
import plugins.nchenouard.particletracking.MHTracker.HMMMHTracker;
import plugins.nchenouard.particletracking.MHTracker.Hypothesis;
import plugins.nchenouard.particletracking.MHTracker.MHTrack2s;

public class SolveMLAssociation {
    ArrayList<Track> trackList = new ArrayList();
    ArrayList<Track> currentTrackList = new ArrayList();

    public GlobalHypothesis getHypothesis(Cluster cl, int firstT, int lastT, HMMMHTracker tracker) {
        GlobalHypothesis gh = new GlobalHypothesis(firstT, lastT, tracker);
        for (Track trk : this.trackList) {
            Family f = trk.f;
            Hypothesis hSelected = null;
            for (Hypothesis h : f.hypotheses) {
                if (h.leaf != trk.association.getLast()) continue;
                hSelected = h;
            }
            if (hSelected != null) {
                gh.addHypothesis(hSelected);
                continue;
            }
            System.out.println(trk.association.getLast().followingSegments.isEmpty() + " " + lastT + " " + trk.association.getLast().association.t + trk.association.getLast().confirmed);
            System.out.println("probleme in SolveMLAssociation, no selected hypothesis ");
            return null;
        }
        for (int t = firstT; t <= lastT; ++t) {
            cl.penalizeFD(gh, t);
            cl.penalizeNT(gh, t);
        }
        return gh;
    }

    public void solve(int firstT, int lastT, HashMap<Integer, ArrayList<Family>> concurrentFamilies, ArrayList<Family> mandatoryFamilies, ArrayList<Family> optionalFamilies) {
        this.solve2(firstT, lastT, mandatoryFamilies);
    }

    public void solve2(int firstT, int lastT, ArrayList<Family> mandatoryFamilies) {
        ArrayList<Association> usedAssociations = new ArrayList<Association>();
        for (Family f : mandatoryFamilies) {
            Track trk = new Track();
            trk.association.add(f.rootNode);
            trk.followingTracks = new LinkedList<MHTrack2s>(f.rootNode.followingSegments);
            trk.f = f;
            Collections.sort(trk.followingTracks, new LowerThan());
            this.trackList.add(trk);
            if (!trk.followingTracks.isEmpty()) {
                this.currentTrackList.add(trk);
                continue;
            }
            if (f.rootNode.terminated) continue;
            System.out.println("error in solveML: following tracks is empty");
        }
        for (int t = firstT + 1; t <= lastT; ++t) {
            usedAssociations.clear();
            ArrayList<Track> temp = new ArrayList<Track>(this.currentTrackList);
            while (!temp.isEmpty()) {
                Track bestTrack = null;
                double bestLikelihood = 0.0;
                for (Track trk : temp) {
                    if (bestTrack != null && !(trk.followingTracks.getFirst().associationLikelihood > bestLikelihood)) continue;
                    bestTrack = trk;
                    bestLikelihood = trk.followingTracks.getFirst().associationLikelihood;
                }
                if (bestTrack != null) {
                    MHTrack2s bestAssociation = bestTrack.followingTracks.getFirst();
                    usedAssociations.add(bestAssociation.association);
                    bestTrack.association.add(bestAssociation);
                    bestTrack.followingTracks = new LinkedList<MHTrack2s>(bestAssociation.followingSegments);
                    Collections.sort(bestTrack.followingTracks, new LowerThan());
                    if (bestTrack.followingTracks.isEmpty()) {
                        this.currentTrackList.remove(bestTrack);
                    }
                    temp.remove(bestTrack);
                    ArrayList<Track> toRemove = new ArrayList<Track>();
                    for (Track trk : temp) {
                        LinkedList<MHTrack2s> copy = new LinkedList<MHTrack2s>(trk.followingTracks);
                        for (MHTrack2s mhtrk : copy) {
                            if (mhtrk.association != bestAssociation.association) continue;
                            trk.followingTracks.remove(mhtrk);
                        }
                        if (!trk.followingTracks.isEmpty()) continue;
                        toRemove.add(trk);
                    }
                    for (Track trk : toRemove) {
                        this.currentTrackList.remove(trk);
                        temp.remove(trk);
                    }
                    continue;
                }
                System.out.println("error in SolveMLAssociation: no best track");
            }
        }
    }

    public void solve1(int firstT, int lastT, HashMap<Integer, ArrayList<Family>> concurrentFamilies, ArrayList<Family> mandatoryFamilies, ArrayList<Family> optionalFamilies) {
        Track trk;
        ArrayList<Association> usedAssociations = new ArrayList<Association>();
        for (Family f : mandatoryFamilies) {
            trk = new Track();
            trk.association.add(f.rootNode);
            trk.followingTracks = new LinkedList<MHTrack2s>(f.rootNode.followingSegments);
            trk.f = f;
            Collections.sort(trk.followingTracks, new LowerThan());
            usedAssociations.add(f.rootNode.association);
            this.trackList.add(trk);
            if (trk.followingTracks.isEmpty()) continue;
            this.currentTrackList.add(trk);
        }
        for (Family f : optionalFamilies) {
            if (usedAssociations.contains(f.rootNode.association) || f.rootNode.association.isPrediction) continue;
            usedAssociations.add(f.rootNode.association);
            trk = new Track();
            trk.association.add(f.rootNode);
            trk.followingTracks = new LinkedList<MHTrack2s>(f.rootNode.followingSegments);
            trk.f = f;
            Collections.sort(trk.followingTracks, new LowerThan());
            this.trackList.add(trk);
            if (trk.followingTracks.isEmpty()) continue;
            this.currentTrackList.add(trk);
        }
        for (int t = firstT + 1; t <= lastT; ++t) {
            usedAssociations.clear();
            ArrayList<Track> temp = new ArrayList<Track>(this.currentTrackList);
            while (!temp.isEmpty()) {
                Track bestTrack = null;
                double bestLikelihood = 0.0;
                for (Track trk2 : temp) {
                    if (bestTrack != null && !(trk2.followingTracks.getFirst().associationLikelihood > bestLikelihood)) continue;
                    bestTrack = trk2;
                    bestLikelihood = trk2.followingTracks.getFirst().associationLikelihood;
                }
                if (bestTrack != null) {
                    MHTrack2s bestAssociation = bestTrack.followingTracks.getFirst();
                    usedAssociations.add(bestAssociation.association);
                    bestTrack.association.add(bestAssociation);
                    bestTrack.followingTracks = new LinkedList<MHTrack2s>(bestAssociation.followingSegments);
                    Collections.sort(bestTrack.followingTracks, new LowerThan());
                    if (bestTrack.followingTracks.isEmpty()) {
                        this.currentTrackList.remove(bestTrack);
                    }
                    temp.remove(bestTrack);
                    ArrayList<Track> toRemove = new ArrayList<Track>();
                    for (Track trk3 : temp) {
                        LinkedList<MHTrack2s> copy = new LinkedList<MHTrack2s>(trk3.followingTracks);
                        for (MHTrack2s mhtrk : copy) {
                            if (mhtrk.association != bestAssociation.association) continue;
                            trk3.followingTracks.remove(mhtrk);
                        }
                        if (!trk3.followingTracks.isEmpty()) continue;
                        toRemove.add(trk3);
                    }
                    for (Track trk3 : toRemove) {
                        this.currentTrackList.remove(trk3);
                        temp.remove(trk3);
                    }
                    continue;
                }
                System.out.println("error in SolveMLAssociation: no best track");
            }
            ArrayList<Family> fList = concurrentFamilies.get(new Integer(t));
            if (fList == null) continue;
            for (Family f : fList) {
                if (usedAssociations.contains(f.rootNode.association) || f.rootNode.association.isPrediction) continue;
                usedAssociations.add(f.rootNode.association);
                Track trk4 = new Track();
                trk4.association.add(f.rootNode);
                trk4.followingTracks = new LinkedList<MHTrack2s>(f.rootNode.followingSegments);
                trk4.f = f;
                Collections.sort(trk4.followingTracks, new LowerThan());
                this.trackList.add(trk4);
                if (trk4.followingTracks.isEmpty()) continue;
                this.currentTrackList.add(trk4);
            }
        }
    }

    class Track {
        Family f;
        LinkedList<MHTrack2s> association = new LinkedList();
        LinkedList<MHTrack2s> followingTracks = new LinkedList();

        Track() {
        }
    }

    class LowerThan
    implements Comparator<MHTrack2s> {
        LowerThan() {
        }

        @Override
        public int compare(MHTrack2s t1, MHTrack2s t2) {
            if (t1.association.isPrediction) {
                if (t2.association.isPrediction) {
                    if (t2.associationLikelihood > t1.associationLikelihood) {
                        return 1;
                    }
                    if (t1.associationLikelihood > t2.associationLikelihood) {
                        return -1;
                    }
                    return 0;
                }
                return 1;
            }
            if (t2.association.isPrediction) {
                return -1;
            }
            if (t2.associationLikelihood > t1.associationLikelihood) {
                return 1;
            }
            if (t1.associationLikelihood > t2.associationLikelihood) {
                return -1;
            }
            return 0;
        }
    }
}

