/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.activecontours;

import icy.plugin.abstract_.Plugin;
import icy.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import plugins.adufour.activecontours.Mesh3D;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarFile;
import plugins.adufour.vars.lang.VarString;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;

public class SaveMeshTracksToVTK
extends Plugin
implements Block {
    Var<TrackGroup> meshTracks = new Var("Mesh tracks", TrackGroup.class);
    VarFile folder = new VarFile("Folder", null);
    VarString prefix = new VarString("Prefix", "Mesh");

    public void declareInput(VarList inputMap) {
        inputMap.add("ROI", this.meshTracks);
        inputMap.add("folder", (Var)this.folder);
        inputMap.add("prefix", (Var)this.prefix);
    }

    public void declareOutput(VarList outputMap) {
    }

    public void run() {
        ArrayList segments = new ArrayList(((TrackGroup)this.meshTracks.getValue(true)).getTrackSegmentList());
        for (int i = 1; i <= segments.size(); ++i) {
            TrackSegment segment = (TrackSegment)segments.get(i - 1);
            if (segment == null) continue;
            for (Detection detection : segment.getDetectionList()) {
                if (!(detection instanceof Mesh3D)) continue;
                String meshID = "_#" + StringUtil.toString((int)i, (int)3);
                String timeID = "_T" + StringUtil.toString((int)detection.getT(), (int)3);
                String fileName = (String)this.prefix.getValue() + meshID + timeID + ".vtk";
                File vtkFile = new File(((File)this.folder.getValue(true)).getPath() + File.separator + fileName);
                ((Mesh3D)detection).mesh.saveToVTK(vtkFile);
            }
        }
    }
}

