/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.rieszwavelets;

import icy.gui.component.pool.SwimmingObjectChooser;
import icy.main.Icy;
import icy.swimmingPool.SwimmingObject;
import icy.swimmingPool.SwimmingPoolEvent;
import icy.swimmingPool.SwimmingPoolListener;
import icy.swimmingPool.WeakSwimmingPoolListener;
import icy.util.StringUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public class CustomChooser
extends JComboBox
implements SwimmingPoolListener {
    private static final long serialVersionUID = 1594001236878708868L;
    private ArrayList<SwimmingObjectChooser.SwimmingObjectChooserListener> listeners;
    private final Class<? extends Object> itemClass;

    public CustomChooser(Class<? extends Object> itemClass) {
        this(itemClass, 50, "No valid object to display in SwimmingPool");
    }

    public CustomChooser(Class<? extends Object> itemClass, final int maxSize, final String defaultMessage) {
        this.itemClass = itemClass;
        this.listeners = new ArrayList();
        Icy.getMainInterface().getSwimmingPool().addListener((SwimmingPoolListener)new WeakSwimmingPoolListener((SwimmingPoolListener)this));
        this.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == null) {
                    return new JLabel(defaultMessage);
                }
                if (value instanceof SwimmingObject) {
                    JLabel label = new JLabel(StringUtil.limit((String)((SwimmingObject)value).getName(), (int)maxSize));
                    label.setToolTipText(((SwimmingObject)value).getName());
                    return label;
                }
                return new JLabel(value.toString());
            }
        });
    }

    public Object getSelectedObject() {
        Object o = this.getSelectedItem();
        if (o != null) {
            return ((SwimmingObject)o).getObject();
        }
        return null;
    }

    public void swimmingPoolChangeEvent(final SwimmingPoolEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CustomChooser.this.refreshList();
                Object obj = event.getResult().getObject();
                if (obj != null) {
                    CustomChooser.this.setSelectedItem(obj);
                }
            }
        });
    }

    void refreshList() {
        Object oldSelected = this.getSelectedItem();
        this.setModel(new DefaultComboBoxModel<Object>(this.getSwimmingObjects()));
        this.setSelectedItem(oldSelected);
    }

    Object[] getSwimmingObjects() {
        ArrayList<SwimmingObject> objectList = new ArrayList<SwimmingObject>();
        ArrayList objects = Icy.getMainInterface().getSwimmingPool().getObjects();
        for (SwimmingObject so : objects) {
            Object o = so.getObject();
            if (!this.itemClass.isInstance(o)) continue;
            objectList.add(so);
        }
        return objectList.toArray();
    }

    public void addListener(SwimmingObjectChooser.SwimmingObjectChooserListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(SwimmingObjectChooser.SwimmingObjectChooserListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void fireItemStateChanged(ItemEvent e) {
        for (SwimmingObjectChooser.SwimmingObjectChooserListener listener : this.listeners) {
            listener.objectChanged(this.getSelectedObject());
        }
        super.fireItemStateChanged(e);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (SwimmingObjectChooser.SwimmingObjectChooserListener listener : this.listeners) {
            listener.objectChanged(this.getSelectedObject());
        }
        super.actionPerformed(e);
    }
}

