/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class VisitechReader
extends FormatReader {
    public static final String[] HTML_SUFFIX = new String[]{"html"};
    public static final String HEADER_MARKER = "[USE SAME FILE]";
    public static final byte[] PIXELS_MARKER = new byte[]{0, 0, 0, 0, 0, 0, -16, 63, 0, 0, 0, 0, 0, 0, -16, 63};
    private List<String> files;
    private long[] pixelOffsets;

    public VisitechReader() {
        super("Visitech XYS", new String[]{"xys", "html"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "One .html file plus one or more .xys files";
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getSizeY();
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (VisitechReader.checkSuffix(name, "xys")) {
            return true;
        }
        if (name.indexOf(32) == -1) {
            return false;
        }
        if (!open) {
            return false;
        }
        String prefix = name.substring(0, name.lastIndexOf(" "));
        Location xys = new Location(prefix + " 1.xys");
        return xys.exists();
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        int plane = FormatTools.getPlaneSize(this);
        int div = this.getSizeZ() * this.getSizeT();
        int fileIndex = this.getSeries() * this.getSizeC() + no / div;
        int planeIndex = no % div;
        if (fileIndex >= this.files.size() || fileIndex >= this.pixelOffsets.length) {
            return buf;
        }
        String file2 = this.files.get(fileIndex);
        try (RandomAccessInputStream s2 = new RandomAccessInputStream(file2);){
            s2.order(this.isLittleEndian());
            s2.seek(this.pixelOffsets[fileIndex]);
            long paddingBytes = (s2.length() - s2.getFilePointer() - (long)(div * plane)) / (long)(div - 1);
            if (planeIndex > 0) {
                s2.skipBytes(((long)plane + paddingBytes) * (long)planeIndex);
            }
            this.readPlane(s2, x, y, w, h2, buf);
        }
        return buf;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        ArrayList<String> v = new ArrayList<String>();
        v.add(this.currentId);
        if (!noPixels && this.files != null) {
            int nFiles = this.getSizeC();
            for (int i = 0; i < nFiles; ++i) {
                int index = this.getSeries() * nFiles + i;
                if (index >= this.files.size()) continue;
                v.add(this.files.get(index));
            }
        }
        return v.toArray(new String[v.size()]);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.files = null;
            this.pixelOffsets = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int i;
        String file2;
        super.initFile(id);
        CoreMetadata ms0 = (CoreMetadata)this.core.get(0);
        if (!VisitechReader.checkSuffix(id, HTML_SUFFIX)) {
            String base = id.substring(0, id.lastIndexOf(" "));
            this.currentId = null;
            this.initFile(base + " Report.html");
            return;
        }
        String s2 = DataTools.readFile(id);
        s2 = s2.replaceAll("<[bB][rR]>", "\n");
        s2 = s2.replaceAll("<[sS][tT][yY][lL][eE]\\p{ASCII}*?[sS][tT][yY][lL][eE]>", "");
        s2 = s2.replaceAll("<[sS][cC][rR][iI][pP][tT]\\p{ASCII}*?[sS][cC][rR][iI][pP][tT]>", "");
        String key = null;
        String value = null;
        int numSeries = 0;
        String[] tokens = s2.split("\n");
        int estimatedSeriesCount = 0;
        int estimatedSizeC = 0;
        for (String token : tokens) {
            if ((token = token.trim()).startsWith("<") && !token.startsWith("</") || token.indexOf("pixels") != -1) {
                int ndx = (token = token.replaceAll("<.*?>", "")).indexOf(58);
                if (ndx != -1) {
                    key = token.substring(0, ndx).trim();
                    value = token.substring(ndx + 1).trim();
                    if (key.equals("Number of steps")) {
                        ms0.sizeZ = Integer.parseInt(value);
                    } else if (key.equals("Image bit depth")) {
                        int bits = Integer.parseInt(value);
                        while (bits % 8 != 0) {
                            ++bits;
                        }
                        ms0.pixelType = FormatTools.pixelTypeFromBytes(bits /= 8, false, false);
                    } else if (key.equals("Image dimensions")) {
                        int n = value.indexOf(44);
                        ms0.sizeX = Integer.parseInt(value.substring(1, n).trim());
                        ms0.sizeY = Integer.parseInt(value.substring(n + 1, value.length() - 1).trim());
                    } else if (key.startsWith("Channel Selection")) {
                        ++ms0.sizeC;
                    } else if (key.startsWith("Microscope XY")) {
                        ++numSeries;
                    }
                    this.addGlobalMeta(key, value);
                }
                if (token.indexOf("pixels") != -1) {
                    ++ms0.sizeC;
                    ms0.imageCount += Integer.parseInt(token.substring(0, token.indexOf(32)));
                    continue;
                }
                if (!token.startsWith("Time Series")) continue;
                int idx = token.indexOf(59) + 1;
                String ss = token.substring(idx, token.indexOf(" ", idx)).trim();
                ms0.sizeT = Integer.parseInt(ss);
                continue;
            }
            if (token.indexOf("Document created") == -1) continue;
            ++estimatedSeriesCount;
            ++estimatedSizeC;
        }
        if (numSeries == 0) {
            numSeries = estimatedSeriesCount;
            ms0.sizeC *= estimatedSizeC;
        }
        if (this.getSizeC() == 0) {
            ms0.sizeC = estimatedSizeC;
        }
        if (this.getSizeC() == 0) {
            ms0.sizeC = 1;
        }
        if (this.getSizeZ() == 0) {
            ms0.sizeZ = 1;
        }
        this.files = new ArrayList<String>();
        int ndx = this.currentId.lastIndexOf(File.separator) + 1;
        String base = this.currentId.substring(ndx, this.currentId.lastIndexOf(" "));
        Location f = new Location(this.currentId).getAbsoluteFile();
        String string = file2 = f.exists() ? f.getParent() + File.separator : "";
        if (numSeries == 0) {
            numSeries = 1;
        }
        for (i = 0; i < this.getSizeC(); ++i) {
            String pixelsFile = file2 + base + " " + (i + 1) + ".xys";
            Location p = new Location(pixelsFile);
            if (p.exists()) {
                this.files.add(p.getAbsolutePath());
                continue;
            }
            if (numSeries > 1) {
                ms0.sizeC -= this.getSizeC() / numSeries;
                --numSeries;
                continue;
            }
            if (this.getSizeC() <= 1) continue;
            --ms0.sizeC;
        }
        this.files.add(this.currentId);
        if (this.getSizeT() == 0) {
            ms0.sizeT = this.getImageCount() / (this.getSizeZ() * this.getSizeC());
            if (this.getSizeT() == 0) {
                ms0.sizeT = 1;
            }
        }
        if (this.getImageCount() == 0) {
            ms0.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        }
        if (numSeries > 1) {
            int x = this.getSizeX();
            int y = this.getSizeY();
            int z = this.getSizeZ();
            int c = this.getSizeC() / numSeries;
            int t = this.getSizeT();
            int count = z * c * t;
            int ptype = this.getPixelType();
            this.core.clear();
            for (int i2 = 0; i2 < numSeries; ++i2) {
                CoreMetadata ms = new CoreMetadata();
                this.core.add(ms);
                ms.sizeX = x;
                ms.sizeY = y;
                ms.sizeZ = z;
                ms.sizeC = c;
                ms.sizeT = t;
                ms.imageCount = count;
                ms.pixelType = ptype;
            }
        }
        for (i = 0; i < this.getSeriesCount(); ++i) {
            CoreMetadata ms = (CoreMetadata)this.core.get(i);
            ms.rgb = false;
            ms.dimensionOrder = "XYZTC";
            ms.interleaved = false;
            ms.littleEndian = true;
            ms.indexed = false;
            ms.falseColor = false;
            ms.metadataComplete = true;
        }
        this.pixelOffsets = new long[this.files.size() - 1];
        for (i = 0; i < this.pixelOffsets.length; ++i) {
            this.pixelOffsets[i] = this.findPixelsOffset(i);
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        for (int i3 = 0; i3 < numSeries; ++i3) {
            store.setImageName("Position " + (i3 + 1), i3);
        }
    }

    private long findPixelsOffset(int fileIndex) throws IOException {
        String file2 = this.files.get(fileIndex);
        long fp = 0L;
        try (RandomAccessInputStream s2 = new RandomAccessInputStream(file2);){
            s2.order(this.isLittleEndian());
            s2.findString(false, HEADER_MARKER);
            int plane = FormatTools.getPlaneSize(this);
            int planeCount = this.getSizeZ() * this.getSizeT();
            long skip = (s2.length() - s2.getFilePointer() - (long)(planeCount * plane)) / (long)planeCount;
            fp = s2.getFilePointer() + skip - (long)HEADER_MARKER.length();
            s2.seek(fp);
            if (s2.readByte() == PIXELS_MARKER[PIXELS_MARKER.length - 1]) {
                ++fp;
            }
        }
        return fp;
    }
}

