/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.trackmanager.blocks;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import java.io.File;
import java.util.List;
import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarMutable;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackManager;

public class LoadTracksFromXML
extends Plugin
implements ROIBlock,
PluginLibrary,
PluginBundled {
    final VarMutable file = new VarMutable("XML file", null){

        public boolean isAssignableFrom(Var source) {
            return String.class == source.getType() || File.class == source.getType();
        }
    };
    final VarInteger groupIndex = new VarInteger("Group index", 0);
    final Var<TrackGroup> tracks = new Var("Track group", (Object)new TrackGroup(null));

    public void run() {
        Object obj = this.file.getValue();
        if (obj == null) {
            return;
        }
        File f = obj instanceof String ? new File((String)obj) : (File)obj;
        List<TrackGroup> groups = TrackManager.loadTracks(f.getAbsolutePath());
        this.tracks.setValue((Object)groups.get(this.groupIndex.getValue()));
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("file", (Var)this.file);
        inputMap.add("groupIndex", (Var)this.groupIndex);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("tracks", this.tracks);
    }

    public String getMainPluginClassName() {
        return TrackManager.class.getName();
    }
}

