/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.Prefs;
import ij.gui.StackWindow;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Panel;
import java.awt.RenderingHints;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class ScrollbarWithLabel
extends Panel
implements Adjustable,
AdjustmentListener {
    Scrollbar bar;
    private Icon icon;
    private StackWindow stackWindow;
    transient AdjustmentListener adjustmentListener;

    public ScrollbarWithLabel() {
    }

    public ScrollbarWithLabel(StackWindow stackWindow, int value, int visible, int minimum, int maximum, char label) {
        super(new BorderLayout(2, 0));
        this.stackWindow = stackWindow;
        this.bar = new Scrollbar(0, value, visible, minimum, maximum);
        this.icon = new Icon(label);
        this.add((Component)this.icon, "West");
        this.add((Component)this.bar, "Center");
        this.bar.addAdjustmentListener(this);
        this.addKeyListener(IJ.getInstance());
    }

    @Override
    public Dimension getPreferredSize() {
        int height;
        int iconHeight;
        Dimension dim = new Dimension(0, 0);
        int width = this.bar.getPreferredSize().width;
        Dimension minSize = this.getMinimumSize();
        if (width < minSize.width) {
            width = minSize.width;
        }
        if ((iconHeight = this.icon.getPreferredSize().height) > (height = this.bar.getPreferredSize().height)) {
            height = iconHeight;
        }
        dim = new Dimension(width, height);
        return dim;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(80, 15);
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
        this.bar.addKeyListener(l);
    }

    @Override
    public synchronized void removeKeyListener(KeyListener l) {
        super.removeKeyListener(l);
        this.bar.removeKeyListener(l);
    }

    @Override
    public synchronized void addAdjustmentListener(AdjustmentListener l) {
        if (l == null) {
            return;
        }
        this.adjustmentListener = AWTEventMulticaster.add(this.adjustmentListener, l);
    }

    @Override
    public int getBlockIncrement() {
        return this.bar.getBlockIncrement();
    }

    @Override
    public int getMaximum() {
        return this.bar.getMaximum();
    }

    @Override
    public int getMinimum() {
        return this.bar.getMinimum();
    }

    @Override
    public int getOrientation() {
        return this.bar.getOrientation();
    }

    @Override
    public int getUnitIncrement() {
        return this.bar.getUnitIncrement();
    }

    @Override
    public int getValue() {
        return this.bar.getValue();
    }

    @Override
    public int getVisibleAmount() {
        return this.bar.getVisibleAmount();
    }

    @Override
    public synchronized void removeAdjustmentListener(AdjustmentListener l) {
        if (l == null) {
            return;
        }
        this.adjustmentListener = AWTEventMulticaster.remove(this.adjustmentListener, l);
    }

    @Override
    public void setBlockIncrement(int b) {
        this.bar.setBlockIncrement(b);
    }

    @Override
    public void setMaximum(int max) {
        this.bar.setMaximum(max);
    }

    @Override
    public void setMinimum(int min) {
        this.bar.setMinimum(min);
    }

    @Override
    public void setUnitIncrement(int u) {
        this.bar.setUnitIncrement(u);
    }

    @Override
    public void setValue(int v) {
        this.bar.setValue(v);
    }

    @Override
    public void setVisibleAmount(int v) {
        this.bar.setVisibleAmount(v);
    }

    @Override
    public void setFocusable(boolean focusable) {
        super.setFocusable(focusable);
        this.bar.setFocusable(focusable);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (this.bar != null && e.getSource() == this.bar) {
            AdjustmentEvent myE = new AdjustmentEvent(this, e.getID(), e.getAdjustmentType(), e.getValue(), e.getValueIsAdjusting());
            AdjustmentListener listener = this.adjustmentListener;
            if (listener != null) {
                listener.adjustmentValueChanged(myE);
            }
        }
    }

    public void updatePlayPauseIcon() {
        this.icon.repaint();
    }

    class Icon
    extends Canvas
    implements MouseListener {
        private final double SCALE = Prefs.getGuiScale();
        private final int WIDTH = (int)(12.0 * this.SCALE);
        private final int HEIGHT = (int)(14.0 * this.SCALE);
        private BasicStroke stroke = new BasicStroke((float)(2.0 * this.SCALE));
        private char type;
        private Image image;

        public Icon(char type) {
            this.addMouseListener(this);
            this.addKeyListener(IJ.getInstance());
            this.setSize(this.WIDTH, this.HEIGHT);
            this.type = type;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.WIDTH, this.HEIGHT);
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.WIDTH, this.HEIGHT);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.type == 't') {
                this.drawPlayPauseButton(g2d);
            } else {
                this.drawLetter(g);
            }
        }

        private void drawLetter(Graphics g) {
            Font font = new Font("SansSerif", 0, 14);
            if (this.SCALE > 1.0) {
                font = font.deriveFont((float)((double)font.getSize() * this.SCALE));
            }
            g.setFont(font);
            g.setColor(Color.black);
            g.drawString(String.valueOf(this.type), (int)(2.0 * this.SCALE), (int)(12.0 * this.SCALE));
        }

        private void drawPlayPauseButton(Graphics2D g) {
            if (ScrollbarWithLabel.this.stackWindow.getAnimate()) {
                g.setColor(Color.black);
                g.setStroke(this.stroke);
                int s3 = (int)(3.0 * this.SCALE);
                int s8 = (int)(8.0 * this.SCALE);
                int s11 = (int)(11.0 * this.SCALE);
                g.drawLine(s3, s3, s3, s11);
                g.drawLine(s8, s3, s8, s11);
            } else {
                g.setColor(Color.darkGray);
                GeneralPath path = new GeneralPath();
                path.moveTo(3.0f, 2.0f);
                path.lineTo(10.0f, 7.0f);
                path.lineTo(3.0f, 12.0f);
                path.lineTo(3.0f, 2.0f);
                if (this.SCALE > 1.0) {
                    AffineTransform at = new AffineTransform();
                    at.scale(this.SCALE, this.SCALE);
                    path = new GeneralPath(at.createTransformedShape(path));
                }
                g.fill(path);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.type != 't') {
                return;
            }
            int flags = e.getModifiers();
            if ((flags & 0xE) != 0) {
                IJ.doCommand("Animation Options...");
            } else {
                IJ.doCommand("Start Animation [\\]");
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }
    }
}

