/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Menus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.ColorModel;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class Concatenator
implements PlugIn,
ItemListener {
    public String pluginName = "Concatenator";
    public int maxEntries = 18;
    private static boolean all_option = false;
    private boolean keep = false;
    private static boolean keep_option = false;
    private boolean batch = false;
    private boolean macro = false;
    private boolean im4D = true;
    private static boolean im4D_option = true;
    private String[] imageTitles;
    private ImagePlus[] images;
    private Vector choices;
    private Checkbox allWindows;
    private final String none = "-- None --";
    private String newtitle = "Untitled";
    private ImagePlus newImp;
    private int stackSize;
    private double min = 0.0;
    private double max = 3.4028234663852886E38;
    private int maxWidth;
    private int maxHeight;
    private boolean showingDialog;

    @Override
    public void run(String arg) {
        boolean bl = this.macro = !arg.equals("");
        if (!this.showDialog()) {
            return;
        }
        this.newImp = this.concatenate(this.images, this.keep);
        if (this.newImp != null) {
            this.newImp.show();
        }
    }

    public ImagePlus run() {
        if (!this.showDialog()) {
            return null;
        }
        this.newImp = this.createHypervol();
        return this.newImp;
    }

    public static ImagePlus run(ImagePlus img1, ImagePlus img2) {
        ImagePlus[] images = new ImagePlus[]{img1, img2};
        return new Concatenator().concatenate(images, false);
    }

    public static ImagePlus run(ImagePlus img1, ImagePlus img2, ImagePlus img3) {
        ImagePlus[] images = new ImagePlus[]{img1, img2, img3};
        return new Concatenator().concatenate(images, false);
    }

    public static ImagePlus run(ImagePlus img1, ImagePlus img2, ImagePlus img3, ImagePlus img4) {
        ImagePlus[] images = new ImagePlus[4];
        images[0] = img1;
        images[1] = img2;
        images[2] = img3;
        images[2] = img4;
        return new Concatenator().concatenate(images, false);
    }

    public static ImagePlus run(ImagePlus img1, ImagePlus img2, ImagePlus img3, ImagePlus img4, ImagePlus img5) {
        ImagePlus[] images = new ImagePlus[5];
        images[0] = img1;
        images[1] = img2;
        images[2] = img3;
        images[2] = img4;
        images[5] = img5;
        return new Concatenator().concatenate(images, false);
    }

    public static ImagePlus run(ImagePlus[] images) {
        return new Concatenator().concatenate(images, false);
    }

    public ImagePlus concatenate(ImagePlus[] ims, boolean keepIms) {
        this.images = ims;
        this.imageTitles = new String[ims.length];
        for (int i = 0; i < ims.length; ++i) {
            if (ims[i] == null) {
                IJ.error(this.pluginName, "Null ImagePlus passed to concatenate(...) method");
                return null;
            }
            this.imageTitles[i] = ims[i].getTitle();
        }
        this.keep = keepIms;
        this.batch = true;
        ImagePlus imp0 = this.images[0];
        this.newImp = imp0.isComposite() || imp0.getNChannels() > 1 ? this.concatenateHyperstacks(this.images, this.newtitle, this.keep) : this.createHypervol();
        if (Recorder.scriptMode()) {
            String args = "imp1";
            for (int i = 1; i < this.images.length; ++i) {
                args = args + ", imp" + (i + 1);
            }
            Recorder.recordCall("imp" + (this.images.length + 1) + " = Concatenator.run(" + args + ");");
        }
        return this.newImp;
    }

    public ImagePlus concatenate(ImagePlus imp1, ImagePlus imp2, boolean keep) {
        this.images = new ImagePlus[2];
        this.images[0] = imp1;
        this.images[1] = imp2;
        return this.concatenate(this.images, keep);
    }

    private ImagePlus createHypervol() {
        boolean firstImage = true;
        Properties[] propertyArr = new Properties[this.images.length];
        ImagePlus currentImp = null;
        ImageStack concat_Stack = null;
        this.stackSize = 0;
        int dataType = 0;
        int width = 0;
        int height = 0;
        Calibration cal = null;
        int count = 0;
        this.findMaxDimensions(this.images);
        for (int i = 0; i < this.images.length; ++i) {
            boolean unequalSizes;
            if (this.images[i] == null) continue;
            currentImp = this.images[i];
            if (firstImage) {
                cal = currentImp.getCalibration();
                width = currentImp.getWidth();
                height = currentImp.getHeight();
                this.stackSize = currentImp.getNSlices();
                dataType = currentImp.getType();
                ColorModel cm = currentImp.getProcessor().getColorModel();
                concat_Stack = new ImageStack(this.maxWidth, this.maxHeight, cm);
                this.min = currentImp.getProcessor().getMin();
                this.max = currentImp.getProcessor().getMax();
                firstImage = false;
            }
            boolean bl = unequalSizes = currentImp.getNSlices() != this.stackSize;
            if (unequalSizes) {
                this.im4D = false;
            }
            if (currentImp.getType() != dataType) {
                IJ.log("Omitting " + this.imageTitles[i] + " - image type not matched");
                continue;
            }
            boolean duplicated = this.isDuplicated(currentImp, i);
            this.concat(concat_Stack, currentImp.getStack(), this.keep || duplicated);
            propertyArr[count] = currentImp.getProperties();
            this.imageTitles[count] = currentImp.getTitle();
            if (!this.keep && !duplicated) {
                currentImp.changes = false;
                currentImp.hide();
            }
            ++count;
        }
        ImagePlus imp = new ImagePlus(this.newtitle, concat_Stack);
        imp.setCalibration(cal);
        imp.setProperty("Number of Stacks", new Integer(count));
        imp.setProperty("Stacks Properties", propertyArr);
        imp.setProperty("Image Titles", this.imageTitles);
        imp.getProcessor().setMinAndMax(this.min, this.max);
        if (this.im4D) {
            imp.setDimensions(1, this.stackSize, imp.getStackSize() / this.stackSize);
            imp.setOpenAsHyperStack(true);
        }
        return imp;
    }

    private void concat(ImageStack stack3, ImageStack stack1, boolean dup) {
        int slice = 1;
        int size = stack1.getSize();
        for (int i = 1; i <= size; ++i) {
            ImageProcessor ip = stack1.getProcessor(slice);
            String label = stack1.getSliceLabel(slice);
            if (dup) {
                ip = ip.duplicate();
                ++slice;
            } else {
                stack1.deleteSlice(slice);
            }
            ImageProcessor ip2 = ip;
            if (ip.getWidth() != this.maxWidth || ip.getHeight() != this.maxHeight) {
                ip2 = ip.createProcessor(this.maxWidth, this.maxHeight);
                ip2.insert(ip, (this.maxWidth - ip.getWidth()) / 2, (this.maxHeight - ip.getHeight()) / 2);
            }
            stack3.addSlice(label, ip2);
        }
    }

    public ImagePlus concatenateHyperstacks(ImagePlus[] images, String newTitle, boolean keep) {
        int n = images.length;
        int width = images[0].getWidth();
        int height = images[0].getHeight();
        int bitDepth = images[0].getBitDepth();
        int channels = images[0].getNChannels();
        int slices = images[0].getNSlices();
        int frames = images[0].getNFrames();
        boolean concatSlices = slices > 1 && frames == 1;
        boolean keepCalibration = true;
        Calibration cal = images[0].getCalibration();
        this.maxWidth = width;
        this.maxHeight = height;
        for (int i = 1; i < n; ++i) {
            if (images[i].getNFrames() > 1) {
                concatSlices = false;
            }
            if (images[i].getBitDepth() != bitDepth || images[i].getNChannels() != channels || !concatSlices && images[i].getNSlices() != slices) {
                IJ.error(this.pluginName, "Images do not all have the same dimensions or type");
                return null;
            }
            Calibration cal2 = images[i].getCalibration();
            if (cal2.pixelWidth != cal.pixelWidth || cal2.pixelHeight != cal.pixelHeight || cal2.pixelDepth != cal.pixelDepth) {
                keepCalibration = false;
            }
            if (images[i].getWidth() > this.maxWidth) {
                this.maxWidth = images[i].getWidth();
            }
            if (images[i].getHeight() <= this.maxHeight) continue;
            this.maxHeight = images[i].getHeight();
        }
        ImageStack stack2 = new ImageStack(this.maxWidth, this.maxHeight);
        int slices2 = 0;
        int frames2 = 0;
        for (int i = 0; i < n; ++i) {
            ImageStack stack = images[i].getStack();
            slices = images[i].getNSlices();
            if (concatSlices) {
                slices = images[i].getNSlices();
                slices2 += slices;
                frames2 = frames;
            } else {
                frames = images[i].getNFrames();
                frames2 += frames;
                slices2 = slices;
            }
            for (int f = 1; f <= frames; ++f) {
                for (int s = 1; s <= slices; ++s) {
                    for (int c = 1; c <= channels; ++c) {
                        int index = (f - 1) * channels * slices + (s - 1) * channels + c;
                        ImageProcessor ip = stack.getProcessor(index);
                        if (keep) {
                            ip = ip.duplicate();
                        }
                        String label = stack.getSliceLabel(index);
                        ImageProcessor ip2 = ip;
                        if (ip.getWidth() != this.maxWidth || ip.getHeight() != this.maxHeight) {
                            ip2 = ip.createProcessor(this.maxWidth, this.maxHeight);
                            ip2.insert(ip, (this.maxWidth - ip.getWidth()) / 2, (this.maxHeight - ip.getHeight()) / 2);
                        }
                        stack2.addSlice(label, ip2);
                    }
                }
            }
        }
        ImagePlus imp2 = new ImagePlus(newTitle, stack2);
        imp2.setDimensions(channels, slices2, frames2);
        if (channels > 1) {
            int mode = 0;
            if (images[0].isComposite()) {
                mode = ((CompositeImage)images[0]).getMode();
            }
            imp2 = new CompositeImage(imp2, mode);
            ((CompositeImage)imp2).copyLuts(images[0]);
        }
        if (channels > 1 && frames2 > 1) {
            imp2.setOpenAsHyperStack(true);
        }
        if (keepCalibration) {
            imp2.setCalibration(cal);
        }
        if (!keep) {
            for (int i = 0; i < n; ++i) {
                images[i].changes = false;
                images[i].close();
            }
        }
        return imp2;
    }

    private boolean showDialog() {
        int[] wList;
        boolean all_windows = false;
        this.batch = Interpreter.isBatchMode();
        boolean bl = this.macro = this.macro || IJ.isMacro() && Macro.getOptions() != null;
        if (Menus.commandInUse("Stack to Image5D") && !this.batch) {
            this.im4D = true;
        }
        boolean bl2 = this.showingDialog = Macro.getOptions() == null;
        if (this.macro) {
            String options = Macro.getOptions();
            if (options.contains("stack1") && options.contains("stack2")) {
                Macro.setOptions(options.replaceAll("stack", "image"));
            }
            int macroImageCount = 0;
            options = Macro.getOptions();
            while (options.contains("image" + (macroImageCount + 1))) {
                ++macroImageCount;
            }
            this.maxEntries = macroImageCount;
        }
        if ((wList = WindowManager.getIDList()) == null) {
            IJ.error("No windows are open.");
            return false;
        }
        if (wList.length < 2) {
            IJ.error("Two or more windows must be open");
            return false;
        }
        int nImages = wList.length;
        String[] titles = new String[nImages];
        String[] titles_none = new String[nImages + 1];
        for (int i = 0; i < nImages; ++i) {
            ImagePlus imp = WindowManager.getImage(wList[i]);
            if (imp != null) {
                titles[i] = imp.getTitle();
                titles_none[i] = imp.getTitle();
                continue;
            }
            titles[i] = "";
            titles_none[i] = "";
        }
        titles_none[nImages] = "-- None --";
        GenericDialog gd = new GenericDialog(this.pluginName);
        gd.addCheckbox("All_open windows", all_option);
        gd.addChoice("Image1:", titles, titles[0]);
        gd.addChoice("Image2:", titles, titles[1]);
        for (int i = 2; i < (nImages + 1 < this.maxEntries ? nImages + 1 : this.maxEntries); ++i) {
            gd.addChoice("Image" + (i + 1) + ":", titles_none, titles_none[i]);
        }
        gd.addStringField("Title:", this.newtitle, 16);
        gd.addCheckbox("Keep original images", keep_option);
        gd.addCheckbox("Open as 4D_image", im4D_option);
        if (!this.macro) {
            this.choices = gd.getChoices();
            Enumeration e = this.choices.elements();
            while (e.hasMoreElements()) {
                ((Choice)e.nextElement()).addItemListener(this);
            }
            Vector v = gd.getCheckboxes();
            this.allWindows = (Checkbox)v.firstElement();
            this.allWindows.addItemListener(this);
            if (all_option) {
                this.itemStateChanged(new ItemEvent(this.allWindows, 701, null, 1));
            }
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        all_option = all_windows = gd.getNextBoolean();
        gd.setSmartRecording(true);
        this.newtitle = gd.getNextString();
        gd.setSmartRecording(false);
        keep_option = this.keep = gd.getNextBoolean();
        im4D_option = this.im4D = gd.getNextBoolean();
        ImagePlus[] tmpImpArr = new ImagePlus[nImages + 1];
        String[] tmpStrArr = new String[nImages + 1];
        int index = 0;
        int count = 0;
        for (int i = 0; i <= nImages; ++i) {
            if (all_windows) {
                index = i;
            } else {
                if (i == (nImages + 1 < this.maxEntries ? nImages + 1 : this.maxEntries)) break;
                gd.setSmartRecording(i == nImages);
                index = gd.getNextChoiceIndex();
            }
            if (index >= nImages) break;
            if (titles[index].equals("")) continue;
            tmpStrArr[count] = titles[index];
            tmpImpArr[count] = WindowManager.getImage(wList[index]);
            ++count;
        }
        if (count < 2) {
            IJ.error(this.pluginName, "Please select at least 2 images");
            return false;
        }
        this.imageTitles = new String[count];
        this.images = new ImagePlus[count];
        System.arraycopy(tmpStrArr, 0, this.imageTitles, 0, count);
        System.arraycopy(tmpImpArr, 0, this.images, 0, count);
        return true;
    }

    boolean isDuplicated(ImagePlus imp, int index) {
        int length = this.images.length;
        if (index >= length - 1) {
            return false;
        }
        for (int i = index + 1; i < length; ++i) {
            if (imp != this.images[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        if (ie.getSource() == this.allWindows) {
            int count = 0;
            if (this.allWindows.getState()) {
                Enumeration e = this.choices.elements();
                while (e.hasMoreElements()) {
                    Choice c = (Choice)e.nextElement();
                    c.select(count++);
                    c.setEnabled(false);
                }
            } else {
                Enumeration e = this.choices.elements();
                while (e.hasMoreElements()) {
                    Choice c = (Choice)e.nextElement();
                    c.setEnabled(true);
                }
            }
        } else {
            boolean foundNone = false;
            Enumeration e = this.choices.elements();
            while (e.hasMoreElements()) {
                Choice c = (Choice)e.nextElement();
                if (!foundNone) {
                    c.setEnabled(true);
                    if (!c.getSelectedItem().equals("-- None --")) continue;
                    foundNone = true;
                    continue;
                }
                c.select("-- None --");
                c.setEnabled(false);
            }
        }
    }

    public void setIm5D(boolean bool) {
        im4D_option = bool;
        this.im4D = bool;
    }

    private void findMaxDimensions(ImagePlus[] images) {
        boolean first = true;
        ImagePlus currentImp = null;
        int dataType = 0;
        this.maxHeight = 0;
        this.maxWidth = 0;
        for (int i = 0; i < images.length; ++i) {
            if (images[i] == null) continue;
            currentImp = images[i];
            if (first) {
                dataType = currentImp.getType();
                first = false;
            }
            if (currentImp.getType() != dataType) continue;
            if (currentImp.getWidth() > this.maxWidth) {
                this.maxWidth = currentImp.getWidth();
            }
            if (currentImp.getHeight() <= this.maxHeight) continue;
            this.maxHeight = currentImp.getHeight();
        }
    }
}

