/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.io.FileSaver;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class JpegWriter
implements PlugIn {
    public static final int DEFAULT_QUALITY = 75;

    @Override
    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return;
        }
        imp.startTiming();
        this.saveAsJpeg(imp, arg, FileSaver.getJpegQuality());
        IJ.showTime(imp, imp.getStartTime(), "JpegWriter: ");
    }

    public static String save(ImagePlus imp, String path, int quality) {
        if (imp == null) {
            imp = IJ.getImage();
        }
        if (path == null || path.length() == 0) {
            path = SaveDialog.getPath(imp, ".jpg");
        }
        if (path == null) {
            return null;
        }
        String error = new JpegWriter().saveAsJpeg(imp, path, quality);
        return error;
    }

    String saveAsJpeg(ImagePlus imp, String path, int quality) {
        int width = imp.getWidth();
        int height = imp.getHeight();
        int biType = 1;
        boolean overlay = imp.getOverlay() != null && !imp.getHideOverlay();
        ImageProcessor ip = imp.getProcessor();
        if (ip.isDefaultLut() && !imp.isComposite() && !overlay && ip.getMinThreshold() == -808080.0) {
            biType = 10;
        }
        BufferedImage bi = new BufferedImage(width, height, biType);
        String error = null;
        try {
            File f2;
            boolean ok;
            Graphics2D g = bi.createGraphics();
            Image img = imp.getImage();
            if (overlay) {
                img = imp.flatten().getImage();
            }
            g.drawImage(img, 0, 0, null);
            g.dispose();
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
            ImageWriter writer = iter.next();
            File f = new File(path);
            String originalPath = null;
            boolean replacing = f.exists();
            if (replacing) {
                originalPath = path;
                path = path + ".temp";
                f = new File(path);
            }
            ImageOutputStream ios = ImageIO.createImageOutputStream(f);
            writer.setOutput(ios);
            ImageWriteParam param = writer.getDefaultWriteParam();
            param.setCompressionMode(2);
            param.setCompressionQuality((float)quality / 100.0f);
            if (quality == 100) {
                param.setSourceSubsampling(1, 1, 0, 0);
            }
            IIOImage iioImage = new IIOImage(bi, null, null);
            writer.write(null, iioImage, param);
            ios.close();
            writer.dispose();
            if (replacing && (ok = (f2 = new File(originalPath)).delete())) {
                f.renameTo(f2);
            }
        }
        catch (Exception e) {
            error = "" + e;
            IJ.error("Jpeg Writer", "" + error);
        }
        return error;
    }

    public static void setQuality(int jpegQuality) {
        FileSaver.setJpegQuality(jpegQuality);
    }

    public static int getQuality() {
        return FileSaver.getJpegQuality();
    }
}

