/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.blocks.tools.roi;

import icy.roi.BooleanMask2D;
import icy.roi.BooleanMask3D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.type.point.Point3D;
import java.awt.Point;
import java.util.ArrayList;
import plugins.adufour.blocks.tools.roi.MorphROI;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.util.VarException;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi3d.ROI3DArea;

public class DilateROI
extends MorphROI {
    public DilateROI() {
        this.roiOUT = new VarROIArray("Dilated ROI");
    }

    @Override
    public void run() {
        try {
            switch ((MorphROI.MorphUnit)((Object)this.unit.getValue())) {
                case PIXELS: {
                    this.roiOUT.setValue((Object)DilateROI.dilateROI((ROI[])this.roiIN.getValue(), (int)this.x.getValue(), (int)this.y.getValue(), (int)this.z.getValue()));
                    break;
                }
                case PERCENTAGE: {
                    this.roiOUT.setValue((Object)DilateROI.dilateROIByPercentage((ROI[])this.roiIN.getValue(), (int)this.x.getValue(), (int)this.y.getValue(), (int)this.z.getValue()));
                    break;
                }
                default: {
                    throw new VarException((Var)this.unit, "Unsupported unit");
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static ROI[] dilateROI(ROI[] inputRoi, int xRadius, int yRadius, int zRadius) throws InterruptedException {
        ArrayList<ROI> out = new ArrayList<ROI>(inputRoi.length);
        for (ROI roi : inputRoi) {
            if (Thread.currentThread().isInterrupted()) break;
            ROI dilated = DilateROI.dilateROI(roi, xRadius, yRadius, zRadius);
            if (dilated == null) continue;
            out.add(dilated);
        }
        return out.toArray(new ROI[out.size()]);
    }

    public static ROI[] dilateROIByPercentage(ROI[] inputRoi, int xPct, int yPct, int zPct) throws InterruptedException {
        ArrayList<ROI> out = new ArrayList<ROI>(inputRoi.length);
        for (ROI roi : inputRoi) {
            if (Thread.currentThread().isInterrupted()) break;
            ROI dilated = DilateROI.dilateROIByPercentage(roi, xPct, yPct, zPct);
            if (dilated == null) continue;
            out.add(dilated);
        }
        return out.toArray(new ROI[out.size()]);
    }

    public static ROI dilateROIByPercentage(ROI roi, int xPct, int yPct, int zPct) throws InterruptedException {
        int xRadius = DilateROI.percentageToRadiusX(roi, xPct);
        int yRadius = DilateROI.percentageToRadiusY(roi, yPct);
        int zRadius = DilateROI.percentageToRadiusZ(roi, zPct);
        return DilateROI.dilateROI(roi, xRadius, yRadius, zRadius);
    }

    public static ROI dilateROI(ROI roi, int xRadius, int yRadius, int zRadius) throws InterruptedException {
        int rx = xRadius;
        int rrx = rx * rx;
        int ry = yRadius;
        int rry = ry * ry;
        int rz = zRadius;
        int rrz = rz * rz;
        if (roi instanceof ROI2D) {
            BooleanMask2D m2 = ((ROI2D)roi).getBooleanMask(true);
            ROI2DArea r2 = new ROI2DArea(m2);
            r2.setC(((ROI2D)roi).getC());
            r2.setZ(((ROI2D)roi).getZ());
            r2.setT(((ROI2D)roi).getT());
            r2.setName(roi.getName() + " dilated[" + xRadius + "," + yRadius + "]");
            r2.beginUpdate();
            for (Point p : m2.getContourPoints()) {
                for (int y = -ry; y <= ry; ++y) {
                    for (int x = -rx; x <= rx; ++x) {
                        double yr2;
                        double xr2 = rrx == 0 ? 0.0 : (double)(x * x / rrx);
                        double d = yr2 = rry == 0 ? 0.0 : (double)(y * y / rry);
                        if (!(xr2 + yr2 <= 1.0) || m2.contains(p.x + x, p.y + y)) continue;
                        r2.addPoint(p.x + x, p.y + y);
                    }
                }
            }
            r2.endUpdate();
            return r2;
        }
        if (roi instanceof ROI3D) {
            ROI3D roi3D = (ROI3D)roi;
            BooleanMask3D m3 = roi3D.getBooleanMask(true);
            ROI3DArea r3 = new ROI3DArea(m3);
            r3.setC(((ROI3D)roi).getC());
            r3.setT(((ROI3D)roi).getT());
            r3.setName(roi.getName() + " dilated[" + xRadius + "," + yRadius + "," + zRadius + "]");
            r3.beginUpdate();
            for (Point3D.Integer p : m3.getContourPoints()) {
                double yr2;
                double xr2;
                int x;
                int y;
                int z;
                if (rrz == 0) {
                    z = 0;
                    for (y = -ry; y <= ry; ++y) {
                        for (x = -rx; x <= rx; ++x) {
                            xr2 = rrx == 0 ? 0.0 : (double)(x * x / rrx);
                            double d = yr2 = rry == 0 ? 0.0 : (double)(y * y / rry);
                            if (!(xr2 + yr2 <= 1.0) || m3.contains(p.x + x, p.y + y, p.z + z)) continue;
                            r3.addPoint(p.x + x, p.y + y, p.z + z);
                        }
                    }
                    continue;
                }
                for (z = -rz; z <= rz; ++z) {
                    for (y = -ry; y <= ry; ++y) {
                        for (x = -rx; x <= rx; ++x) {
                            double zr2;
                            xr2 = rrx == 0 ? 0.0 : (double)(x * x / rrx);
                            yr2 = rry == 0 ? 0.0 : (double)(y * y / rry);
                            double d = zr2 = rrz == 0 ? 0.0 : (double)(z * z / rrz);
                            if (!(xr2 + yr2 + zr2 <= 1.0) || m3.contains(p.x + x, p.y + y, p.z + z)) continue;
                            r3.addPoint(p.x + x, p.y + y, p.z + z);
                        }
                    }
                }
            }
            r3.endUpdate();
            r3.optimizeBounds();
            return r3;
        }
        System.out.println("[Dilate ROI] Warning: unsupported ROI: " + roi.getName());
        return null;
    }
}

