/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dht;

import java.util.concurrent.Future;
import org.jtransforms.fft.FloatFFT_1D;
import org.jtransforms.utils.CommonUtils;
import org.jtransforms.utils.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.FloatLargeArray;
import pl.edu.icm.jlargearrays.Utilities;

public class FloatDHT_1D {
    private final int n;
    private final long nl;
    private final FloatFFT_1D fft;
    private final boolean useLargeArrays;

    public FloatDHT_1D(long l) {
        this.n = (int)l;
        this.nl = l;
        this.useLargeArrays = l >= ConcurrencyUtils.getLargeArraysBeginN();
        this.fft = new FloatFFT_1D(l);
    }

    public void forward(float[] fArray) {
        this.forward(fArray, 0);
    }

    public void forward(FloatLargeArray floatLargeArray) {
        this.forward(floatLargeArray, 0L);
    }

    public void forward(final float[] fArray, final int n) {
        if (this.n == 1) {
            return;
        }
        if (this.useLargeArrays) {
            this.forward(new FloatLargeArray(fArray), (long)n);
        } else {
            this.fft.realForward(fArray, n);
            final float[] fArray2 = new float[this.n];
            System.arraycopy(fArray, n, fArray2, 0, this.n);
            int n2 = this.n / 2;
            int n3 = ConcurrencyUtils.getNumberOfThreads();
            if (n3 > 1 && (long)n2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                n3 = 2;
                int n4 = n2 / n3;
                Future[] futureArray = new Future[n3];
                for (int i = 0; i < n3; ++i) {
                    final int n5 = 1 + i * n4;
                    final int n6 = i == n3 - 1 ? n2 : n5 + n4;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = n5; i < n6; ++i) {
                                int n3 = 2 * i;
                                int n2 = n3 + 1;
                                fArray[n + i] = fArray2[n3] - fArray2[n2];
                                fArray[n + ((FloatDHT_1D)FloatDHT_1D.this).n - i] = fArray2[n3] + fArray2[n2];
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 1; i < n2; ++i) {
                    int n7 = 2 * i;
                    int n8 = n7 + 1;
                    fArray[n + i] = fArray2[n7] - fArray2[n8];
                    fArray[n + this.n - i] = fArray2[n7] + fArray2[n8];
                }
            }
            if (this.n % 2 == 0) {
                fArray[n + n2] = fArray2[1];
            } else {
                fArray[n + n2] = fArray2[this.n - 1] - fArray2[1];
                fArray[n + n2 + 1] = fArray2[this.n - 1] + fArray2[1];
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void forward(final FloatLargeArray floatLargeArray, final long l) {
        if (this.nl == 1L) {
            return;
        }
        if (!this.useLargeArrays) {
            if (floatLargeArray.getData() == null || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.forward(floatLargeArray.getData(), (int)l);
            return;
        } else {
            this.fft.realForward(floatLargeArray, l);
            final FloatLargeArray floatLargeArray2 = new FloatLargeArray(this.nl, false);
            Utilities.arraycopy(floatLargeArray, l, floatLargeArray2, 0L, this.nl);
            long l2 = this.nl / 2L;
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && l2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                n = 2;
                long l3 = l2 / (long)n;
                Future[] futureArray = new Future[n];
                for (int i = 0; i < n; ++i) {
                    final long l4 = 1L + (long)i * l3;
                    final long l5 = i == n - 1 ? l2 : l4 + l3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i = l4; i < l5; ++i) {
                                long l3 = 2L * i;
                                long l2 = l3 + 1L;
                                floatLargeArray.setFloat(l + i, floatLargeArray2.getFloat(l3) - floatLargeArray2.getFloat(l2));
                                floatLargeArray.setFloat(l + FloatDHT_1D.this.nl - i, floatLargeArray2.getFloat(l3) + floatLargeArray2.getFloat(l2));
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (long i = 1L; i < l2; ++i) {
                    long l6 = 2L * i;
                    long l7 = l6 + 1L;
                    floatLargeArray.setFloat(l + i, floatLargeArray2.getFloat(l6) - floatLargeArray2.getFloat(l7));
                    floatLargeArray.setFloat(l + this.nl - i, floatLargeArray2.getFloat(l6) + floatLargeArray2.getFloat(l7));
                }
            }
            if (this.nl % 2L == 0L) {
                floatLargeArray.setFloat(l + l2, floatLargeArray2.getFloat(1L));
                return;
            } else {
                floatLargeArray.setFloat(l + l2, floatLargeArray2.getFloat(this.nl - 1L) - floatLargeArray2.getFloat(1L));
                floatLargeArray.setFloat(l + l2 + 1L, floatLargeArray2.getFloat(this.nl - 1L) + floatLargeArray2.getFloat(1L));
            }
        }
    }

    public void inverse(float[] fArray, boolean bl) {
        this.inverse(fArray, 0, bl);
    }

    public void inverse(FloatLargeArray floatLargeArray, boolean bl) {
        this.inverse(floatLargeArray, 0L, bl);
    }

    public void inverse(float[] fArray, int n, boolean bl) {
        if (this.n == 1) {
            return;
        }
        if (this.useLargeArrays) {
            this.inverse(new FloatLargeArray(fArray), (long)n, bl);
        } else {
            this.forward(fArray, n);
            if (bl) {
                CommonUtils.scale(this.n, 1.0f / (float)this.n, fArray, n, false);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void inverse(FloatLargeArray floatLargeArray, long l, boolean bl) {
        if (this.n == 1) {
            return;
        }
        if (!this.useLargeArrays) {
            if (floatLargeArray.getData() == null || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.inverse(floatLargeArray.getData(), (int)l, bl);
            return;
        } else {
            this.forward(floatLargeArray, l);
            if (!bl) return;
            CommonUtils.scale((long)this.n, 1.0f / (float)this.n, floatLargeArray, l, false);
        }
    }
}

