package plugins.lagache.colocalizationstudio;

import flanagan.analysis.Stat;
import icy.file.FileUtil;
import icy.gui.frame.progress.AnnounceFrame;

import icy.main.Icy;
import icy.roi.BooleanMask3D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.roi.ROIUtil;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import icy.type.point.Point3D;
import icy.type.point.Point5D;
import icy.util.StringUtil;
import icy.util.XLSUtil;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

import javax.swing.JSeparator;

import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

import plugins.adufour.ezplug.EzButton;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzLabel;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarEnum;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarSwimmingObject;
import plugins.adufour.ezplug.EzVarText;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.kernel.roi.roi2d.ROI2DRectangle;
import plugins.kernel.roi.roi3d.ROI3DArea;
import plugins.lagache.sodasuite.Methods_Correlation;
import plugins.lagache.sodasuite.Methods_distance;
import plugins.lagache.sodasuite.Methods_overlap;
import plugins.lagache.sodasuite.Ripley2D;
import plugins.lagache.sodasuite.Ripley3D;
import plugins.lagache.sodasuite.SODAblock;
import plugins.lagache.sodasuite.Window2D;
import plugins.lagache.sodasuite.Window3D;
import plugins.lagache.sodasuite.non_parametric_object;
import plugins.nchenouard.spot.*;

// Colocalisation with Ripley function K
// Significant 

public class ColocalizationStudio extends EzPlug implements ActionListener , SequenceListener {
		
	EzButton setTrackSetA = new EzButton("Select ROIs manually ?", this);
	EzButton reset = new EzButton("Reset ROIs ", this);	
	ROI[] coloc_roi_1 = null; 
	ROI[] coloc_roi_2 =null;
	
	ArrayList<ROI> liste_roi = new ArrayList<ROI>();		

	private enum ColocMethod
    {
        CORRELATION, OBJECT
    }
	
	private EzVarEnum<ColocMethod> method        = new EzVarEnum<ColocMethod>("METHOD (CORRELATION or OBJECT)", ColocMethod.values(), ColocMethod.CORRELATION);
    
	EzVarSequence sequence1 = new EzVarSequence("Sequence 1");
	EzVarSequence sequence2 = new EzVarSequence("Sequence 2");
	EzVarInteger channel1 = new EzVarInteger("Channel 1");
	EzVarInteger channel2 = new EzVarInteger("Channel 2");
	
	EzVarSwimmingObject<DetectionResult> detections1 = new EzVarSwimmingObject<DetectionResult>(
			"Detections1");
	EzVarSwimmingObject<DetectionResult> detections2 = new EzVarSwimmingObject<DetectionResult>(
			"Detections2");

	//ROIs (spots) qui colocalisent en sortie
	EzVarBoolean export_colocalized_rois = new EzVarBoolean("Export colocalized detections (ROIs)", false);
		
	private EzVarInteger MC = new EzVarInteger("Nb of Monte-Carlo Simulations for p-value",10,1,10000,1);
	
	private EzVarDouble pearson_coeff = new EzVarDouble("Pearson R", 1, 0, 1, 0.1);
	private EzVarText pearson_coeff_label = new EzVarText("Pearson R", "   N/A   ");		
	private EzVarDouble pvalue_pearson = new EzVarDouble("p-value Pearson (closed formula)", 1, 0, 1, 0.1);
	private EzVarText pvalue_pearson_label = new EzVarText("p-value Pearson (closed formula)", "   N/A   ");
	private EzVarDouble log_pvalue_pearson = new EzVarDouble("log p-value Pearson", 1, 0, 1, 0.1);
	private EzVarText log_pvalue_pearson_label = new EzVarText("log p-value Pearson", "   N/A   ");
	
	
	private EzVarDouble M1 = new EzVarDouble("Manders M1", 1, 0, 1, 0.1);
	private EzVarText M1_label = new EzVarText("Manders M1", "   N/A   ");
	private EzVarDouble M1_sim = new EzVarDouble("M1 (Mean of simulations)", 1, 0, 1, 0.1);
	private EzVarText M1_sim_label = new EzVarText("M1 (Mean of simulations)", "   N/A   ");
	
	private EzVarDouble M2 = new EzVarDouble("Manders M2", 1, 0, 1, 0.1);
	private EzVarText M2_label = new EzVarText("Manders M2", "   N/A   ");
	private EzVarDouble M2_sim = new EzVarDouble("M2 (Mean of simulations)", 1, 0, 1, 0.1);
	private EzVarText M2_sim_label = new EzVarText("M2 (Mean of simulations)", "   N/A   ");
	
	private EzVarDouble pvalue_M1 = new EzVarDouble("p-value Manders 1 (Monte-Carlo simulations)", 1, 0, 1, 0.1);
	private EzVarText pvalue_M1_label = new EzVarText("p-value Manders 1 (MC simulations)", "   N/A   ");	
	private EzVarDouble log_pvalue_M1 = new EzVarDouble("log p-value Manders 1", 1, 0, 1, 0.1);
	private EzVarText log_pvalue_M1_label = new EzVarText("log p-value Manders 1", "   N/A   ");	
	private EzVarDouble pvalue_M2 = new EzVarDouble("p-value Manders 2 (Monte-Carlo simulations)", 1, 0, 1, 0.1);
	private EzVarText pvalue_M2_label = new EzVarText("p-value Manders 2 (MC simulations)", "   N/A   ");	
	private EzVarDouble log_pvalue_M2 = new EzVarDouble("log p-value Manders 2", 1, 0, 1, 0.1);
	private EzVarText log_pvalue_M2_label = new EzVarText("log p-value Manders 2", "   N/A   ");	
	
	
	private EzVarDouble ICCS1=new EzVarDouble("Cross-Correlation 1", 0, 0, 1, 0.01);
	private EzVarText ICCS1_label = new EzVarText("Cross-Correlation 1", "   N/A   ");
	private EzVarDouble ICCS2=new EzVarDouble("Cross-Correlation 2", 0, 0, 1, 0.01);
	private EzVarText ICCS2_label = new EzVarText("Cross-Correlation 2", "   N/A   ");
	
	private EzVarDouble overlap_param = new EzVarDouble("Overlap threshold (T)", 0.5, 0, 1, 0.01);
	private EzVarDouble overlap_coeff_1 = new EzVarDouble("Overlap 1 (% (1 overlap 2) > Threshold)", 1, 0, 1, 0.1);
	private EzVarText overlap_coeff_1_label = new EzVarText("Overlap 1 (% (1 overlap 2) > Threshold)", "   N/A   ");		
	private EzVarDouble overlap_coeff_2 = new EzVarDouble("Overlap 2 (% (2 overlap 1) > Threshold)", 1, 0, 1, 0.1);
	private EzVarText overlap_coeff_2_label = new EzVarText("Overlap 2 (% (2 overlap 1) > Threshold)", "   N/A   ");			
	private EzVarDouble overlap_coeff_1_sim = new EzVarDouble("Overlap 1 (Mean of simulations)", 1, 0, 1, 0.1);
	private EzVarText overlap_coeff_1_sim_label = new EzVarText("Overlap 1 (Mean of simulations)", "   N/A   ");		
	private EzVarDouble overlap_coeff_2_sim = new EzVarDouble("Overlap 2 (Mean of simulations)", 1, 0, 1, 0.1);
	private EzVarText overlap_coeff_2_sim_label = new EzVarText("Overlap 2 (Mean of simulations)", "   N/A   ");			
	
	private EzVarDouble pvalue_overlap1 = new EzVarDouble("p-value Overlap 1 (MC simulations)", 1, 0, 1, 0.1);
	private EzVarText pvalue_overlap1_label = new EzVarText("p-value Overlap 1 (MC simulations)", "   N/A   ");
	private EzVarDouble log_pvalue_overlap1 = new EzVarDouble("log p-value Overlap 1", 1, 0, 1, 0.1);
	private EzVarText log_pvalue_overlap1_label = new EzVarText("log p-value Overlap 1", "   N/A   ");
	private EzVarDouble pvalue_overlap2 = new EzVarDouble("p-value Overlap 2 (MC simulations)", 1, 0, 1, 0.1);
	private EzVarText pvalue_overlap2_label = new EzVarText("p-value Overlap 2 (MC simulations)", "   N/A   ");
	private EzVarDouble log_pvalue_overlap2 = new EzVarDouble("log p-value Overlap 2", 1, 0, 1, 0.1);
	private EzVarText log_pvalue_overlap2_label = new EzVarText("log p-value Overlap 2", "   N/A   ");
	
	
	private EzVarDouble alpha_inside=new EzVarDouble("% of spots 1 inside masks of spots 2",1,0,1,0.01);
	private EzVarText alpha_inside_label = new EzVarText("% of spots 2 (center of mass) inside spots 1 masks", "   N/A   ");
	private EzVarDouble alpha_inside_sim=new EzVarDouble("% of 1 inside 2 (Mean of simulations)",1,0,1,0.01);
	private EzVarText alpha_inside_sim_label = new EzVarText("% of 1 inside 2 (Mean of simulations)", "   N/A   ");
	
	private EzVarDouble p_value_inside = new EzVarDouble("p-value spots 1 inside 2 (closed formula)");
	private EzVarText p_value_inside_label = new EzVarText("p-value spots 1 inside 2 (closed formula)", "   N/A   ");
	private EzVarDouble log_p_value_inside = new EzVarDouble("log p-value spots 1 inside 2");
	private EzVarText log_p_value_inside_label = new EzVarText("log p-value spots 1 inside 2", "   N/A   ");
	
	
	private EzVarDouble max_radius;	
	private EzVarDouble step;			
	
	private EzVarDouble alpha_fit=new EzVarDouble("% of spots 2 coupled with spots 1 (fit)",1,0,1,0.01);
	private EzVarText alpha_fit_label = new EzVarText("% of coloc. spots 2", "   N/A   ");
	private EzVarDouble mu_fit=new EzVarDouble("Mean coloc. distance (fit)",0,0,20,0.1);;
	private EzVarText mu_fit_label = new EzVarText("Mean coloc. distance (pixels)", "   N/A   ");
	private EzVarDouble sigma_fit=new EzVarDouble("std. dev. of coloc. distance",0,0,20,0.1);
	private EzVarText sigma_fit_label = new EzVarText("Std. dev. of coloc. distance (Fit of the K function, in pixels)", "   N/A   ");
	
	private EzVarDouble alpha_soda=new EzVarDouble("% of spots 2 coupled with spots 1 (SODA)",1,0,1,0.01);
	private EzVarText alpha_soda_label = new EzVarText("% of spots 2 coloc. with spots 1", "   N/A   ");
	private EzVarDouble mu_soda=new EzVarDouble("Mean coloc. distance (SODA)",0,0,20,0.1);;;
	private EzVarText mu_soda_label = new EzVarText("Mean colocalization distance (SODA) (pixels)", "   N/A   ");
	
	private EzVarDouble sup_K=new EzVarDouble("Max. of K function",0,0,100,1);
	private EzVarText sup_K_label = new EzVarText("Max. of K function", "   N/A   ");
	private EzVarDouble p_value_K=new EzVarDouble("p-value SODA (closed formula)",0,0,100,1);
	private EzVarText p_value_K_label = new EzVarText("p-value SODA (closed formula)", "   N/A   ");
	private EzVarDouble log_p_value_K=new EzVarDouble("log p-value SODA",0,0,100,1);
	private EzVarText log_p_value_K_label = new EzVarText("log p-value SODA", "   N/A   ");
	
	
	private EzVarBoolean graph = new EzVarBoolean("Plot the the Ripley's K function (to check check)", false);
	//variables globales pour le graphe
	private  ArrayList<Double> distance_fit = new ArrayList<Double>(); 
	private  ArrayList<Double> K = new ArrayList<Double>();
	private  ArrayList<Double> K_fit = new ArrayList<Double>();
	ChartPanel chartpanel;

	
	protected EzVarBoolean exportExcel = new EzVarBoolean("Export to Excel",false);
	protected EzVarFile exportExcelFile = new EzVarFile("Excel file", "");

	double[] results = null;
	int N_h;
	// pour le test stat
	double mindist;

	private void betaCorrection(double pas, int nbN) {

		Double valN = 1 / (1 / (double) nbN);
		N_h = valN.intValue() + 1; // / ATTENTION AUX BORNES

		double[] alpha = new double[N_h + 1];
		results = new double[N_h + 1];

		for (int i = 0; i < results.length; i++) {
			results[i] = 0;
			alpha[i] = 0.0d;

		}

		for (int i = 1; i < results.length; i++) {
			alpha[i] = (i / (double) N_h);
		}
		for (int i = 0; i < results.length; i++) {
			double h, j;
			for (h = alpha[i] + (pas), j = 2; h <= 1; j++) {
				results[i] = results[i] + h * pas
						/ (1 - 1 / Math.PI * Math.acos(alpha[i] / h));
				h = alpha[i] + (j * pas);
			}

			results[i] = results[i] * 2 + alpha[i] * alpha[i];
		}

	}
					

			
	private void performAnalysis(EzVarSequence sequence_1,EzVarSequence sequence_2,EzVarInteger channel1,EzVarInteger channel2
			,EzVarSwimmingObject<DetectionResult> detections,EzVarSwimmingObject<DetectionResult> detections2, EzVarBoolean exportExcel) {

		//initialisation excel
		int row = 0;		
		WritableWorkbook WW = null;
		WritableSheet WS = null;
		if (exportExcel.getValue()) {
			int page = 1;
			try {
				File f = exportExcelFile.getValue(true);
				if (!FileUtil.getFileExtension(f.getPath(), false)
						.equalsIgnoreCase("xls"))
					f = new File(f.getPath() + ".xls");
				WW = XLSUtil.loadWorkbookForWrite(f); 
				}							
			 catch (Exception e) {
				e.printStackTrace();
				return;}			
			WS  = XLSUtil.createNewPage(WW, "Page" + page);
			XLSUtil.setCellString(WS, 0, 0, "Date of XLS page:");
			row++;
			XLSUtil.setCellString(WS, 0, row, new Date().toString());			
			row++;}

		
							
		Sequence sequence = sequence_1.getValue();
		Sequence sequence2 = sequence_2.getValue();
		int numT;
		if (sequence!=null){
		numT=sequence.getSizeT();}else {return;}
		int dim =2;
		if (sequence.getSizeZ()>1)
		dim = 3;
		ArrayList<ROI> list_roi=new ArrayList<ROI>();
		//gestion des rois d'analyse en entr�e		
		if (liste_roi.isEmpty())
		{			
			for (int t = 0; t < sequence.getSizeT(); t++) {
				ROI roi = null;

				ROI2DRectangle r = new ROI2DRectangle(sequence.getBounds2D());
				for (int h = 0; h < sequence.getSizeZ(); h++) {
					r.setZ(h);
					r.setT(t);
					roi = r.getUnion(roi);
				}
				list_roi.add(roi);
			}
		} 
		else
			for (ROI roi : liste_roi) {
				list_roi.add(roi);
			}

		// on teste si les dimension en c sonts compatible
		double c1 = list_roi.get(0).getPosition5D().getC();
		for (ROI r : list_roi) {
			double c = r.getPosition5D().getC();
			if ((c != c1) && (c != (-1))) {
				new AnnounceFrame("ROI channels are incompatibles");
				return;
			}
		}

		// on teste si les dimensions en temps/z sont incompatibles pour une
		// union
		boolean one_z = false;
		boolean all_z = true;

		for (ROI r : list_roi) {
			if (r.getBounds5D().isInfiniteZ() == false) {
				all_z = false;
			}
			if (r.getBounds5D().isInfiniteZ()) {
				one_z = true;
			}
		}
		// gestion de l'exception
		if (one_z == true && all_z == false) {
			new AnnounceFrame("Incompatibility in Z dimensions between ROIs");
			return;
		}
	//définition du ration pixel z/pixel x
		double ratio_zx = 1.0;
		if (sequence.getSizeZ() > 1) {
			ratio_zx = sequence.getPixelSizeZ() / sequence.getPixelSizeX();
		}
		// init
		//on recupere les spots pour l'analyse overlap et manders
		DetectionResult detect_=null;
		DetectionResult detect2_=null;
		if ((detections.getValue()!=null)&(detections2.getValue()!=null)){
    	detect_ = (DetectionResult) detections.getValue().getObject();
    	detect2_ = (DetectionResult) detections2.getValue().getObject();}
    	
		/////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
			
switch (method.getValue())
{
    case CORRELATION:
    	if (exportExcel.getValue()) {    		
    		XLSUtil.setCellString(WS, 0, row, "Time");
    		XLSUtil.setCellString(WS, 1, row, "Pearson coefficient");
    		XLSUtil.setCellString(WS, 2, row, "p-value (Pearson)");
    		XLSUtil.setCellString(WS, 3, row, "log p-value (Pearson)");
    		XLSUtil.setCellString(WS, 4, row, "ICCS1");
    		XLSUtil.setCellString(WS, 5, row, "ICCS2");	
    		if ((detect_!=null)&(detect2_!=null)){
    		XLSUtil.setCellString(WS, 6, row, "Manders M1");    		
    		XLSUtil.setCellString(WS, 7, row, "Manders M2");
    		XLSUtil.setCellString(WS, 8, row, "Nb of Monte-Carlo simulations");
    		XLSUtil.setCellString(WS, 9, row, "M1 (Mean of simulations)");    		
    		XLSUtil.setCellString(WS, 10, row, "M2 (Mean of simulations)");    		
    		XLSUtil.setCellString(WS, 11, row, "p-value M1>simulations");
    		XLSUtil.setCellString(WS, 12, row, "log p-value M1>simulations");
    		XLSUtil.setCellString(WS, 13, row, "p-value M2>simulations");
    		XLSUtil.setCellString(WS, 14, row, "log p-value M2>simulations");
    		XLSUtil.setCellString(WS, 15, row, "Overlap threshold T");
    		XLSUtil.setCellString(WS, 16, row, "% of 1 that overlap 2 > T");    		
    		XLSUtil.setCellString(WS, 17, row, "% of 2 that overlap 1 > T");
    		XLSUtil.setCellString(WS, 18, row, "Overlap 1 (Mean of simulations)");    		
    		XLSUtil.setCellString(WS, 19, row, "Overlap 2 (Mean of simulations");    		
    		XLSUtil.setCellString(WS, 20, row, "p-value (Overlap 1>simulations)");
    		XLSUtil.setCellString(WS, 21, row, "log p-value (Overlap 1>simulations)");
    		XLSUtil.setCellString(WS, 22, row, "p-value (Overlap 2>simulations)");
    		XLSUtil.setCellString(WS, 23, row, "log p-value (Overlap 2>simulations)");}
    		row++;}		
    	
    	//on fait ensuite une boucle en temps
    	   for (int t=0;t<numT;t++)
    	   {
    		 //computation of the cell mask at time t
    		   ArrayList<ROI> roi_t = SODAblock.ROI_t(dim,list_roi,t,-1);	   
    		   if (roi_t.size()==0)
    			{}
    		   else{			
    		//calcul du volume de la région d'étude
    			   double volume_t = ROIUtil.getUnion(roi_t).getNumberOfPoints() * ratio_zx;
    				if (ROIUtil.getUnion(roi_t).getBounds5D().isInfiniteZ()) {
    					volume_t = volume_t * sequence.getSizeZ() * ratio_zx;
    				}
    				// on récupère les spots au temps t
    				
    				if ((detect_!=null)&(detect2_!=null)){
    				Vector<Spot> spots1=detect_.getDetectionsAtT(t);
    				Vector<Spot> spots2=detect2_.getDetectionsAtT(t);    				
    				//on transforme chaque liste de spots en un tableau de ROIs
    				ArrayList<ROI> spots1_liste = new ArrayList<ROI>();
    				ArrayList<ROI> spots2_liste = new ArrayList<ROI>();						
    				for (Spot s1:spots1){
    					Point3D[] pt_array = new Point3D[s1.point3DList.size()];
    					int ind=0;
    					for (plugins.nchenouard.spot.Point3D pt:s1.point3DList){
    						Point3D pt1= new Point3D.Double(pt.x, pt.y, pt.z);
    						pt_array[ind]=pt1;ind++;
    					}
    						BooleanMask3D bm3d = new BooleanMask3D(pt_array);
    						ROI3DArea r3d = new ROI3DArea(bm3d);r3d.setT(t);
    						spots1_liste.add(r3d);					
    					}
    				for (Spot s2:spots2){									 
    					Point3D[] pt_array = new Point3D[s2.point3DList.size()];
    					int ind=0;
    					for (plugins.nchenouard.spot.Point3D pt:s2.point3DList){
    						Point3D pt1= new Point3D.Double(pt.x, pt.y, pt.z);
    						pt_array[ind]=pt1;ind++;
    					}
    						BooleanMask3D bm3d = new BooleanMask3D(pt_array);
    						ROI3DArea r3d = new ROI3DArea(bm3d);r3d.setT(t);
    						spots2_liste.add(r3d);		
    				}	
    				double manders[] = new double[8];					
					manders = Methods_overlap.Manders(sequence, spots1_liste, spots2_liste,roi_t,MC.getValue(), t);			
					M1.setValue(manders[0]);
					M1_label.setValue(StringUtil.toString(manders[0],2));
					M2.setValue(manders[1]);
					M2_label.setValue(StringUtil.toString(manders[1],2));								
					M1_sim.setValue(manders[2]);
					M1_sim_label.setValue(StringUtil.toString(manders[2],2));
					M2_sim.setValue(manders[3]);
					M2_sim_label.setValue(StringUtil.toString(manders[3],2));													
					pvalue_M1.setValue(manders[4]);
					pvalue_M1_label.setValue(StringUtil.toString(manders[4],2));
					log_pvalue_M1.setValue(manders[5]);
					log_pvalue_M1_label.setValue(StringUtil.toString(manders[5],2));
					pvalue_M2.setValue(manders[6]);
					pvalue_M2_label.setValue(StringUtil.toString(manders[6],2));
					log_pvalue_M2.setValue(manders[7]);
					log_pvalue_M2_label.setValue(StringUtil.toString(manders[7],2));					
					
					double overlap[] = new double[8];
					overlap = Methods_overlap.Overlap(sequence, spots1_liste, spots2_liste, roi_t, MC.getValue(), t, overlap_param.getValue());
					overlap_coeff_1.setValue(overlap[0]);
					overlap_coeff_1_label.setValue(StringUtil.toString(overlap[0],2));
					overlap_coeff_2.setValue(overlap[1]);
					overlap_coeff_2_label.setValue(StringUtil.toString(overlap[1],2));								
					overlap_coeff_1_sim.setValue(overlap[2]);
					overlap_coeff_1_sim_label.setValue(StringUtil.toString(overlap[2],2));
					overlap_coeff_2_sim.setValue(overlap[3]);
					overlap_coeff_2_sim_label.setValue(StringUtil.toString(overlap[3],2));													
					pvalue_overlap1.setValue(overlap[4]);
					pvalue_overlap1_label.setValue(StringUtil.toString(overlap[4],2));
					log_pvalue_overlap1.setValue(overlap[5]);
					log_pvalue_overlap1_label.setValue(StringUtil.toString(overlap[5],2));
					pvalue_overlap2.setValue(overlap[6]);
					pvalue_overlap2_label.setValue(StringUtil.toString(overlap[6],2));
					log_pvalue_overlap2.setValue(overlap[7]);
					log_pvalue_overlap2_label.setValue(StringUtil.toString(overlap[7],2));}
    				
    				double pearson[] = Methods_Correlation.pearson_TCL_withC(sequence_1.getValue(), sequence_2.getValue(),channel1.getValue(),channel2.getValue(),t,roi_t);
    				pearson_coeff.setValue(pearson[0]);
    				pearson_coeff_label.setValue(StringUtil.toString(pearson[0],2));			
    				pvalue_pearson.setValue(pearson[2]);
    				pvalue_pearson_label.setValue(StringUtil.toString(pearson[2],2));
    				log_pvalue_pearson.setValue(pearson[1]);
    				log_pvalue_pearson_label.setValue(StringUtil.toString(pearson[1],2));
			
			
    				double results_iccs[] = Methods_Correlation.ICCS_compute(sequence_1.getValue(), sequence_2.getValue(),channel1.getValue(),channel2.getValue(),t,roi_t);
    				ICCS1.setValue(results_iccs[0]);
    				ICCS1_label.setValue(StringUtil.toString(results_iccs[0],2));			
    				ICCS2.setValue(results_iccs[1]);
    				ICCS2_label.setValue(StringUtil.toString(results_iccs[1],2));
			
																				
			//export excel
			if (exportExcel.getValue()) {
				XLSUtil.setCellNumber(WS, 0, row, t);
				XLSUtil.setCellNumber(WS, 1,row,pearson_coeff.getValue());
				XLSUtil.setCellNumber(WS, 2,row,pvalue_pearson.getValue());
				XLSUtil.setCellNumber(WS, 3,row,log_pvalue_pearson.getValue());
				XLSUtil.setCellNumber(WS, 4,row,ICCS1.getValue()); 
				XLSUtil.setCellNumber(WS, 5,row,ICCS2.getValue());	
				if ((detect_!=null)&(detect2_!=null)){
				XLSUtil.setCellNumber(WS, 6,row,M1.getValue()); 
				XLSUtil.setCellNumber(WS, 7,row,M2.getValue());
				XLSUtil.setCellNumber(WS, 8,row,MC.getValue());
				XLSUtil.setCellNumber(WS, 9,row,M1_sim.getValue()); 
				XLSUtil.setCellNumber(WS, 10,row,M2_sim.getValue());				
				XLSUtil.setCellNumber(WS, 11,row,pvalue_M1.getValue());
				XLSUtil.setCellNumber(WS, 12,row,log_pvalue_M1.getValue());
				XLSUtil.setCellNumber(WS, 13,row,pvalue_M2.getValue());
				XLSUtil.setCellNumber(WS, 14,row,log_pvalue_M2.getValue());				
				XLSUtil.setCellNumber(WS, 15,row,overlap_param.getValue());				
	    		XLSUtil.setCellNumber(WS, 16, row, overlap_coeff_1.getValue());    		
	    		XLSUtil.setCellNumber(WS, 17, row, overlap_coeff_2.getValue());
	    		XLSUtil.setCellNumber(WS, 18, row, overlap_coeff_1_sim.getValue());    		
	    		XLSUtil.setCellNumber(WS, 19, row, overlap_coeff_2_sim.getValue());    			    		
	    		XLSUtil.setCellNumber(WS, 20, row, pvalue_overlap1.getValue());
	    		XLSUtil.setCellNumber(WS, 21, row, log_pvalue_overlap1.getValue());
	    		XLSUtil.setCellNumber(WS, 22, row, pvalue_overlap2.getValue());
	    		XLSUtil.setCellNumber(WS, 23, row, log_pvalue_overlap2.getValue());	  }  		
	    		row++;}	
    		   }
    	   }    		       		   						
    	   break;		
    	   case OBJECT:
    		   if (exportExcel.getValue()) {
		 		XLSUtil.setCellString(WS, 1,row,"Nb detections 1"); 
		 		XLSUtil.setCellString(WS, 2,row,"Nb detections 2"); 
		 		XLSUtil.setCellString(WS, 3,row,"% of 1 (center of mass) inside masks 2");		 		
		 		XLSUtil.setCellString(WS, 4,row,"p-value (1 inside masks 2, Analytical)");
		 		XLSUtil.setCellString(WS, 5,row,"log p-value (1 inside masks 2)");
		 		XLSUtil.setCellString(WS, 6,row,"Ripley step");
		 		XLSUtil.setCellString(WS, 7,row,"Ripley r_max");
		 		XLSUtil.setCellString(WS, 8,row,"Max. of the K function");
		 		XLSUtil.setCellString(WS, 9,row,"p-value (SODA)");		 		
		 		XLSUtil.setCellString(WS, 10,row,"log_10(p-value)");
		 		XLSUtil.setCellString(WS, 11,row,"% (fit of K function) of 2 coloc. with 1"); 				 		
		 		XLSUtil.setCellString(WS, 12,row,"Distance of Coloc. (fit)");		 		
		 		XLSUtil.setCellString(WS, 13,row,"% (SODA) of 2 coloc. with 1"); 				 		
		 		XLSUtil.setCellString(WS, 14,row,"Distance of Coloc. (SODA)");		 		;		 		 		
				row++;}		

    		   if ((detect_!=null)&(detect2_!=null)){
		 		//construction de la liste des distances
		 		betaCorrection(max_radius.getValue()/10,100);
		 		double maxdist = max_radius.getValue();		 	
		 		double step_min = step.getValue();
		 		distance_fit.clear();			
		 		distance_fit.add(0.);
		 		double temp = 0.;		
		 		while (temp + step_min <= maxdist) {
		 			temp += step_min;
		 			distance_fit.add(temp);}
		 		int N_fit = distance_fit.size();
		 		if (N_fit == 1) {
		 			distance_fit.add(maxdist);
		 			N_fit = distance_fit.size();}
		 		//on clear les roi coloc. exportées précédemment
		 		if (export_colocalized_rois.getValue()){
		 			if (coloc_roi_1==null){} else{
		 				for (ROI roi : coloc_roi_1)		 			
		 				{sequence.removeROI(roi);}}
		 			if (coloc_roi_2==null){} else{
		 				for (ROI roi : coloc_roi_2)
		 				{sequence2.removeROI(roi);}}}		 			
		 			
		 			//déclaration initiale des tableaux pour stocker valeurs et ROIs au cours du temps
		 			double[][] proba_dist = new double[numT][N_fit - 1];
		 			int ind_row = 0;	
		 			//coloc. ROIs
		 			ArrayList<ROI> c_1 = new ArrayList<ROI>();
		 			ArrayList<ROI> c_2 = new ArrayList<ROI>();
		 			//distance and coupling probability per couple of spots
		 			ArrayList<Double> probas = new ArrayList<Double>();
		 			ArrayList<Double> dist = new ArrayList<Double>();
		 			
		 			//single ROIs
		 			ArrayList<ROI> s_1 = new ArrayList<ROI>();
		 			ArrayList<ROI> s_2 = new ArrayList<ROI>();		
		 			// d�marrage boucle en temps
		 			for (int t = 0; t < numT; t += 1) {						
		 				ArrayList<ROI> roi_t = SODAblock.ROI_t(dim, list_roi, t, -1);
		 				if (roi_t.size()==0){}
		 				else{		 									
		 					// on récupère les spots au temps t
		 					
		 					Vector<Spot> spots1=detect_.getDetectionsAtT(t);
		 					Vector<Spot> spots2=detect2_.getDetectionsAtT(t);
		 					//on transforme chaque liste de spots en un tableau de ROIs
		 					ArrayList<ROI> spots1_liste = new ArrayList<ROI>();
		 					ArrayList<ROI> spots2_liste = new ArrayList<ROI>();						
		 					for (Spot s1:spots1){
		 						Point3D[] pt_array = new Point3D[s1.point3DList.size()];
		 						int ind=0;
		 						for (plugins.nchenouard.spot.Point3D pt:s1.point3DList){
		 							Point3D pt1= new Point3D.Double(pt.x, pt.y, pt.z);
		 							pt_array[ind]=pt1;ind++;
		 						}
		 						BooleanMask3D bm3d = new BooleanMask3D(pt_array);
		 						ROI3DArea r3d = new ROI3DArea(bm3d);r3d.setT(t);
								spots1_liste.add(r3d);					
		 					}
						for (Spot s2:spots2){									 
								Point3D[] pt_array = new Point3D[s2.point3DList.size()];
								int ind=0;
								for (plugins.nchenouard.spot.Point3D pt:s2.point3DList){
									Point3D pt1= new Point3D.Double(pt.x, pt.y, pt.z);
									pt_array[ind]=pt1;ind++;
								}
									BooleanMask3D bm3d = new BooleanMask3D(pt_array);
									ROI3DArea r3d = new ROI3DArea(bm3d);r3d.setT(t);
									spots2_liste.add(r3d);		
							}
			
						//on délectionne les ROIs spots qui sont bien dans ROI_t
						ROI[] detection = SODAblock.detectionsInRoi(spots1_liste.toArray(new ROI[spots1_liste.size()]), roi_t);
						ROI[] detection2 = SODAblock.detectionsInRoi(spots2_liste.toArray(new ROI[spots2_liste.size()]), roi_t);
						// calcul des parametres globaux: aire totale des rois et nb de detections
						double volume = ROIUtil.getUnion(roi_t).getNumberOfPoints() * ratio_zx;
						if (ROIUtil.getUnion(roi_t).getBounds5D().isInfiniteZ()) {
							volume = volume * sequence.getSizeZ() * ratio_zx;
						}				
						int nbdeta = detection.length;
						int nbdetb = detection2.length;
					
						//Analyse Distance-based (center of mass in spots)
						double[] distance_based = new double[2];						
						distance_based=Methods_distance.distance(detection, detection2, sequence, sequence2, roi_t, t, volume);
						alpha_inside.setValue(distance_based[0]);
						alpha_inside_label.setValue(StringUtil.toString(distance_based[0],2));
						p_value_inside.setValue(distance_based[2]);
						p_value_inside_label.setValue(StringUtil.toString(distance_based[2],2));
						log_p_value_inside.setValue(distance_based[1]);
						log_p_value_inside_label.setValue(StringUtil.toString(distance_based[1],2));						
						
						/////////////////////////////////////////////////////////////////
						//Analyse Ripley (Fit et SODA)
						////////////////////////////////////////////////////////////
						//on divise la ROI d'étude pour accélerer le calcul de la fonction de Ripley		 				
	 					double window_size = maxdist;
	 					double max_z = maxdist/ratio_zx;	 					
						// on crée des listes de points 2D ou 3D avec les positions (centres
	 					// d'intensité ou de masse en 3D) des spots			
	 					ArrayList<Point3D> positions_1_2D = new ArrayList<Point3D>();
	 					ArrayList<Point3D> positions_2_2D = new ArrayList<Point3D>();
	 					//on crée aussi une liste potentielle de points 3d
	 					ArrayList<Point3D> positions_1_3D = new ArrayList<Point3D>();
	 					ArrayList<Point3D> positions_2_3D = new ArrayList<Point3D>();
	 					//sous-listes des detections pour accelerer le temps de calcul
	 					Window2D[][] imageWindows_1_2D = new Window2D[(int) (sequence.getWidth()/ window_size)][(int) (sequence.getHeight() / window_size)];
	 					Window2D[][] imageWindows_2_2D = new Window2D[(int) (sequence.getWidth()/ window_size)][(int) (sequence.getHeight() / window_size)];
	 					Window3D[][][] imageWindows_1_3D = new Window3D[(int) (sequence.getWidth() / window_size)][(int) (sequence.getHeight()/ window_size)][(int) (sequence.getSizeZ() / max_z)];
	 					Window3D[][][] imageWindows_2_3D = new Window3D[(int) (sequence.getWidth() / window_size)][(int) (sequence.getHeight()/ window_size)][(int) (sequence.getSizeZ() / max_z)];
	 					if (dim==2){				
	 						for (ROI r : detection) {				
	 							Point3D pos = Ripley2D.getIntensityCenter( r, sequence_1.getValue());
	 							positions_1_2D.add(pos);}
	 						for (ROI r : detection2) {				
	 							Point3D pos = Ripley2D.getIntensityCenter(r, sequence_2.getValue());
	 							positions_2_2D.add(pos);}																		
	 						imageWindows_1_2D = Window2D.window_tab(positions_1_2D, sequence_1.getValue(), window_size);			
	 						imageWindows_2_2D = Window2D.window_tab(positions_2_2D, sequence_2.getValue(), window_size);
	 					}
	 					else // if dim==3
	 					{					
	 						for (ROI r : detection) {
	 							if (r.getDimension()==3){
	 								Point3D pos = Ripley3D.getIntensityCenter((ROI3D) r,sequence_1.getValue());
	 								positions_1_3D.add(pos);}
	 							else{Point3D pos = Ripley2D.getIntensityCenter((ROI2D) r,sequence_1.getValue());
	 							positions_1_3D.add(pos);}}
	 						for (ROI r : detection2) {
	 							if (r.getDimension()==3){
	 								Point3D pos = Ripley3D.getIntensityCenter((ROI3D) r,sequence_2.getValue());
	 								positions_2_3D.add(pos);}
	 							else{Point3D pos = Ripley2D.getIntensityCenter((ROI2D) r,sequence_2.getValue());
	 							positions_2_3D.add(pos);}}				
	 						imageWindows_1_3D = Window3D.window_tab(positions_1_3D, sequence, maxdist,max_z);				
	 						imageWindows_2_3D = Window3D.window_tab(positions_2_3D, sequence, maxdist,max_z);
	 					}
	 					
	 					//déclaration des tableaux de p-value
	 					double[] maximum = new double[N_fit-1];
	 					double[] pvalue = new double[N_fit-1];
	 					double[] log_pvalue = new double[N_fit-1];
	 					double[] delta_K = new double[N_fit - 1];
	 					double[][] Ktemp = new double[N_fit - 1][3];	 					
	 					double[] col_ev = new double[N_fit - 1];

	 					//calcul des fonctions de Ripley
	 					if (sequence.getSizeZ() > 1) {					
	 						Ktemp = Ripley3D.correlation_new(roi_t, imageWindows_1_3D,imageWindows_2_3D, volume, N_fit, distance_fit, sequence_1.getValue(),nbdeta, nbdetb, ratio_zx);} 
	 					else {
	 						Ktemp = Ripley2D.correlation_new(roi_t, imageWindows_1_2D, imageWindows_2_2D, volume, N_fit, distance_fit, nbdeta, nbdetb);}

	 					for (int k = 0; k < N_fit - 1; k++) {
	 						delta_K[k] = Ktemp[k][0];
	 					}
				
	 					if (dim==2)
	 					{
	 						non_parametric_object.main2D_corr(N_fit, sequence, roi_t, positions_1_2D, positions_2_2D, imageWindows_1_2D,imageWindows_2_2D, distance_fit, N_h, volume, results, delta_K, Ktemp, proba_dist[t],maximum,pvalue);					
	 					}
	 					else
	 					{
	 						non_parametric_object.main3D_corr(N_fit,sequence,roi_t,positions_1_3D ,positions_2_3D, imageWindows_1_3D,imageWindows_2_3D,distance_fit,N_h,ratio_zx,volume,results, delta_K, Ktemp,proba_dist[t],maximum,pvalue);
	 					}
	 					double total_coloc_temp =0;	
	 					for (int j = 0; j < N_fit - 1; j++) {
	 						col_ev[j] = proba_dist[t][j] * (nbdetb * nbdeta / volume) * delta_K[j];
	 						total_coloc_temp += col_ev[j];
	 						if (maximum[j]<4.){
	 							log_pvalue[j] = Math.log10(pvalue[j]);}
	 						else {
	 							double x = maximum[j] / Math.sqrt(2.);
	 							double y = (N_fit - 1) / (2 * Math.sqrt(Math.PI) * x);
	 							double exponent = (Math.log(y) - Math.pow(x, 2)) / Math.log(10);
	 							log_pvalue[j] = exponent;
	 						}
	 					}
				alpha_soda.setValue((double)(total_coloc_temp/nbdetb));
				alpha_soda_label.setValue(StringUtil.toString(alpha_soda.getValue(),2));
				sup_K.setValue(maximum[N_fit-2]);
				sup_K_label.setValue(StringUtil.toString(sup_K.getValue(),2));
				p_value_K.setValue(pvalue[N_fit-2]);
				p_value_K_label.setValue(StringUtil.toString(p_value_K.getValue(),2));
				log_p_value_K.setValue(log_pvalue[N_fit-2]);
				log_p_value_K_label.setValue(StringUtil.toString(log_p_value_K.getValue(),2));
				
				ArrayList<apparatedSpots> liste_app_detect = apparatedSpots.appDetectConstruction(detection, detection2,proba_dist[t], distance_fit, sequence_1.getValue(), sequence_2.getValue());
				for (apparatedSpots as : liste_app_detect) {
				c_1.add(as.s1);
				c_2.add(as.s2);
				dist.add(as.distance);
				probas.add(as.proba);				
				}
				// calcul de la distance moyenne
				double dist_moy = apparatedSpots.distance_moyenne(liste_app_detect, distance_fit.get(N_fit-1));
				mu_soda.setValue(dist_moy);
				mu_soda_label.setValue(StringUtil.toString(dist_moy,2));
				
				apparatedSpots.roiSingle(t, liste_app_detect, detection, detection2);
				for (ROI s:apparatedSpots.single1) {
					s_1.add(s);
				}
				for (ROI s:apparatedSpots.single2) {
					s_2.add(s);
				}				
				//calcul des variances de la fonction delta_K
				double[] delta_var=new double[N_fit-1];
				if (sequence.getSizeZ()>1){
					delta_var = Ripley3D.variance_theo_delta_new(roi_t, imageWindows_1_3D, imageWindows_2_3D, volume, nbdeta, nbdetb, N_fit, distance_fit, sequence, ratio_zx);}
					else					
					{delta_var = Ripley2D.variance_theo_delta_new(roi_t, imageWindows_1_2D, imageWindows_2_2D, volume, nbdeta, nbdetb, N_fit, distance_fit, N_h,results);
					}
				
	
				//calcul des fonctions de Ripley (cumulative) et variance pour fitting
				
				K.clear();
				K.add(0,0.0);
				for (int h = 1; h < N_fit; h++) {		
					K.add(K.get(h-1)+delta_K[h-1]);					
				}
				double[] var=new double[N_fit];
				var[0]=0.0;
				for (int i=1;i<N_fit;i++){
					var[i]=var[i-1]+delta_var[i-1];
				}
				//calcul de la fonction de Ripley normalisée
				for (int p = 1; p < N_fit; p++) {
					double expected_mean=0;
					if (dim==2){expected_mean=Math.PI*Math.pow(distance_fit.get(p), 2);}
					else{expected_mean=4/3*Math.PI*Math.pow(distance_fit.get(p), 3);}
					K.set(p, (K.get(p)-expected_mean)/var[p]);}
	
	// fit sur K (cumulative fonction)	
				double[] start_est = new double[3];
				start_est[0] = 0.1D; // initial estimate of alpha
				start_est[1] = 1.01D; // initial estimate of mu
				start_est[2] = 0.3D;//sigma_ini.getValue(); // initial estimate of sigma
				double[] coeffs = new double[3];
				fit_data.main_manual(distance_fit, K, volume, nbdeta,dim,var);	
				coeffs = fit_data.coeffs;		
				alpha_fit.setValue(coeffs[0]);
				alpha_fit_label.setValue(StringUtil.toString(coeffs[0],2));	
				mu_fit.setValue(coeffs[1]);
				mu_fit_label.setValue(StringUtil.toString(coeffs[1],2));								 		
				sigma_fit.setValue(coeffs[2]);
				sigma_fit_label.setValue(StringUtil.toString(coeffs[2],2));								 		
	if (exportExcel.getValue()) {
		XLSUtil.setCellNumber(WS, 0, row, t);
		XLSUtil.setCellNumber(WS, 1, row, nbdeta);
		XLSUtil.setCellNumber(WS, 2, row, nbdetb);
		XLSUtil.setCellNumber(WS, 3, row, alpha_inside.getValue());
		XLSUtil.setCellNumber(WS, 4, row, p_value_inside.getValue());
		XLSUtil.setCellNumber(WS, 5, row, log_p_value_inside.getValue());
		XLSUtil.setCellNumber(WS, 6, row, step.getValue());
		XLSUtil.setCellNumber(WS, 7, row, max_radius.getValue());
		XLSUtil.setCellNumber(WS, 8, row, maximum[N_fit-2]);
		XLSUtil.setCellNumber(WS, 9, row, pvalue[N_fit-2]);
		XLSUtil.setCellNumber(WS, 10, row, log_pvalue[N_fit-2]);
		XLSUtil.setCellNumber(WS, 11, row, alpha_fit.getValue());		
		XLSUtil.setCellNumber(WS, 12, row, mu_fit.getValue());		
		XLSUtil.setCellNumber(WS, 13, row, alpha_soda.getValue());
		XLSUtil.setCellNumber(WS, 14, row, mu_soda.getValue());
		row++;
		}
			
		if (graph.getValue())
			{				
			K_fit.clear();	
			K_fit.add(0,0.0);
			for (int p = 1; p < N_fit; p++) {
				double tem=alpha_fit.getValue() * volume * 0.5 / nbdeta * (Stat
						.erf((distance_fit.get(p) - mu_fit.getValue())
								/ (sigma_fit.getValue() * Math.sqrt(2))) - Stat
						.erf((-distance_fit.get(p) - mu_fit.getValue())
								/ (sigma_fit.getValue() * Math.sqrt(2))));		
				K_fit.add(p,tem/var[p]);				
			}
			plotGraph(distance_fit, K, K_fit);				
			}			 				
		if (export_colocalized_rois.getValue()){
			for (ROI c:c_1){
				sequence.addROI(c);
			}
			for (ROI c:c_2){
				sequence2.addROI(c);
			}
		}}
		 				
		 			}
		 		}
}
	if (exportExcel.getValue()) {
		try {
			XLSUtil.saveAndClose(WW);
		} catch (WriteException e) {
			e.printStackTrace();
		} catch (IOException e) {		
			e.printStackTrace();}} 				 					 		
	}
	
	@Override
	public void clean() {
		// TODO Auto-generated method stub

	}

	@Override
	protected void execute() {
		pearson_coeff_label.setValue("  N/A  ");M1_label.setValue("  N/A  ");M2_label.setValue("  N/A  ");
		M1_sim_label.setValue("  N/A  ");M2_sim_label.setValue("  N/A  ");
		pvalue_pearson_label.setValue("  N/A  ");pvalue_M1_label.setValue("  N/A  ");pvalue_M2_label.setValue("  N/A  ");
		log_pvalue_pearson_label.setValue("  N/A  ");log_pvalue_M1_label.setValue("  N/A  ");log_pvalue_M2_label.setValue("  N/A  ");
		
		ICCS1_label.setValue("  N/A  ");ICCS2_label.setValue("  N/A  ");
		overlap_coeff_1_label.setValue("  N/A  ");overlap_coeff_2_label.setValue("  N/A  ");
		overlap_coeff_1_sim_label.setValue("  N/A  ");overlap_coeff_2_sim_label.setValue("  N/A  ");
		pvalue_overlap1_label.setValue("  N/A  ");log_pvalue_overlap1_label.setValue("  N/A  ");
		pvalue_overlap2_label.setValue("  N/A  ");log_pvalue_overlap2_label.setValue("  N/A  ");
		
		alpha_fit_label.setValue("  N/A  ");mu_fit_label.setValue("  N/A  ");sigma_fit_label.setValue("  N/A  ");
		alpha_soda_label.setValue("  N/A  ");mu_soda_label.setValue("  N/A  ");
		alpha_inside_label.setValue("  N/A  ");
		p_value_inside_label.setValue("  N/A  ");log_p_value_inside_label.setValue("  N/A  ");
		sup_K_label.setValue("  N/A  ");
		p_value_K_label.setValue("  N/A  ");log_p_value_K_label.setValue("  N/A  ");
		
            	if (sequence1.getValue() == null || sequence2.getValue() == null) {
        			new AnnounceFrame("Please first select sequences");
        			return;} 
            	if (sequence1.getValue().getSizeX()!= sequence2.getValue().getSizeX() ||sequence1.getValue().getSizeY()!= sequence2.getValue().getSizeY() || sequence1.getValue().getSizeZ()!= sequence2.getValue().getSizeZ()||sequence1.getValue().getSizeT()!= sequence2.getValue().getSizeT()) {
        			new AnnounceFrame("Sequences must have the same (X,Y,Z,T) dimensions");
        			return;} 
            	if (channel1.getValue()> sequence1.getValue().getSizeC()-1 ||channel2.getValue()> sequence2.getValue().getSizeC()-1) {
        			new AnnounceFrame("Channels do not exist");
        			return;}             	        			
            	if (detections1.getValue() == null || detections2.getValue() == null) {
					new AnnounceFrame("Only Pearson & Cross-Correlation can be computed without detections");}
            	performAnalysis(sequence1, sequence2,channel1,channel2, detections1, detections2, exportExcel);
	}
        		
				
	@Override
	protected void initialize() {		
		EzLabel publi_correlation = new EzLabel("Correlation methods are reviewed in \n Lagache, T. et al. Statistical analysis of molecule colocalization in bioimaging.\n Cytometry Part A, 87(6), 568-579. (2015)");				
		method.addVisibilityTriggerTo(publi_correlation, ColocMethod.CORRELATION);
		super.addEzComponent(publi_correlation);
		EzLabel publi_object = new EzLabel("For more information: \n Parametric: Lagache, T. et al. Cytometry Part A, 87(6), 568-579. (2015)\n SODA: Lagache, T. et al. Nature Communications, 9(1), 698. (2018)");				
		method.addVisibilityTriggerTo(publi_object, ColocMethod.OBJECT);
		super.addEzComponent(publi_object);
		/////////////////////////////////////////////////////////////
		addComponent(new JSeparator(JSeparator.HORIZONTAL));        		
		////////////////////////////////////////////////////////////////
		super.addEzComponent(method);
		super.addEzComponent(setTrackSetA);
		super.addEzComponent(reset);
				
		
		EzGroup sequences = new EzGroup("Sequences used for analysis", sequence1, channel1, sequence2, channel2);						
        super.addEzComponent(sequences);
       
        EzGroup detections = new EzGroup("Spot detections (Overlap, Manders & Ripley analysis)",detections1,detections2);		
		addEzComponent(detections);		
		
		overlap_param = new EzVarDouble("Threshold (T) for overlap analysis",0.5,0,1,0.01);
		method.addVisibilityTriggerTo(overlap_param, ColocMethod.CORRELATION);
		addEzComponent(overlap_param);
		
		MC = new EzVarInteger("Nb of MC simulations (p-value computation)",10,0,10000,1);
		method.addVisibilityTriggerTo(MC, ColocMethod.CORRELATION);
		addEzComponent(MC);		
		
		
		max_radius = new EzVarDouble("Maximal distance for the analysis (in pxs)", 5, 0, 100, 1);
		step = new EzVarDouble("Step (in pxs)", 1, 0, 100, 0.1);
		graph = new EzVarBoolean("Plot K function graph to check the fit", false);		
		EzGroup K_param = new EzGroup("Parameters for Ripley analysis",max_radius,step,graph);		
		method.addVisibilityTriggerTo(K_param, ColocMethod.OBJECT);
		addEzComponent(K_param);		
		
        
		addEzComponent(new EzGroup("Export",export_colocalized_rois,exportExcel, exportExcelFile));
		method.addVisibilityTriggerTo(export_colocalized_rois, ColocMethod.OBJECT);
		exportExcel.addVisibilityTriggerTo(exportExcelFile, true);
		
		/////////////////////////////////////////////////////////////
		addComponent(new JSeparator(JSeparator.VERTICAL));        		
		////////////////////////////////////////////////////////////////
		
		
		EzGroup pears = new EzGroup("Pearson Analysis: Results",pearson_coeff_label,pvalue_pearson_label,log_pvalue_pearson_label);
		method.addVisibilityTriggerTo(pears, ColocMethod.CORRELATION);
		super.addEzComponent(pears);

		EzGroup iccs = new EzGroup("Cross-Correlation Analysis: Results",ICCS1_label,ICCS2_label);
		method.addVisibilityTriggerTo(iccs, ColocMethod.CORRELATION);
		super.addEzComponent(iccs);

		EzGroup manders = new EzGroup("Manders Analysis: Results",M1_label,M2_label,M1_sim_label,M2_sim_label,pvalue_M1_label,log_pvalue_M1_label,pvalue_M2_label,log_pvalue_M2_label);
		method.addVisibilityTriggerTo(manders, ColocMethod.CORRELATION);
		super.addEzComponent(manders);
		
		EzGroup overlap = new EzGroup("Overlap (>T) Analysis: Results",overlap_coeff_1_label,overlap_coeff_2_label,overlap_coeff_1_sim_label,overlap_coeff_2_sim_label,pvalue_overlap1_label,log_pvalue_overlap1_label,pvalue_overlap2_label,log_pvalue_overlap2_label);
		method.addVisibilityTriggerTo(overlap, ColocMethod.CORRELATION);
		super.addEzComponent(overlap);
		
	
		EzGroup results_inside = new EzGroup("Distance analysis (center of mass 1 inside masks 2)",alpha_inside_label,p_value_inside_label,log_p_value_inside_label);
		EzGroup K_results_fit = new EzGroup("Ripley's analysis (parametric)",alpha_fit_label,mu_fit_label);		
		EzGroup K_results_soda = new EzGroup("Ripley's analysis (soda)",alpha_soda_label,mu_soda_label,p_value_K_label,log_p_value_K_label);
		
		
		method.addVisibilityTriggerTo(results_inside, ColocMethod.OBJECT);
		method.addVisibilityTriggerTo(K_results_fit, ColocMethod.OBJECT);
		method.addVisibilityTriggerTo(K_results_soda, ColocMethod.OBJECT);
		
		
		addEzComponent(results_inside);
		addEzComponent(K_results_fit);
		addEzComponent(K_results_soda);
		
		////////////////////////////////////////////////////////////
		addComponent(new JSeparator(JSeparator.VERTICAL));        		
////////////////////////////////////////////////////////////////
		
	}

	private void plotGraph(ArrayList<Double> dist_tab,
			ArrayList<Double> measurementList, ArrayList<Double> fittedList) {

		final JFreeChart chart;
		XYSeriesCollection xyDataset = new XYSeriesCollection();

		chart = ChartFactory.createXYLineChart("Ripley's K function step",
				"pixels", "K", xyDataset, PlotOrientation.VERTICAL, true,
				false, false);

		XYSeries seriesXY = new XYSeries("Y");
		xyDataset.addSeries(seriesXY);
		XYSeries seriesXYfit = new XYSeries("Y fit");
		xyDataset.addSeries(seriesXYfit);

		for (int t = 0; t < measurementList.size(); t++) {
			seriesXY.add((double) dist_tab.get(t), measurementList.get(t));
			seriesXYfit.add((double) dist_tab.get(t), fittedList.get(t));
		}

		if (this.chartpanel == null)
        {
            this.chartpanel = new ChartPanel(chart);
            addComponent(this.chartpanel);
            getUI().repack(true);
        }
        else
        {
            this.chartpanel.setChart(chart);
        }
		
	
		

	}

	@Override
	public void sequenceChanged(SequenceEvent sequenceEvent) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void sequenceClosed(Sequence sequence) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void actionPerformed(ActionEvent e) {
	if ( e.getActionCommand() == setTrackSetA.name ){		
			liste_roi.clear();
	        for (ROI roi : Icy.getMainInterface().getROIs())
	            {
	            	if ( roi.isSelected())
	            	{
	            		liste_roi.add( roi );	
	            	}
	            }
	        setTrackSetA.setText("You have selected " + liste_roi.size() + " ROIs");
	      
	}
	
	
	if ( e.getActionCommand()==reset.name){
	        	liste_roi.clear();
	        	setTrackSetA.setText(setTrackSetA.name);
	        	setTrackSetA.setEnabled(true);	        	
	        }
	}
	        	     
		
	
	public static ROI[] detectionsInRoi(VarROIArray detections, ArrayList<ROI> roi) {
		// SEQUENCE A remplacer par w,h

		// create a hashMap with the detections binded to ROI

		if (roi.size()==0){return new ROI[0];}else{
		ROI[] detec = detections.getValue();
		ArrayList<ROI> ROIDetection = new ArrayList<ROI>();
		ArrayList<ROI> TestList = new ArrayList<ROI>();

		ROI union = ROIUtil.getUnion(roi);
		Point5D pos = union.getPosition5D();
		// fill hashMap
		for (ROI r : detec) {
			boolean b = false;
			for (ROI rt : TestList) {
				if (r == rt) {
					b = true;
				}
			}
			if (b == false) // si le spot n'a pas encore �t� pris en compte
			{
				TestList.add(r);
				if (union.contains(r.getPosition5D().getX(), r.getPosition5D().getY(),pos.getZ() , r.getPosition5D().getT(), pos.getC())) {
					ROIDetection.add(r);
				}
			}
		}
		ROI[] ROIDetection_ = new ROI[ROIDetection.size()];
		int ind=0;
		for (ROI r:ROIDetection){
			ROIDetection_[ind] = r;
			ind++;
		}
		return (ROIDetection_);}
	}
	}
	