package plugins.ylemontag.ssim;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.util.VarException;

/**
 * 
 * @author Yoann Le Montagner
 * 
 * Block to generate a SSIMCalculator object with a set of predefined parameters
 */
public class SSIMCalculatorBlock extends Plugin implements Block, PluginBundled
{
	// BlockInfo (name): "SSIM calculator"
	// BlockInfo (desc): "Generate a SSIM calculator object corresponding to a given set of SSIM parameters"
	
	private SSIMParameterComponent _parameters = new SSIMParameterComponent();
	private Var<SSIMCalculator>    _calculator = new Var<SSIMCalculator>("SSIM calculator",
		SSIMCalculator.class, null);
	
	@Override
	public void declareInput(VarList inputMap)
	{
		for(Var<?> v : _parameters.getVars()) {
			inputMap.add(v);
		}
	}

	@Override
	public void declareOutput(VarList outputMap)
	{
		outputMap.add(_calculator);
	}
	
	@Override
	public String getMainPluginClassName()
	{
		return SSIMPlugin.class.getName();
	}
	
	@Override
	public void run()
	{
		try {
			SSIMCalculator calculator = _parameters.createCalculator();
			_calculator.setValue(calculator);
		}
		catch(IllegalSSIMParameterException err) {
			throw new VarException("Invalid SSIM parameter: " + err.getMessage());
		}
	}
}
