/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.core.listener;

import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.json.SystemInfo;

public class SystemInfoPrintListener
implements TrainingListener {
    private static final Logger log = LoggerFactory.getLogger(SystemInfoPrintListener.class);
    private boolean printOnEpochStart;
    private boolean printOnEpochEnd;
    private boolean printOnForwardPass;
    private boolean printOnBackwardPass;
    private boolean printOnGradientCalculation;
    private static final String SYSTEM_INFO = "System info on epoch end: ";

    public void iterationDone(Model model, int iteration, int epoch) {
    }

    public void onEpochStart(Model model) {
        if (!this.printOnEpochStart) {
            return;
        }
        SystemInfo systemInfo = new SystemInfo();
        log.info("System info on epoch begin: ");
        log.info(systemInfo.toPrettyJSON());
    }

    public void onEpochEnd(Model model) {
        if (!this.printOnEpochEnd) {
            return;
        }
        SystemInfo systemInfo = new SystemInfo();
        log.info(SYSTEM_INFO);
        log.info(systemInfo.toPrettyJSON());
    }

    public void onForwardPass(Model model, List<INDArray> activations) {
        if (!this.printOnBackwardPass) {
            return;
        }
        SystemInfo systemInfo = new SystemInfo();
        log.info(SYSTEM_INFO);
        log.info(systemInfo.toPrettyJSON());
    }

    public void onForwardPass(Model model, Map<String, INDArray> activations) {
        if (!this.printOnForwardPass) {
            return;
        }
        SystemInfo systemInfo = new SystemInfo();
        log.info(SYSTEM_INFO);
        log.info(systemInfo.toPrettyJSON());
    }

    public void onGradientCalculation(Model model) {
        if (!this.printOnGradientCalculation) {
            return;
        }
        SystemInfo systemInfo = new SystemInfo();
        log.info(SYSTEM_INFO);
        log.info(systemInfo.toPrettyJSON());
    }

    public void onBackwardPass(Model model) {
        if (!this.printOnBackwardPass) {
            return;
        }
        SystemInfo systemInfo = new SystemInfo();
        log.info(SYSTEM_INFO);
        log.info(systemInfo.toPrettyJSON());
    }

    SystemInfoPrintListener(boolean printOnEpochStart, boolean printOnEpochEnd, boolean printOnForwardPass, boolean printOnBackwardPass, boolean printOnGradientCalculation) {
        this.printOnEpochStart = printOnEpochStart;
        this.printOnEpochEnd = printOnEpochEnd;
        this.printOnForwardPass = printOnForwardPass;
        this.printOnBackwardPass = printOnBackwardPass;
        this.printOnGradientCalculation = printOnGradientCalculation;
    }

    public static SystemInfoPrintListenerBuilder builder() {
        return new SystemInfoPrintListenerBuilder();
    }

    public static class SystemInfoPrintListenerBuilder {
        private boolean printOnEpochStart;
        private boolean printOnEpochEnd;
        private boolean printOnForwardPass;
        private boolean printOnBackwardPass;
        private boolean printOnGradientCalculation;

        SystemInfoPrintListenerBuilder() {
        }

        public SystemInfoPrintListenerBuilder printOnEpochStart(boolean printOnEpochStart) {
            this.printOnEpochStart = printOnEpochStart;
            return this;
        }

        public SystemInfoPrintListenerBuilder printOnEpochEnd(boolean printOnEpochEnd) {
            this.printOnEpochEnd = printOnEpochEnd;
            return this;
        }

        public SystemInfoPrintListenerBuilder printOnForwardPass(boolean printOnForwardPass) {
            this.printOnForwardPass = printOnForwardPass;
            return this;
        }

        public SystemInfoPrintListenerBuilder printOnBackwardPass(boolean printOnBackwardPass) {
            this.printOnBackwardPass = printOnBackwardPass;
            return this;
        }

        public SystemInfoPrintListenerBuilder printOnGradientCalculation(boolean printOnGradientCalculation) {
            this.printOnGradientCalculation = printOnGradientCalculation;
            return this;
        }

        public SystemInfoPrintListener build() {
            return new SystemInfoPrintListener(this.printOnEpochStart, this.printOnEpochEnd, this.printOnForwardPass, this.printOnBackwardPass, this.printOnGradientCalculation);
        }

        public String toString() {
            return "SystemInfoPrintListener.SystemInfoPrintListenerBuilder(printOnEpochStart=" + this.printOnEpochStart + ", printOnEpochEnd=" + this.printOnEpochEnd + ", printOnForwardPass=" + this.printOnForwardPass + ", printOnBackwardPass=" + this.printOnBackwardPass + ", printOnGradientCalculation=" + this.printOnGradientCalculation + ")";
        }
    }
}

