/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.core.listener;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.deeplearning4j.core.listener.HardwareMetric;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.dataformat.yaml.YAMLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.json.SystemInfo;

public class SystemPolling {
    private static final Logger log = LoggerFactory.getLogger(SystemPolling.class);
    private ScheduledExecutorService scheduledExecutorService;
    private long pollEveryMillis;
    private File outputDirectory;
    private NameProvider nameProvider;
    private ObjectMapper objectMapper = new ObjectMapper(new YAMLFactory());

    private SystemPolling(long pollEveryMillis, File outputDirectory, NameProvider nameProvider) {
        this.pollEveryMillis = pollEveryMillis;
        this.outputDirectory = outputDirectory;
        this.nameProvider = nameProvider;
    }

    public void run() {
        this.scheduledExecutorService = Executors.newScheduledThreadPool(1);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                SystemInfo systemInfo = new SystemInfo();
                HardwareMetric hardwareMetric = HardwareMetric.fromSystem(systemInfo, SystemPolling.this.nameProvider.nextName());
                File hardwareFile = new File(SystemPolling.this.outputDirectory, hardwareMetric.getName() + ".yml");
                try {
                    SystemPolling.this.objectMapper.writeValue(hardwareFile, (Object)hardwareMetric);
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
        }, 0L, this.pollEveryMillis, TimeUnit.MILLISECONDS);
    }

    public void stopPolling() {
        this.scheduledExecutorService.shutdownNow();
    }

    public static class Builder {
        private long pollEveryMillis;
        private File outputDirectory;
        private NameProvider nameProvider = new NameProvider(){

            @Override
            public String nextName() {
                return UUID.randomUUID().toString();
            }
        };

        public Builder nameProvider(NameProvider nameProvider) {
            this.nameProvider = nameProvider;
            return this;
        }

        public Builder pollEveryMillis(long pollEveryMillis) {
            this.pollEveryMillis = pollEveryMillis;
            return this;
        }

        public Builder outputDirectory(File outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        public SystemPolling build() {
            return new SystemPolling(this.pollEveryMillis, this.outputDirectory, this.nameProvider);
        }
    }

    public static interface NameProvider {
        public String nextName();
    }
}

