/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.array;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.nd4j.autodiff.samediff.ArrayHolder;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.function.Supplier;
import org.nd4j.linalg.api.ndarray.INDArray;

public class OptimizedGraphArrayHolder
implements ArrayHolder {
    private final ArrayHolder underlyingHolder;
    private final Map<String, Supplier<INDArray>> functions;

    public OptimizedGraphArrayHolder(ArrayHolder underlyingHolder) {
        this.underlyingHolder = underlyingHolder;
        this.functions = new HashMap<String, Supplier<INDArray>>();
    }

    public void setFunction(String name, Supplier<INDArray> fn) {
        if (this.underlyingHolder.hasArray(name)) {
            this.underlyingHolder.removeArray(name);
        }
        this.functions.put(name, fn);
    }

    @Override
    public boolean hasArray(String name) {
        return this.functions.containsKey(name) || this.underlyingHolder.hasArray(name);
    }

    @Override
    public INDArray getArray(String name) {
        if (this.functions.containsKey(name)) {
            return this.functions.get(name).get();
        }
        return this.underlyingHolder.getArray(name);
    }

    @Override
    public void setArray(String name, INDArray array) {
        Preconditions.checkState(!this.functions.containsKey(name), "Cannot set array when existing array is only accessible via a function");
        this.underlyingHolder.setArray(name, array);
    }

    @Override
    public INDArray removeArray(String name) {
        Supplier<INDArray> s = this.functions.remove(name);
        if (s != null) {
            return s.get();
        }
        return this.underlyingHolder.removeArray(name);
    }

    @Override
    public int size() {
        return this.underlyingHolder.size() + this.functions.size();
    }

    @Override
    public void initFrom(ArrayHolder arrayHolder) {
        this.underlyingHolder.initFrom(arrayHolder);
    }

    @Override
    public Collection<String> arrayNames() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.underlyingHolder.arrayNames());
        set.addAll(this.functions.keySet());
        return set;
    }

    @Override
    public void rename(String from, String to) {
        if (this.functions.containsKey(from)) {
            this.functions.put(to, this.functions.remove(from));
        } else {
            this.underlyingHolder.rename(from, to);
        }
    }
}

