/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.optimize;

import java.util.Properties;
import org.nd4j.autodiff.samediff.ArrayHolder;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.VariableType;
import org.nd4j.autodiff.samediff.array.OptimizedGraphArrayHolder;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.function.Supplier;
import org.nd4j.linalg.api.ndarray.INDArray;

public class OptimizationHelper {
    private final SameDiff originalGraph;
    private final Properties properties;
    private boolean setConstantHolder = false;
    private boolean setVariableHolder = false;

    public OptimizationHelper(SameDiff originalGraph, Properties properties) {
        this.originalGraph = originalGraph;
        this.properties = properties;
    }

    public OptimizationHelper arrayRecoveryFunction(String arrayName, Supplier<INDArray> fn) {
        SDVariable v = this.originalGraph.getVariable(arrayName);
        Preconditions.checkState(v.getVariableType() == VariableType.VARIABLE || v.getVariableType() == VariableType.CONSTANT, "Can only set an array recovery function for a variable or a constant");
        if (v.getVariableType() == VariableType.VARIABLE) {
            ArrayHolder h = this.originalGraph.getVariablesArrays();
            if (!this.setVariableHolder) {
                this.originalGraph.setVariablesArrays(new OptimizedGraphArrayHolder(h));
                h = this.originalGraph.getVariablesArrays();
                this.setVariableHolder = true;
            }
            ((OptimizedGraphArrayHolder)h).setFunction(arrayName, fn);
        } else {
            ArrayHolder h = this.originalGraph.getConstantArrays();
            if (!this.setConstantHolder) {
                this.originalGraph.setConstantArrays(new OptimizedGraphArrayHolder(h));
                h = this.originalGraph.getConstantArrays();
                this.setConstantHolder = true;
            }
            ((OptimizedGraphArrayHolder)h).setFunction(arrayName, fn);
        }
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

