/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.graph.ui;

import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.VariableType;
import org.nd4j.autodiff.samediff.internal.SameDiffOp;
import org.nd4j.autodiff.samediff.internal.Variable;
import org.nd4j.autodiff.samediff.serde.FlatBuffersMapper;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.primitives.Pair;
import org.nd4j.graph.UIAddName;
import org.nd4j.graph.UIEvent;
import org.nd4j.graph.UIGraphStructure;
import org.nd4j.graph.UIHistogram;
import org.nd4j.graph.UIOp;
import org.nd4j.graph.UIStaticInfoRecord;
import org.nd4j.graph.UIVariable;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.BaseCompatOp;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.Enter;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.Exit;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.NextIteration;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFileWriter {
    private static final Logger log = LoggerFactory.getLogger(LogFileWriter.class);
    private final File file;
    private long endStaticInfoOffset = -1L;
    private final AtomicInteger nameIndexCounter = new AtomicInteger(0);
    private final Map<Integer, String> nameIndexMap = new HashMap<Integer, String>();
    private final Map<String, Integer> indexNameMap = new HashMap<String, Integer>();

    public LogFileWriter(File file) throws IOException {
        this.file = file;
        if (file.exists()) {
            StaticInfo si = this.readStatic();
            List<Pair<UIStaticInfoRecord, Table>> staticList = si.getData();
            long staticInfoOffset = 0L;
            boolean seenEndStatic = false;
            for (int i = 0; i < staticList.size(); ++i) {
                UIStaticInfoRecord r = staticList.get(i).getFirst();
                if (r.infoType() == 2) {
                    seenEndStatic = true;
                }
                staticInfoOffset += (long)r.getByteBuffer().capacity();
            }
            this.endStaticInfoOffset = si.getFileOffset();
            List<Pair<UIEvent, Table>> events = this.readEvents();
            for (Pair<UIEvent, Table> p : events) {
                if (p.getFirst().eventType() != 0) continue;
                this.nameIndexCounter.getAndIncrement();
                UIAddName name = (UIAddName)p.getSecond();
                this.nameIndexMap.put(name.nameIdx(), name.name());
                this.indexNameMap.put(name.name(), name.nameIdx());
            }
        }
    }

    public long writeGraphStructure(SameDiff sd) throws IOException {
        Preconditions.checkState(this.endStaticInfoOffset < 0L, "Cannot write graph structure - already wrote end of static info marker");
        Pair<Integer, FlatBufferBuilder> h = this.encodeStaticHeader((byte)0);
        FlatBufferBuilder fbb2 = new FlatBufferBuilder(0);
        int graphStructureOffset = this.encodeGraphStructure(fbb2, sd);
        fbb2.finish(graphStructureOffset);
        return this.append(h.getSecond(), fbb2);
    }

    public long writeFinishStaticMarker() throws IOException {
        Preconditions.checkState(this.endStaticInfoOffset < 0L, "Wrote final static already information already");
        Pair<Integer, FlatBufferBuilder> encoded = this.encodeStaticHeader((byte)2);
        long out = this.append(encoded.getSecond(), null);
        this.endStaticInfoOffset = this.file.length();
        return out;
    }

    /*
     * Exception decompiling
     */
    public StaticInfo readStatic() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<Pair<UIEvent, Table>> readEvents() throws IOException {
        Preconditions.checkState(this.endStaticInfoOffset >= 0L, "Cannot read events - have not written end of static info marker");
        return this.readEvents(this.endStaticInfoOffset);
    }

    /*
     * Exception decompiling
     */
    public List<Pair<UIEvent, Table>> readEvents(long startOffset) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean registeredEventName(String name) {
        return this.indexNameMap.containsKey(name);
    }

    public long registerEventNameQuiet(String name) {
        Preconditions.checkState(!this.registeredEventName(name), "Event name \"%s\" has already been registered", (Object)name);
        try {
            return this.registerEventName(name);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing to log file", e);
        }
    }

    public long registerEventName(String name) throws IOException {
        Preconditions.checkState(this.endStaticInfoOffset >= 0L, "Cannot write name - have not written end of static info marker");
        FlatBufferBuilder fbb = new FlatBufferBuilder(0);
        long time = System.currentTimeMillis();
        int offset = UIEvent.createUIEvent(fbb, (byte)0, (byte)0, -1, time, 0, 0, (short)-1, 0, 0);
        fbb.finish(offset);
        FlatBufferBuilder fbb2 = new FlatBufferBuilder(0);
        int idx = this.nameIndexCounter.getAndIncrement();
        this.nameIndexMap.put(idx, name);
        this.indexNameMap.put(name, idx);
        int strOffset = fbb2.createString((CharSequence)name);
        int offset2 = UIAddName.createUIAddName(fbb2, idx, strOffset);
        fbb2.finish(offset2);
        long l = this.append(fbb, fbb2);
        return l;
    }

    public long writeScalarEvent(String name, EventSubtype subtype, long time, int iteration, int epoch, Number scalar) throws IOException {
        Preconditions.checkState(this.indexNameMap.containsKey(name), "Name \"%s\" not yet registered", (Object)name);
        int idx = this.indexNameMap.get(name);
        FlatBufferBuilder fbb = new FlatBufferBuilder(0);
        int offset = UIEvent.createUIEvent(fbb, (byte)1, subtype.asUIEventSubtype(), idx, time, iteration, epoch, (short)-1, 0, 0);
        fbb.finish(offset);
        FlatBufferBuilder fbb2 = new FlatBufferBuilder(0);
        int offset2 = Nd4j.scalar(scalar).toFlatArray(fbb2);
        fbb2.finish(offset2);
        return this.append(fbb, fbb2);
    }

    public long writeHistogramEventDiscrete(@NonNull String name, EventSubtype subtype, long time, int iteration, int epoch, List<String> binLabels, @NonNull INDArray y) throws IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (y == null) {
            throw new NullPointerException("y is marked non-null but is null");
        }
        Preconditions.checkState(binLabels == null || (long)binLabels.size() == y.length(), "Number of bin labels (if present) must be same as Y array length - got %s bins, array shape %ndShape", binLabels == null ? 0L : (long)binLabels.size(), y.length());
        Preconditions.checkState(y.rank() == 1, "Y array must be rank 1, got Y array with shape %ndShape", (Object)y);
        Preconditions.checkState(this.indexNameMap.containsKey(name), "Name \"%s\" not yet registered", (Object)name);
        int idx = this.indexNameMap.get(name);
        FlatBufferBuilder fbb = new FlatBufferBuilder(0);
        int offset = UIEvent.createUIEvent(fbb, (byte)4, subtype.asUIEventSubtype(), idx, time, iteration, epoch, (short)-1, 0, 0);
        fbb.finish(offset);
        FlatBufferBuilder fbb2 = new FlatBufferBuilder(0);
        int yOffset = y.toFlatArray(fbb2);
        int binLabelsOffset = 0;
        if (binLabels != null) {
            int[] str = new int[binLabels.size()];
            for (int i = 0; i < binLabels.size(); ++i) {
                String s = binLabels.get(i);
                if (s == null) {
                    s = "";
                }
                str[i] = fbb2.createString((CharSequence)s);
            }
            binLabelsOffset = UIHistogram.createBinlabelsVector(fbb2, str);
        }
        int offset2 = UIHistogram.createUIHistogram(fbb2, (byte)0, y.length(), 0, yOffset, binLabelsOffset);
        fbb2.finish(offset2);
        return this.append(fbb, fbb2);
    }

    public long writeHistogramEventEqualSpacing(String name, EventSubtype subtype, long time, int iteration, int epoch, double min, double max, INDArray y) throws IOException {
        Preconditions.checkState(y.rank() == 1, "Y array must be rank 1, got Y array with shape %ndShape", (Object)y);
        Preconditions.checkState(max > min, "Maximum histogram value must be greater than minimum - got max=%s, min=%s", max, min);
        Preconditions.checkState(this.indexNameMap.containsKey(name), "Name \"%s\" not yet registered", (Object)name);
        int idx = this.indexNameMap.get(name);
        FlatBufferBuilder fbb = new FlatBufferBuilder(0);
        int offset = UIEvent.createUIEvent(fbb, (byte)4, subtype.asUIEventSubtype(), idx, time, iteration, epoch, (short)-1, 0, 0);
        fbb.finish(offset);
        FlatBufferBuilder fbb2 = new FlatBufferBuilder(0);
        int yOffset = y.toFlatArray(fbb2);
        INDArray binRangesArr = Nd4j.createFromArray(min, max);
        int binRangesOffset = binRangesArr.toFlatArray(fbb2);
        int offset2 = UIHistogram.createUIHistogram(fbb2, (byte)1, y.length(), binRangesOffset, yOffset, 0);
        fbb2.finish(offset2);
        return this.append(fbb, fbb2);
    }

    public long writeHistogramEventCustomBins(String name, EventSubtype subtype, long time, int iteration, int epoch, INDArray bins, INDArray y) throws IOException {
        Preconditions.checkState(y.rank() == 1, "Y array must be rank 1, got Y array with shape %ndShape", (Object)y);
        Preconditions.checkState(bins.rank() == 2, "Bins array must have shape [2,numBins], got bins array with shape %ndShape", (Object)bins);
        Preconditions.checkState(y.length() == bins.size(1), "Bins array must have shape [2,numBins], where numBins must match y.length()=%s, got bins array with shape %ndShape", (Object)y.length(), (Object)bins);
        Preconditions.checkState(this.indexNameMap.containsKey(name), "Name \"%s\" not yet registered", (Object)name);
        int idx = this.indexNameMap.get(name);
        FlatBufferBuilder fbb = new FlatBufferBuilder(0);
        int offset = UIEvent.createUIEvent(fbb, (byte)4, subtype.asUIEventSubtype(), idx, time, iteration, epoch, (short)-1, 0, 0);
        fbb.finish(offset);
        FlatBufferBuilder fbb2 = new FlatBufferBuilder(0);
        int yOffset = y.toFlatArray(fbb2);
        int binRangesOffset = bins.toFlatArray(fbb2);
        int offset2 = UIHistogram.createUIHistogram(fbb2, (byte)2, y.length(), binRangesOffset, yOffset, 0);
        fbb2.finish(offset2);
        return this.append(fbb, fbb2);
    }

    protected Pair<Integer, FlatBufferBuilder> encodeStaticHeader(byte type) {
        FlatBufferBuilder fbb = new FlatBufferBuilder(12);
        int staticInfoOffset = UIStaticInfoRecord.createUIStaticInfoRecord(fbb, type);
        fbb.finish(staticInfoOffset);
        int lengthHeader = fbb.offset();
        return new Pair<Integer, FlatBufferBuilder>(lengthHeader, fbb);
    }

    protected int encodeGraphStructure(FlatBufferBuilder fbb, SameDiff sd) {
        List<String> inputs = sd.inputs();
        int[] inputListStrOffsets = new int[inputs.size()];
        for (int i = 0; i < inputs.size(); ++i) {
            inputListStrOffsets[i] = fbb.createString((CharSequence)inputs.get(i));
        }
        int inputsOffset = UIGraphStructure.createInputsVector(fbb, inputListStrOffsets);
        int inputPairOffset = -1;
        List<String> outputs = sd.outputs();
        int outputsOffset = 0;
        if (outputs != null && !outputs.isEmpty()) {
            int[] outputListStrOffsets = new int[outputs.size()];
            for (int i = 0; i < outputListStrOffsets.length; ++i) {
                outputListStrOffsets[i] = fbb.createString((CharSequence)outputs.get(i));
            }
            outputsOffset = UIGraphStructure.createInputsVector(fbb, outputListStrOffsets);
        }
        PatriciaTrie<Variable> varMap = sd.getVariables();
        int[] varListOffsets = new int[varMap.size()];
        int count = 0;
        for (Map.Entry e : varMap.entrySet()) {
            INDArray arr;
            List<String> cds;
            int intPair = 0;
            int name = fbb.createString((CharSequence)e.getKey());
            String outputOfOp = ((Variable)e.getValue()).getOutputOfOp();
            int outputOfOpIdx = 0;
            if (outputOfOp != null) {
                outputOfOpIdx = fbb.createString((CharSequence)outputOfOp);
            }
            List<String> inputsForOps = ((Variable)e.getValue()).getInputsForOp();
            int inputsForOpIdx = 0;
            if (inputsForOps != null && !inputsForOps.isEmpty()) {
                int[] idx = this.encodeStrings(fbb, inputsForOps);
                inputsForOpIdx = UIVariable.createInputsForOpVector(fbb, idx);
            }
            List<String> controlDepsForOp = ((Variable)e.getValue()).getControlDepsForOp();
            int controlDepsForOpIdx = 0;
            if (controlDepsForOp != null && !controlDepsForOp.isEmpty()) {
                int[] idx = this.encodeStrings(fbb, controlDepsForOp);
                controlDepsForOpIdx = UIVariable.createInputsForOpVector(fbb, idx);
            }
            List<String> controlDepsForVar = ((Variable)e.getValue()).getControlDepsForVar();
            int controlDepsForVarIdx = 0;
            if (controlDepsForVar != null && !controlDepsForVar.isEmpty()) {
                int[] idx = this.encodeStrings(fbb, controlDepsForVar);
                controlDepsForVarIdx = UIVariable.createInputsForOpVector(fbb, idx);
            }
            DataType dt = ((Variable)e.getValue()).getVariable().dataType();
            byte dtVal = FlatBuffersMapper.getDataTypeAsByte(dt);
            long[] shape = ((Variable)e.getValue()).getVariable().getShape();
            int shapeOffset = 0;
            if (shape != null) {
                shapeOffset = UIVariable.createShapeVector(fbb, shape);
            }
            int controlDepsIdx = 0;
            if (((Variable)e.getValue()).getControlDeps() != null && !(cds = ((Variable)e.getValue()).getControlDeps()).isEmpty()) {
                int[] cdIdxs = new int[cds.size()];
                for (int i = 0; i < cdIdxs.length; ++i) {
                    cdIdxs[i] = fbb.createString((CharSequence)cds.get(i));
                }
                controlDepsIdx = UIVariable.createControlDepsVector(fbb, cdIdxs);
            }
            int uiExtraLabelOffset = 0;
            int constantValueOffset = 0;
            if (((Variable)e.getValue()).getVariable().getVariableType() == VariableType.CONSTANT && (arr = ((Variable)e.getValue()).getVariable().getArr()) != null && arr.length() < 1000L) {
                constantValueOffset = arr.toFlatArray(fbb);
            }
            int uiVariableIdx = UIVariable.createUIVariable(fbb, intPair, name, FlatBuffersMapper.toVarType(((Variable)e.getValue()).getVariable().getVariableType()), dtVal, shapeOffset, controlDepsIdx, outputOfOpIdx, inputsForOpIdx, controlDepsForOpIdx, controlDepsForVarIdx, 0, uiExtraLabelOffset, constantValueOffset);
            varListOffsets[count++] = uiVariableIdx;
        }
        int outputsListOffset = UIGraphStructure.createVariablesVector(fbb, varListOffsets);
        Map<String, SameDiffOp> opMap = sd.getOps();
        count = 0;
        int[] opListOffsets = new int[opMap.size()];
        for (Map.Entry<String, SameDiffOp> e : opMap.entrySet()) {
            String frame;
            int nameIdx = fbb.createString((CharSequence)e.getKey());
            String opName = e.getValue().getOp().opName();
            int opNameIdx = fbb.createString((CharSequence)opName);
            int inputsIdx = 0;
            List<String> opInputs = e.getValue().getInputsToOp();
            if (opInputs != null && !opInputs.isEmpty()) {
                int[] idx = this.encodeStrings(fbb, opInputs);
                inputsIdx = UIOp.createInputsVector(fbb, idx);
            }
            int outputsIdx = 0;
            List<String> opOutputs = e.getValue().getOutputsOfOp();
            if (opOutputs != null && !opOutputs.isEmpty()) {
                int[] idx = this.encodeStrings(fbb, opOutputs);
                outputsIdx = UIOp.createOutputsVector(fbb, idx);
            }
            int controlDepIdxs = 0;
            List<String> opCDeps = e.getValue().getControlDeps();
            if (opCDeps != null && !opCDeps.isEmpty()) {
                int[] idx = this.encodeStrings(fbb, opCDeps);
                controlDepIdxs = UIOp.createControlDepsVector(fbb, idx);
            }
            int extraLabelOffset = 0;
            DifferentialFunction df = e.getValue().getOp();
            if ((df instanceof Enter || df instanceof Exit || df instanceof NextIteration) && (frame = ((BaseCompatOp)df).getFrameName()) != null) {
                String extra = "Frame: \"" + frame + "\"";
                extraLabelOffset = fbb.createString((CharSequence)extra);
            }
            opListOffsets[count++] = UIOp.createUIOp(fbb, nameIdx, opNameIdx, inputsIdx, outputsIdx, controlDepIdxs, extraLabelOffset);
        }
        int opsListOffset = UIGraphStructure.createOpsVector(fbb, opListOffsets);
        return UIGraphStructure.createUIGraphStructure(fbb, inputsOffset, inputPairOffset, outputsOffset, outputsListOffset, opsListOffset);
    }

    private int[] encodeStrings(FlatBufferBuilder fbb, List<String> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        int[] idx = new int[list.size()];
        for (int i = 0; i < idx.length; ++i) {
            idx[i] = fbb.createString((CharSequence)list.get(i));
        }
        return idx;
    }

    /*
     * Exception decompiling
     */
    private long append(FlatBufferBuilder h, FlatBufferBuilder c) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class StaticInfo {
        private final List<Pair<UIStaticInfoRecord, Table>> data;
        private final long fileOffset;

        public StaticInfo(List<Pair<UIStaticInfoRecord, Table>> data, long fileOffset) {
            this.data = data;
            this.fileOffset = fileOffset;
        }

        public List<Pair<UIStaticInfoRecord, Table>> getData() {
            return this.data;
        }

        public long getFileOffset() {
            return this.fileOffset;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StaticInfo)) {
                return false;
            }
            StaticInfo other = (StaticInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getFileOffset() != other.getFileOffset()) {
                return false;
            }
            List<Pair<UIStaticInfoRecord, Table>> this$data = this.getData();
            List<Pair<UIStaticInfoRecord, Table>> other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StaticInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $fileOffset = this.getFileOffset();
            result = result * 59 + (int)($fileOffset >>> 32 ^ $fileOffset);
            List<Pair<UIStaticInfoRecord, Table>> $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        public String toString() {
            return "LogFileWriter.StaticInfo(data=" + this.getData() + ", fileOffset=" + this.getFileOffset() + ")";
        }
    }

    public static enum EventSubtype {
        NONE,
        EVALUATION,
        LOSS,
        LEARNING_RATE,
        TUNING_METRIC,
        PERFORMANCE,
        PROFILING,
        FEATURE_LABEL,
        PREDICTION,
        USER_CUSTOM;


        public byte asUIEventSubtype() {
            switch (this) {
                case NONE: {
                    return 0;
                }
                case EVALUATION: {
                    return 1;
                }
                case LOSS: {
                    return 2;
                }
                case LEARNING_RATE: {
                    return 3;
                }
                case TUNING_METRIC: {
                    return 4;
                }
                case PERFORMANCE: {
                    return 5;
                }
                case PROFILING: {
                    return 6;
                }
                case FEATURE_LABEL: {
                    return 7;
                }
                case PREDICTION: {
                    return 8;
                }
                case USER_CUSTOM: {
                    return 9;
                }
            }
            throw new RuntimeException();
        }
    }
}

