/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ndarray;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.nd4j.common.primitives.Triple;
import org.nd4j.linalg.api.buffer.BaseDataBuffer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class BaseNDArrayProxy
implements Serializable {
    protected long[] arrayShape;
    protected long length;
    protected char arrayOrdering;
    protected transient DataBuffer data;

    public BaseNDArrayProxy(INDArray anInstance) {
        if (anInstance.isView()) {
            anInstance = anInstance.dup(anInstance.ordering());
        }
        this.arrayShape = anInstance.shape();
        this.length = anInstance.length();
        this.arrayOrdering = anInstance.ordering();
        this.data = anInstance.data();
    }

    private Object readResolve() throws ObjectStreamException {
        return Nd4j.create(this.data, this.arrayShape, Nd4j.getStrides(this.arrayShape, this.arrayOrdering), 0L, this.arrayOrdering);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        try {
            s.defaultReadObject();
            this.read(s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void read(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Triple<DataBuffer.AllocationMode, Long, DataType> header = BaseDataBuffer.readHeader(s);
        this.data = Nd4j.createBuffer(header.getRight(), this.length, false);
        this.data.read(s, header.getLeft(), (long)header.getMiddle(), header.getRight());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.write(out);
    }

    protected void write(ObjectOutputStream out) throws IOException {
        this.data.write(out);
    }
}

