/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.custom;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class AdjustSaturation
extends DynamicCustomOp {
    public AdjustSaturation() {
    }

    public AdjustSaturation(@NonNull INDArray in, double factor, INDArray out) {
        this(in, factor);
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (out != null) {
            this.outputArguments.add(out);
        }
    }

    public AdjustSaturation(@NonNull INDArray in, double factor) {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        Preconditions.checkArgument(in.rank() >= 3, "AdjustSaturation: op expects rank of input array to be >= 3, but got %s instead", in.rank());
        this.inputArguments.add(in);
        this.addTArgument(factor);
    }

    public AdjustSaturation(@NonNull SameDiff sameDiff, @NonNull SDVariable in, @NonNull SDVariable factor) {
        super(sameDiff, new SDVariable[]{in, factor});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (factor == null) {
            throw new NullPointerException("factor is marked non-null but is null");
        }
    }

    public AdjustSaturation(@NonNull SameDiff sameDiff, @NonNull SDVariable in, double factor) {
        super(sameDiff, new SDVariable[]{in});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        this.addTArgument(factor);
    }

    @Override
    public String opName() {
        return "adjust_saturation";
    }

    @Override
    public String tensorflowName() {
        return "AdjustSaturation";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() == n, "Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }
}

