/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.custom;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class Flatten
extends DynamicCustomOp {
    private long order;

    public Flatten(char order2, INDArray ... inputs) {
        this.order = order2;
        for (INDArray in : inputs) {
            this.inputArguments.add(in);
        }
        this.iArguments.add(Long.valueOf((int)this.order));
    }

    public Flatten(INDArray output, INDArray ... inputs) {
        this(output.ordering(), inputs);
        this.outputArguments.add(output);
    }

    public Flatten(SameDiff sameDiff, char order2, SDVariable ... inputs) {
        super(sameDiff, inputs);
        this.order = order2;
        this.addIArgument(new int[]{order2});
    }

    @Override
    public String opName() {
        return "flatten";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        return Arrays.asList(i_v.get(0).reshape(this.arg(0).shape()));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() == n, "Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        return Arrays.asList(inputDataTypes.get(0));
    }

    public long getOrder() {
        return this.order;
    }

    public void setOrder(long order2) {
        this.order = order2;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Flatten)) {
            return false;
        }
        Flatten other = (Flatten)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getOrder() == other.getOrder();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Flatten;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $order = this.getOrder();
        result = result * 59 + (int)($order >>> 32 ^ $order);
        return result;
    }

    @Override
    public String toString() {
        return "Flatten(order=" + this.getOrder() + ")";
    }

    public Flatten() {
    }
}

