/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.image;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class ResizeBilinear
extends DynamicCustomOp {
    protected boolean alignCorners = false;
    protected boolean halfPixelCenters = false;
    protected Integer height = null;
    protected Integer width = null;

    public ResizeBilinear(@NonNull SameDiff sd, @NonNull SDVariable input, int height, int width, boolean alignCorners, boolean halfPixelCenters) {
        super(sd, input);
        if (sd == null) {
            throw new NullPointerException("sd is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        this.alignCorners = alignCorners;
        this.height = height;
        this.width = width;
        this.halfPixelCenters = halfPixelCenters;
        this.addArgs();
    }

    public ResizeBilinear(@NonNull INDArray x, INDArray z, int height, int width, boolean alignCorners, boolean halfPixelCenters) {
        super(new INDArray[]{x}, new INDArray[]{z});
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        this.alignCorners = alignCorners;
        this.halfPixelCenters = halfPixelCenters;
        this.height = height;
        this.width = width;
        this.addArgs();
    }

    public ResizeBilinear(INDArray input, int height, int width, boolean alignCorners, boolean halfPixelCenters) {
        this(input, null, height, width, alignCorners, halfPixelCenters);
    }

    @Override
    public String opName() {
        return "resize_bilinear";
    }

    @Override
    public String tensorflowName() {
        return "ResizeBilinear";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        AttrValue attrC = attributesForNode.get("align_corners");
        AttrValue attrH = attributesForNode.get("half_pixel_centers");
        this.alignCorners = attrC != null ? attrC.getB() : false;
        this.halfPixelCenters = attrH != null ? attrH.getB() : false;
        this.addArgs();
    }

    protected void addArgs() {
        this.iArguments.clear();
        if (this.height != null && this.width != null) {
            this.iArguments.add(Long.valueOf(this.height.intValue()));
            this.iArguments.add(Long.valueOf(this.width.intValue()));
        }
        this.addBArgument(this.alignCorners, this.halfPixelCenters);
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("alignCorners", this.alignCorners);
        ret.put("height", this.height);
        ret.put("width", this.width);
        return ret;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState(inputDataTypes != null && (inputDataTypes.size() == 1 || inputDataTypes.size() == 2), "Expected 1 or 2 input datatypes for %s, got %s", this.getClass(), inputDataTypes);
        if (inputDataTypes.get(0).isFPType()) {
            return Collections.singletonList(inputDataTypes.get(0));
        }
        return Collections.singletonList(Nd4j.defaultFloatingPointType());
    }

    public ResizeBilinear() {
    }
}

