/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import onnx.Onnx;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.internal.SameDiffOp;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.BatchNormDerivative;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class BatchNorm
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(BatchNorm.class);
    private boolean applyGamma;
    private boolean applyBeta;
    private double epsilon;
    private int[] jaxis;

    public BatchNorm(SameDiff sameDiff, SDVariable[] inputFunctions, INDArray[] inputArrays, INDArray[] outputArrays, boolean inPlace, boolean applyGamma, boolean applyBeta, double epsilon, int[] axis) {
        super(null, sameDiff, inputFunctions, inPlace);
        Preconditions.checkState(axis != null && axis.length > 0, "Invalid axis argument: axis must be specifiedand length > 0. Got %s", (Object)axis);
        this.sameDiff = sameDiff;
        this.applyGamma = applyGamma;
        this.applyBeta = applyBeta;
        this.epsilon = epsilon;
        this.jaxis = axis;
        if (inputArrays != null) {
            this.addInputArgument(inputArrays);
        }
        if (outputArrays != null) {
            this.addOutputArgument(outputArrays);
        }
        this.addArgs();
    }

    public BatchNorm(SameDiff sameDiff, SDVariable input, SDVariable mean, SDVariable variance, SDVariable gamma, SDVariable beta, double epsilon, int[] axis) {
        super(null, sameDiff, BatchNorm.wrapFilterNull(input, mean, variance, gamma, beta), false);
        Preconditions.checkState(axis != null && axis.length > 0, "Invalid axis argument: axis must be specifiedand length > 0. Got %s", (Object)axis);
        this.sameDiff = sameDiff;
        this.applyBeta = beta != null;
        this.applyGamma = gamma != null;
        this.epsilon = epsilon;
        this.jaxis = axis;
        this.addArgs();
    }

    public BatchNorm(INDArray input, INDArray mean, INDArray variance, INDArray gamma, INDArray beta, double epsilon, int ... axis) {
        super(BatchNorm.wrapFilterNull(input, mean, variance, gamma, beta), null);
        this.jaxis = axis;
        this.applyBeta = beta != null;
        this.applyGamma = gamma != null;
        this.epsilon = epsilon;
        this.addArgs();
    }

    public void addArgs() {
        this.addIArgument(ArrayUtil.fromBoolean(this.applyGamma));
        this.addIArgument(ArrayUtil.fromBoolean(this.applyBeta));
        if (this.jaxis != null) {
            this.axis.clear();
            for (int v : this.jaxis) {
                this.axis.add(v);
            }
            this.addIArgument(this.jaxis);
        }
        this.addTArgument(this.epsilon);
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("applyGamma", this.applyGamma);
        ret.put("applyBeta", this.applyBeta);
        ret.put("epsilon", this.epsilon);
        ret.put("axis", this.axis);
        return ret;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        SameDiffOp op = initWith.getOps().get(this.getOwnName());
        List<String> list = op.getInputsToOp();
        List<String> newList = Arrays.asList(list.get(0), list.get(3), list.get(4), list.get(1), list.get(2));
        op.setInputsToOp(newList);
        this.applyGamma = true;
        this.applyBeta = true;
        this.epsilon = attributesForNode.get("epsilon").getF();
        if (attributesForNode.containsKey("data_format")) {
            String dataFormat = attributesForNode.get("data_format").getS().toStringUtf8();
            if (dataFormat.equalsIgnoreCase("NCHW") || dataFormat.equalsIgnoreCase("NCW") || dataFormat.equalsIgnoreCase("NCDHW")) {
                this.jaxis = new int[]{1};
            } else if (dataFormat.equalsIgnoreCase("NHWC")) {
                this.jaxis = new int[]{3};
            } else if (dataFormat.equalsIgnoreCase("NWC")) {
                this.jaxis = new int[]{2};
            } else if (dataFormat.equalsIgnoreCase("NDHWC")) {
                this.jaxis = new int[]{4};
            } else {
                throw new IllegalStateException("Unknown data format: \"" + dataFormat + "\"");
            }
        }
        this.addArgs();
    }

    @Override
    public void initFromOnnx(Onnx.NodeProto node, SameDiff initWith, Map<String, Onnx.AttributeProto> attributesForNode, Onnx.GraphProto graph) {
    }

    @Override
    public String opName() {
        return "batchnorm";
    }

    @Override
    public String onnxName() {
        return "BatchNormalization";
    }

    @Override
    public String tensorflowName() {
        return "FusedBatchNorm";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        ArrayList<SDVariable> ret = new ArrayList<SDVariable>();
        ArrayList<SDVariable> inputs = new ArrayList<SDVariable>(Arrays.asList(this.args()));
        inputs.add(f1.get(0));
        BatchNormDerivative batchNormDerivative = BatchNormDerivative.derivativeBuilder().sameDiff(this.sameDiff).inputFunctions(inputs.toArray(new SDVariable[inputs.size()])).applyGamma(this.applyGamma).applyBeta(this.applyBeta).epsilon(this.epsilon).axis(this.jaxis).build();
        ret.addAll(Arrays.asList(batchNormDerivative.outputVariables()));
        return ret;
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() >= 3 && inputDataTypes.size() <= 5, "Expected 3 to 5 input datatypes for %s, got %s", this.getClass(), inputDataTypes);
        if (inputDataTypes.get(0).isFPType()) {
            return Collections.singletonList(inputDataTypes.get(0));
        }
        return Collections.singletonList(Nd4j.defaultFloatingPointType());
    }

    public static BatchNormBuilder builder() {
        return new BatchNormBuilder();
    }

    public boolean isApplyGamma() {
        return this.applyGamma;
    }

    public boolean isApplyBeta() {
        return this.applyBeta;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public int[] getJaxis() {
        return this.jaxis;
    }

    public BatchNorm() {
    }

    public static class BatchNormBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputFunctions;
        private INDArray[] inputArrays;
        private INDArray[] outputArrays;
        private boolean inPlace;
        private boolean applyGamma;
        private boolean applyBeta;
        private double epsilon;
        private int[] axis;

        BatchNormBuilder() {
        }

        public BatchNormBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public BatchNormBuilder inputFunctions(SDVariable[] inputFunctions) {
            this.inputFunctions = inputFunctions;
            return this;
        }

        public BatchNormBuilder inputArrays(INDArray[] inputArrays) {
            this.inputArrays = inputArrays;
            return this;
        }

        public BatchNormBuilder outputArrays(INDArray[] outputArrays) {
            this.outputArrays = outputArrays;
            return this;
        }

        public BatchNormBuilder inPlace(boolean inPlace) {
            this.inPlace = inPlace;
            return this;
        }

        public BatchNormBuilder applyGamma(boolean applyGamma) {
            this.applyGamma = applyGamma;
            return this;
        }

        public BatchNormBuilder applyBeta(boolean applyBeta) {
            this.applyBeta = applyBeta;
            return this;
        }

        public BatchNormBuilder epsilon(double epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        public BatchNormBuilder axis(int[] axis) {
            this.axis = axis;
            return this;
        }

        public BatchNorm build() {
            return new BatchNorm(this.sameDiff, this.inputFunctions, this.inputArrays, this.outputArrays, this.inPlace, this.applyGamma, this.applyBeta, this.epsilon, this.axis);
        }

        public String toString() {
            return "BatchNorm.BatchNormBuilder(sameDiff=" + this.sameDiff + ", inputFunctions=" + Arrays.deepToString(this.inputFunctions) + ", inputArrays=" + Arrays.deepToString(this.inputArrays) + ", outputArrays=" + Arrays.deepToString(this.outputArrays) + ", inPlace=" + this.inPlace + ", applyGamma=" + this.applyGamma + ", applyBeta=" + this.applyBeta + ", epsilon=" + this.epsilon + ", axis=" + Arrays.toString(this.axis) + ")";
        }
    }
}

