/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv2DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.PaddingMode;

public class Col2Im
extends DynamicCustomOp {
    protected Conv2DConfig conv2DConfig;

    public Col2Im(SameDiff sameDiff, SDVariable[] inputFunctions, INDArray[] inputArrays, INDArray[] outputs, Conv2DConfig conv2DConfig) {
        super(null, inputArrays, outputs);
        if (sameDiff != null) {
            this.sameDiff = sameDiff;
        }
        this.conv2DConfig = conv2DConfig;
        this.addArgs();
    }

    public Col2Im(@NonNull SameDiff sd, @NonNull SDVariable input, @NonNull Conv2DConfig config) {
        super(null, sd, new SDVariable[]{input});
        if (sd == null) {
            throw new NullPointerException("sd is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.conv2DConfig = config;
        this.addArgs();
    }

    public Col2Im() {
    }

    public Col2Im(@NonNull INDArray in, @NonNull Conv2DConfig conv2DConfig) {
        super("col2Im", in, null, null, null);
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (conv2DConfig == null) {
            throw new NullPointerException("conv2DConfig is marked non-null but is null");
        }
        this.conv2DConfig = conv2DConfig;
    }

    protected void addArgs() {
        this.addIArgument(this.conv2DConfig.getSH());
        this.addIArgument(this.conv2DConfig.getSW());
        this.addIArgument(this.conv2DConfig.getPH());
        this.addIArgument(this.conv2DConfig.getPW());
        this.addIArgument(this.conv2DConfig.getKH());
        this.addIArgument(this.conv2DConfig.getKW());
        this.addIArgument(this.conv2DConfig.getDH());
        this.addIArgument(this.conv2DConfig.getDW());
        this.addIArgument(this.conv2DConfig.getPaddingMode().index);
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        return this.conv2DConfig.toProperties();
    }

    @Override
    public void setPropertiesForFunction(Map<String, Object> properties) {
        if (this.conv2DConfig == null) {
            Long paddingMode;
            Long kH;
            Long kW;
            Long pH;
            Long sH;
            Long dW;
            Long pW;
            Long sW;
            Conv2DConfig.Conv2DConfigBuilder builder = Conv2DConfig.builder();
            Long dH = this.getLongValueFromProperty("dH", properties);
            if (dH != null) {
                builder.dH(dH);
            }
            if ((sW = this.getLongValueFromProperty("sW", properties)) != null) {
                builder.sW(sW);
            }
            if ((pW = this.getLongValueFromProperty("pW", properties)) != null) {
                builder.pW(pW);
            }
            if ((dW = this.getLongValueFromProperty("dW", properties)) != null) {
                builder.dW(dW);
            }
            if ((sH = this.getLongValueFromProperty("sH", properties)) != null) {
                builder.sH(sH);
            }
            if ((pH = this.getLongValueFromProperty("pH", properties)) != null) {
                builder.pH(pH);
            }
            if ((kW = this.getLongValueFromProperty("kW", properties)) != null) {
                builder.kW(kW);
            }
            if ((kH = this.getLongValueFromProperty("kH", properties)) != null) {
                builder.kH(kH);
            }
            if ((paddingMode = this.getLongValueFromProperty("paddingMode", properties)) != null) {
                builder.paddingMode(PaddingMode.fromNumber(paddingMode.intValue()));
            }
            this.conv2DConfig = builder.build();
        }
    }

    @Override
    public void configureFromArguments() {
        if (this.conv2DConfig == null && this.iArguments.size() >= 10) {
            this.conv2DConfig = Conv2DConfig.builder().kH((Long)this.iArguments.get(0)).kW((Long)this.iArguments.get(1)).sH((Long)this.iArguments.get(2)).sW((Long)this.iArguments.get(3)).pH((Long)this.iArguments.get(4)).pW((Long)this.iArguments.get(5)).dH((Long)this.iArguments.get(6)).dW((Long)this.iArguments.get(7)).paddingMode(PaddingMode.fromNumber(((Long)this.iArguments.get(8)).intValue())).build();
        }
    }

    @Override
    public String opName() {
        return "col2im";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        throw new UnsupportedOperationException("Unable to run derivative op on col2im");
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() == 1, "Expected 1 input data type for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    public static Col2ImBuilder builder() {
        return new Col2ImBuilder();
    }

    public Conv2DConfig getConv2DConfig() {
        return this.conv2DConfig;
    }

    public static class Col2ImBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputFunctions;
        private INDArray[] inputArrays;
        private INDArray[] outputs;
        private Conv2DConfig conv2DConfig;

        Col2ImBuilder() {
        }

        public Col2ImBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public Col2ImBuilder inputFunctions(SDVariable[] inputFunctions) {
            this.inputFunctions = inputFunctions;
            return this;
        }

        public Col2ImBuilder inputArrays(INDArray[] inputArrays) {
            this.inputArrays = inputArrays;
            return this;
        }

        public Col2ImBuilder outputs(INDArray[] outputs) {
            this.outputs = outputs;
            return this;
        }

        public Col2ImBuilder conv2DConfig(Conv2DConfig conv2DConfig) {
            this.conv2DConfig = conv2DConfig;
            return this;
        }

        public Col2Im build() {
            return new Col2Im(this.sameDiff, this.inputFunctions, this.inputArrays, this.outputs, this.conv2DConfig);
        }

        public String toString() {
            return "Col2Im.Col2ImBuilder(sameDiff=" + this.sameDiff + ", inputFunctions=" + Arrays.deepToString(this.inputFunctions) + ", inputArrays=" + Arrays.deepToString(this.inputArrays) + ", outputs=" + Arrays.deepToString(this.outputs) + ", conv2DConfig=" + this.conv2DConfig + ")";
        }
    }
}

