/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.DeConv3DConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class DeConv3DTF
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(DeConv3DTF.class);
    protected DeConv3DConfig config;

    public DeConv3DTF(@NonNull SameDiff sameDiff, @NonNull SDVariable shape, @NonNull SDVariable weights, @NonNull SDVariable input, @NonNull DeConv3DConfig config) {
        super(sameDiff, new SDVariable[]{shape, weights, input});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
        this.addArgs();
    }

    @Override
    public long[] iArgs() {
        if (this.iArguments.size() == 0) {
            this.addArgs();
        }
        return super.iArgs();
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        if (this.config == null && !this.iArguments.isEmpty()) {
            this.config = DeConv3DConfig.builder().kD((Long)this.iArguments.get(0)).kH((Long)this.iArguments.get(1)).kW((Long)this.iArguments.get(2)).sD((Long)this.iArguments.get(3)).sH((Long)this.iArguments.get(4)).sW((Long)this.iArguments.get(5)).pD((Long)this.iArguments.get(6)).pH((Long)this.iArguments.get(7)).pW((Long)this.iArguments.get(8)).dD((Long)this.iArguments.get(9)).dH((Long)this.iArguments.get(10)).dW((Long)this.iArguments.get(11)).isSameMode((Long)this.iArguments.get(12) == 1L).dataFormat((Long)this.iArguments.get(13) == 1L ? "NDHWC" : "NCDHW").build();
        }
        return this.config.toProperties();
    }

    private void addArgs() {
        this.addIArgument(this.config.getKD());
        this.addIArgument(this.config.getKH());
        this.addIArgument(this.config.getKW());
        this.addIArgument(this.config.getSD());
        this.addIArgument(this.config.getSH());
        this.addIArgument(this.config.getSW());
        this.addIArgument(this.config.getPD());
        this.addIArgument(this.config.getPH());
        this.addIArgument(this.config.getPW());
        this.addIArgument(this.config.getDD());
        this.addIArgument(this.config.getDH());
        this.addIArgument(this.config.getDW());
        this.addIArgument(ArrayUtil.fromBoolean(this.config.isSameMode()));
        this.addIArgument(this.config.getDataFormat().equalsIgnoreCase("NCDHW") ? 0 : 1);
    }

    @Override
    public boolean isConfigProperties() {
        return true;
    }

    @Override
    public String configFieldName() {
        return "config";
    }

    @Override
    public Object getValue(Field property) {
        if (this.config == null) {
            this.config = DeConv3DConfig.builder().build();
        }
        return this.config.getValue(property);
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        DeConv3DConfig conv3DConfig;
        int dW;
        int dH;
        int dD;
        int sW;
        int sH;
        int sD;
        AttrValue aStrides = nodeDef.getAttrOrThrow("strides");
        AttrValue aDilations = nodeDef.getAttrOrDefault("dilations", null);
        List<Long> tfStrides = aStrides.getList().getIList();
        List<Long> tfDilation = aDilations == null ? null : aDilations.getList().getIList();
        AttrValue aPadding = nodeDef.getAttrOrDefault("padding", null);
        String paddingMode = aPadding.getS().toStringUtf8();
        String dataFormat = "NDHWC";
        if (nodeDef.containsAttr("data_format")) {
            AttrValue attr = nodeDef.getAttrOrThrow("data_format");
            dataFormat = attr.getS().toStringUtf8().toLowerCase();
        }
        if (dataFormat.equalsIgnoreCase("NCDHW")) {
            sD = tfStrides.get(2).intValue();
            sH = tfStrides.get(3).intValue();
            sW = tfStrides.get(4).intValue();
            dD = tfDilation == null ? 1 : tfDilation.get(2).intValue();
            dH = tfDilation == null ? 1 : tfDilation.get(3).intValue();
            dW = tfDilation == null ? 1 : tfDilation.get(4).intValue();
        } else {
            sD = tfStrides.get(1).intValue();
            sH = tfStrides.get(2).intValue();
            sW = tfStrides.get(3).intValue();
            dD = tfDilation == null ? 1 : tfDilation.get(1).intValue();
            dH = tfDilation == null ? 1 : tfDilation.get(2).intValue();
            dW = tfDilation == null ? 1 : tfDilation.get(3).intValue();
        }
        boolean isSameMode = paddingMode.equalsIgnoreCase("SAME");
        this.config = conv3DConfig = DeConv3DConfig.builder().kD(-1L).kH(-1L).kW(-1L).sD(sD).sH(sW).sW(sH).dD(dD).dH(dH).dW(dW).isSameMode(isSameMode).dataFormat(dataFormat.equalsIgnoreCase("NCDHW") ? "NCDHW" : "NDHWC").build();
        this.addArgs();
    }

    @Override
    public String opName() {
        return "deconv3d_tf";
    }

    @Override
    public String[] tensorflowNames() {
        return new String[]{"Conv3DBackpropInput", "Conv3DBackpropInputV2"};
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        throw new UnsupportedOperationException("Backprop not yet implemented for " + this.getClass());
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() == n, "Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(2));
    }

    public DeConv3DConfig getConfig() {
        return this.config;
    }

    public DeConv3DTF() {
    }
}

