/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Conv2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.SConv2DDerivative;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv2DConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SConv2D
extends Conv2D {
    private static final Logger log = LoggerFactory.getLogger(SConv2D.class);

    public SConv2D(SameDiff sameDiff, SDVariable[] inputFunctions, Conv2DConfig conv2DConfig) {
        super(sameDiff, inputFunctions, conv2DConfig);
    }

    public SConv2D(@NonNull SameDiff sameDiff, @NonNull SDVariable layerInput, @NonNull SDVariable depthWeights, SDVariable pointWeights, SDVariable bias, @NonNull Conv2DConfig conv2DConfig) {
        this(sameDiff, SConv2D.wrapFilterNull(layerInput, depthWeights, pointWeights, bias), conv2DConfig);
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (layerInput == null) {
            throw new NullPointerException("layerInput is marked non-null but is null");
        }
        if (depthWeights == null) {
            throw new NullPointerException("depthWeights is marked non-null but is null");
        }
        if (conv2DConfig == null) {
            throw new NullPointerException("conv2DConfig is marked non-null but is null");
        }
    }

    public SConv2D(INDArray[] inputs, INDArray[] outputs, Conv2DConfig config) {
        super(inputs, outputs, config);
    }

    public SConv2D(@NonNull INDArray layerInput, @NonNull INDArray depthWeights, INDArray pointWeights, @NonNull Conv2DConfig Conv2DConfig2) {
        this(SConv2D.wrapFilterNull(layerInput, depthWeights, pointWeights), null, Conv2DConfig2);
        if (layerInput == null) {
            throw new NullPointerException("layerInput is marked non-null but is null");
        }
        if (depthWeights == null) {
            throw new NullPointerException("depthWeights is marked non-null but is null");
        }
        if (Conv2DConfig2 == null) {
            throw new NullPointerException("Conv2DConfig is marked non-null but is null");
        }
    }

    public SConv2D(INDArray layerInput, INDArray depthWeights, INDArray pointWeights, INDArray bias, Conv2DConfig config) {
        this(SConv2D.wrapFilterNull(layerInput, depthWeights, pointWeights, bias), null, config);
    }

    public SConv2D() {
    }

    @Override
    public String opName() {
        return "sconv2d";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        ArrayList<SDVariable> inputs = new ArrayList<SDVariable>();
        inputs.add(this.arg(0));
        inputs.add(f1.get(0));
        SDVariable[] args = this.args();
        for (int i = 1; i < args.length; ++i) {
            inputs.add(args[i]);
        }
        SConv2DDerivative conv2DDerivative = SConv2DDerivative.sDerviativeBuilder().conv2DConfig(this.config).inputFunctions(inputs.toArray(new SDVariable[inputs.size()])).sameDiff(this.sameDiff).build();
        List<SDVariable> ret = Arrays.asList(conv2DDerivative.outputVariables());
        return ret;
    }

    @Override
    public long[] iArgs() {
        if (this.iArguments.size() == 0) {
            this.addArgs();
        }
        return super.iArgs();
    }

    @Override
    public boolean isConfigProperties() {
        return true;
    }

    @Override
    public String configFieldName() {
        return "config";
    }

    @Override
    public String[] tensorflowNames() {
        throw new NoOpNameFoundException("No op name found for " + this.opName());
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for op " + this.opName());
    }

    @Override
    public String tensorflowName() {
        return "separable_conv2d";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() == n, "Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    public static SConv2DBuilder sameDiffSBuilder() {
        return new SConv2DBuilder();
    }

    public static class SConv2DBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputFunctions;
        private Conv2DConfig conv2DConfig;

        SConv2DBuilder() {
        }

        public SConv2DBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public SConv2DBuilder inputFunctions(SDVariable[] inputFunctions) {
            this.inputFunctions = inputFunctions;
            return this;
        }

        public SConv2DBuilder conv2DConfig(Conv2DConfig conv2DConfig) {
            this.conv2DConfig = conv2DConfig;
            return this;
        }

        public SConv2D build() {
            return new SConv2D(this.sameDiff, this.inputFunctions, this.conv2DConfig);
        }

        public String toString() {
            return "SConv2D.SConv2DBuilder(sameDiff=" + this.sameDiff + ", inputFunctions=" + Arrays.deepToString(this.inputFunctions) + ", conv2DConfig=" + this.conv2DConfig + ")";
        }
    }
}

