/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.recurrent;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.weights.GRUWeights;

public class GRUCell
extends DynamicCustomOp {
    private GRUWeights weights;

    public GRUCell() {
    }

    public GRUCell(SameDiff sameDiff, SDVariable x, SDVariable hLast, GRUWeights weights) {
        super(null, sameDiff, weights.argsWithInputs(x, hLast));
        this.weights = weights;
    }

    public GRUCell(INDArray x, INDArray hLast, GRUWeights gruWeights) {
        super(null, null, gruWeights.argsWithInputs(x, hLast));
        this.weights = gruWeights;
    }

    @Override
    public String opName() {
        return "gruCell";
    }

    @Override
    public String onnxName() {
        return "GRU";
    }

    @Override
    public String tensorflowName() {
        return "GRUBlockCell";
    }

    @Override
    public String[] onnxNames() {
        return super.onnxNames();
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() == 6, "Expected exactly 6 inputs to GRUCell, got %s", inputDataTypes);
        DataType dt = inputDataTypes.get(0);
        Preconditions.checkState(dt.isFPType(), "Input type 0 must be a floating point type, got %s", (Object)dt);
        return Arrays.asList(dt, dt, dt, dt);
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grads) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public GRUWeights getWeights() {
        return this.weights;
    }
}

