/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.loss.bp;

import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.loss.LossReduce;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public abstract class BaseLossBp
extends DynamicCustomOp {
    protected LossReduce lossReduce;

    public BaseLossBp(@NonNull SameDiff sameDiff, @NonNull LossReduce lossReduce, @NonNull SDVariable predictions, @NonNull SDVariable weights, @NonNull SDVariable labels) {
        super(null, sameDiff, new SDVariable[]{predictions, weights, labels});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (lossReduce == null) {
            throw new NullPointerException("lossReduce is marked non-null but is null");
        }
        if (predictions == null) {
            throw new NullPointerException("predictions is marked non-null but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked non-null but is null");
        }
        if (labels == null) {
            throw new NullPointerException("labels is marked non-null but is null");
        }
        this.lossReduce = lossReduce;
        this.addArgs();
    }

    protected BaseLossBp() {
    }

    protected void addArgs() {
        this.iArguments.clear();
        this.tArguments.clear();
        this.addIArgument(this.lossReduce.ordinal());
    }

    @Override
    public abstract String opName();

    @Override
    public int getNumOutputs() {
        return 3;
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState(inputDataTypes.get(0).isFPType(), "Input 0 (predictions) must be a floating point type; inputs datatypes are %s for %s", inputDataTypes, this.getClass());
        DataType dt0 = inputDataTypes.get(0);
        DataType dt1 = this.arg(1).dataType();
        DataType dt2 = this.arg(2).dataType();
        if (!dt1.isFPType()) {
            dt1 = dt0;
        }
        if (!dt2.isFPType()) {
            dt2 = dt0;
        }
        return Arrays.asList(dt0, dt1, dt2);
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        throw new UnsupportedOperationException("Differentiation of " + this.getClass().getName() + " not supported");
    }

    public LossReduce getLossReduce() {
        return this.lossReduce;
    }

    public void setLossReduce(LossReduce lossReduce) {
        this.lossReduce = lossReduce;
    }
}

