/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.shape.Concat;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Split
extends DynamicCustomOp {
    private int numSplit;
    private int splitDim;

    public Split() {
    }

    public Split(SameDiff sameDiff, SDVariable input, int numSplit, int splitDim) {
        super(null, sameDiff, new SDVariable[]{input});
        this.numSplit = numSplit;
        this.splitDim = splitDim;
        this.addIArgument(numSplit, splitDim);
    }

    public Split(@NonNull INDArray in, INDArray out) {
        super(null, new INDArray[]{in}, Split.wrapOrNull(out), null, (List<Integer>)null);
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
    }

    public Split(INDArray input, int numSplit, int splitDim) {
        super(null, input, null, Collections.emptyList(), new int[0]);
        this.addIArgument(numSplit, splitDim);
        this.numSplit = numSplit;
        this.splitDim = splitDim;
    }

    public Split(SameDiff sd, SDVariable input, SDVariable numSplit, int splitDim) {
        super(sd, new SDVariable[]{input, numSplit});
        this.addIArgument(splitDim);
    }

    public Split(INDArray input, INDArray numSplit, int splitDim) {
        super(new INDArray[]{input, numSplit}, null);
        this.addIArgument(splitDim);
    }

    @Override
    public String opName() {
        return "split";
    }

    @Override
    public String tensorflowName() {
        return "Split";
    }

    @Override
    public void configureFromArguments() {
        super.configureFromArguments();
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("numSplit", this.numSplit);
        ret.put("splitDim", this.splitDim);
        return ret;
    }

    @Override
    public void setPropertiesForFunction(Map<String, Object> properties) {
        if (properties.containsKey("splitDim")) {
            Integer splitDim = this.getIntValueFromProperty("splitDim", properties);
            this.splitDim = splitDim;
        }
        if (properties.containsKey("numSplit")) {
            Integer numSplit = this.getIntValueFromProperty("numSplit", properties);
            this.numSplit = numSplit;
        }
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        int numSplits;
        this.numSplit = numSplits = (int)attributesForNode.get("num_split").getI();
        this.addIArgument(numSplits);
        INDArray splitDim = TFGraphMapper.getArrayFrom(TFGraphMapper.getNodeWithNameFromGraph(graph, nodeDef.getInput(0)), graph);
        if (splitDim != null) {
            this.splitDim = splitDim.getInt(0);
            this.addIArgument(splitDim.getInt(0));
        }
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping splitDim = PropertyMapping.builder().tfInputPosition(0).propertyNames(new String[]{"splitDim"}).build();
        PropertyMapping numSplit = PropertyMapping.builder().tfAttrName("num_split").propertyNames(new String[]{"numSplit"}).build();
        map.put("numSplit", numSplit);
        map.put("splitDim", splitDim);
        ret.put(this.tensorflowName(), map);
        return ret;
    }

    @Override
    public int getNumOutputs() {
        return this.numSplit;
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState(dataTypes != null && !dataTypes.isEmpty(), "No datatypes were provided for %s: %s", this.getClass(), dataTypes);
        DataType dt = dataTypes.size() == 1 ? dataTypes.get(0) : (dataTypes.get(0).isIntType() ? dataTypes.get(1) : dataTypes.get(0));
        ArrayList<DataType> out = new ArrayList<DataType>(this.numSplit);
        for (int i = 0; i < this.numSplit; ++i) {
            out.add(dt);
        }
        return out;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return Arrays.asList(new Concat(this.sameDiff, this.splitDim, f1.toArray(new SDVariable[f1.size()])).outputVariables());
    }
}

