/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.shade.guava.primitives.Ints;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Squeeze
extends DynamicCustomOp {
    private int[] squeezeDims;

    public Squeeze() {
    }

    public Squeeze(SameDiff sameDiff, SDVariable arg, int squeezeDims) {
        this(sameDiff, arg, new int[]{squeezeDims});
    }

    public Squeeze(SameDiff sameDiff, SDVariable arg, int[] squeezeDims) {
        super(null, sameDiff, new SDVariable[]{arg});
        this.squeezeDims = squeezeDims;
        this.addIArgument(squeezeDims);
    }

    public Squeeze(INDArray x, int axis) {
        this.addInputArgument(x);
        this.addIArgument(axis);
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        nodeDef.getAttrMap().get("squeeze_dims");
        List<Long> dimList = attributesForNode.get("squeeze_dims").getList().getIList();
        this.squeezeDims = new int[dimList.size()];
        for (int i = 0; i < dimList.size(); ++i) {
            this.squeezeDims[i] = dimList.get(i).intValue();
        }
        this.addIArgument(this.squeezeDims);
    }

    @Override
    public String opName() {
        return "squeeze";
    }

    @Override
    public String tensorflowName() {
        return "Squeeze";
    }

    @Override
    public void configureFromArguments() {
        if (!this.iArguments.isEmpty()) {
            this.squeezeDims = Ints.toArray(this.iArguments);
        }
    }

    @Override
    public void setPropertiesForFunction(Map<String, Object> properties) {
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        if (this.squeezeDims == null) {
            throw new IllegalStateException("Cannot do Squeeze backprop with no dimensions");
        }
        SDVariable ret = i_v.get(0);
        for (int d : this.squeezeDims) {
            ret = this.sameDiff.expandDims(ret, d);
        }
        return Arrays.asList(ret);
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState(!dataTypes.isEmpty(), "Expected list with at least 1 datatype for %s, got %s", this.getClass(), dataTypes);
        return Arrays.asList(dataTypes.get(0));
    }
}

