/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import onnx.Onnx;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.descriptors.properties.AttributeAdapter;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.descriptors.properties.adapters.BooleanAdapter;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.reduce.bp.CumProdBp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class CumProd
extends DynamicCustomOp {
    protected boolean exclusive;
    protected boolean reverse;
    protected int[] jaxis;

    public CumProd() {
        this.exclusive = false;
        this.reverse = false;
        this.jaxis = new int[0];
    }

    public CumProd(SameDiff sameDiff, SDVariable x, int ... axis) {
        this(sameDiff, x, false, false, axis);
    }

    public CumProd(SameDiff sameDiff, SDVariable x, boolean exclusive, boolean reverse2, int ... axis) {
        super(null, sameDiff, new SDVariable[]{x});
        this.exclusive = false;
        this.reverse = false;
        this.jaxis = new int[0];
        this.sameDiff = sameDiff;
        this.exclusive = exclusive;
        this.reverse = reverse2;
        this.jaxis = axis;
        this.tArguments.clear();
        this.iArguments.clear();
        this.addArgs();
    }

    public CumProd(INDArray in, INDArray result, boolean exclusive, boolean reverse2, int ... axis) {
        INDArray[] iNDArrayArray;
        INDArray[] iNDArrayArray2 = new INDArray[]{in};
        if (result != null) {
            INDArray[] iNDArrayArray3 = new INDArray[1];
            iNDArrayArray = iNDArrayArray3;
            iNDArrayArray3[0] = result;
        } else {
            iNDArrayArray = null;
        }
        super(null, iNDArrayArray2, iNDArrayArray, null, (List<Integer>)null);
        this.exclusive = false;
        this.reverse = false;
        this.jaxis = new int[0];
        this.exclusive = exclusive;
        this.reverse = reverse2;
        this.jaxis = axis;
        this.tArguments.clear();
        this.iArguments.clear();
        this.addArgs();
    }

    public CumProd(INDArray in, boolean exclusive, boolean reverse2, int ... axis) {
        this(in, null, exclusive, reverse2, axis);
    }

    @Override
    public String opName() {
        return "cumprod";
    }

    @Override
    public String tensorflowName() {
        return "Cumprod";
    }

    @Override
    public Map<String, Map<String, AttributeAdapter>> attributeAdaptersForFunction() {
        HashMap<String, Map<String, AttributeAdapter>> ret = new HashMap<String, Map<String, AttributeAdapter>>();
        LinkedHashMap<String, BooleanAdapter> tfMappings = new LinkedHashMap<String, BooleanAdapter>();
        tfMappings.put("exclusive", new BooleanAdapter());
        tfMappings.put("reverse", new BooleanAdapter());
        ret.put(this.tensorflowName(), tfMappings);
        return ret;
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping exclusiveMapper = PropertyMapping.builder().tfAttrName("exclusive").propertyNames(new String[]{"exclusive"}).build();
        PropertyMapping reverseMapper = PropertyMapping.builder().tfAttrName("reverse").propertyNames(new String[]{"reverse"}).build();
        map.put("exclusive", exclusiveMapper);
        map.put("reverse", reverseMapper);
        ret.put(this.tensorflowName(), map);
        return ret;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        this.addArgs();
    }

    protected void addArgs() {
        this.addIArgument(this.exclusive ? 1 : 0, this.reverse ? 1 : 0);
        if (this.jaxis != null) {
            for (int a : this.jaxis) {
                this.addIArgument(a);
            }
        }
    }

    @Override
    public void initFromOnnx(Onnx.NodeProto node, SameDiff initWith, Map<String, Onnx.AttributeProto> attributesForNode, Onnx.GraphProto graph) {
        super.initFromOnnx(node, initWith, attributesForNode, graph);
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        return new CumProdBp(this.sameDiff, this.arg(0), grad.get(0), this.exclusive, this.reverse, this.jaxis).outputs();
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState(dataTypes != null && (dataTypes.size() == 1 || dataTypes.size() == 2), "Expected 1 or 2 input datatype for %s, got %s", this.getClass(), dataTypes);
        return Collections.singletonList(dataTypes.get(0));
    }
}

