/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class DynamicStitch
extends DynamicCustomOp {
    private int numPartitions;
    private SDVariable[] indices;
    private String[] indexNames;

    public DynamicStitch() {
    }

    public DynamicStitch(SameDiff sameDiff, SDVariable[] indices, SDVariable[] inputs) {
        super(null, sameDiff, (SDVariable[])ArrayUtils.addAll((Object[])indices, (Object[])inputs), false);
        this.indices = indices;
        this.numPartitions = inputs.length;
    }

    public DynamicStitch(@NonNull INDArray[] indices, @NonNull INDArray[] inputs) {
        super((INDArray[])ArrayUtils.addAll((Object[])indices, (Object[])inputs), null);
        if (indices == null) {
            throw new NullPointerException("indices is marked non-null but is null");
        }
        if (inputs == null) {
            throw new NullPointerException("inputs is marked non-null but is null");
        }
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        SDVariable gradient = i_v.get(0);
        SDVariable[] partitionData = new SDVariable[this.indices.length];
        for (int i = 0; i < this.indices.length; ++i) {
            partitionData[i] = this.sameDiff.onesLike(this.indices[i]).mul(i);
        }
        SDVariable partitions = this.sameDiff.dynamicStitch(this.indices, partitionData);
        SDVariable[] partition = this.sameDiff.dynamicPartition(gradient, partitions, this.numPartitions);
        ArrayList<SDVariable> ret = new ArrayList<SDVariable>();
        for (SDVariable i : this.indices) {
            ret.add(this.sameDiff.zerosLike(i));
        }
        Collections.addAll(ret, partition);
        return ret;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        this.numPartitions = (int)attributesForNode.get("N").getI();
    }

    @Override
    public void configureFromArguments() {
        super.configureFromArguments();
    }

    @Override
    public void setPropertiesForFunction(Map<String, Object> properties) {
        if (properties.containsKey("indices")) {
            if (properties.get("indices") instanceof String) {
                this.indexNames = new String[1];
                this.indexNames[0] = properties.get("indices").toString();
            } else if (properties.get("indices") instanceof String[]) {
                String[] indicesGet = (String[])properties.get("indices");
                this.indexNames = indicesGet;
            }
        }
        if (properties.containsKey("numPartitions")) {
            Integer numPartitions = (Integer)properties.get("numPartitions");
            this.numPartitions = numPartitions;
        }
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        Map<String, Object> base = super.propertiesForFunction();
        base.put("numPartitions", this.numPartitions);
        base.put("indices", this.indices);
        return base;
    }

    @Override
    public void configureWithSameDiff(SameDiff sameDiff) {
        if (this.indexNames != null && this.indices == null) {
            this.indices = new SDVariable[this.indexNames.length];
            for (int i = 0; i < this.indices.length; ++i) {
                this.indices[i] = sameDiff.getVariable(this.indexNames[i]);
            }
        }
    }

    @Override
    public String opName() {
        return "dynamic_stitch";
    }

    @Override
    public String[] tensorflowNames() {
        return new String[]{"DynamicStitch", "ParallelDynamicStitch"};
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx name found for shape " + this.opName());
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState(dataTypes != null && dataTypes.size() == 2 * this.numPartitions, "Expected %s input datatypes for %s partitions for %s, got %s", (Object)(2 * this.numPartitions), (Object)this.numPartitions, this.getClass(), dataTypes);
        DataType inputType = dataTypes.get(dataTypes.size() - 1);
        return Collections.singletonList(inputType);
    }
}

