/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import onnx.Onnx;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.descriptors.properties.adapters.DataTypeAdapter;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOpDescriptor;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Fill
extends DynamicCustomOp {
    private double value;
    private DataType dtype;

    public Fill() {
    }

    public Fill(SameDiff sameDiff, SDVariable shape, DataType dtype, double value) {
        super(null, sameDiff, new SDVariable[]{shape}, false);
        this.value = value;
        this.dtype = dtype;
        this.addArgs();
    }

    public Fill(INDArray shape, DataType dtype, double value) {
        super(new INDArray[]{shape, Nd4j.scalar(dtype, value)}, null);
        this.value = value;
        this.dtype = dtype;
    }

    public Fill(INDArray shape, INDArray result, double value) {
        super(null, shape, result, Collections.singletonList(value), null);
        this.value = value;
    }

    public Fill(INDArray shape, INDArray value, INDArray result) {
        super(null, new INDArray[]{shape, value}, new INDArray[]{result});
    }

    protected void addArgs() {
        this.addTArgument(this.value);
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        org.tensorflow.framework.DataType dt = attributesForNode.get("T").getType();
        this.dtype = DataTypeAdapter.dtypeConv(dt);
    }

    @Override
    public void initFromOnnx(Onnx.NodeProto node, SameDiff initWith, Map<String, Onnx.AttributeProto> attributesForNode, Onnx.GraphProto graph) {
        super.initFromOnnx(node, initWith, attributesForNode, graph);
    }

    @Override
    public void assertValidForExecution() {
        CustomOpDescriptor descriptor = this.getDescriptor();
        if (descriptor.getNumInputs() > 0 && this.numInputArguments() > 2 || this.numInputArguments() < 1) {
            throw new ND4JIllegalStateException("Op failure for " + this.opName() + " Number of inputs is invalid for execution. Specified " + this.numInputArguments() + " but should be " + descriptor.getNumInputs());
        }
        if (descriptor.getNumOutputs() > 0 && this.numOutputArguments() != descriptor.getNumOutputs()) {
            throw new ND4JIllegalStateException("Op failure for " + this.opName() + " Number of outputs is invalid for execution. Specified " + this.numOutputArguments() + " but should be " + descriptor.getNumInputs());
        }
        if (descriptor.getNumIArgs() >= 0 && this.numIArguments() != descriptor.getNumIArgs()) {
            throw new ND4JIllegalStateException("Op failure for " + this.opName() + " Number of integer arguments is invalid for execution. Specified " + this.numIArguments() + " but should be " + descriptor.getNumIArgs());
        }
        if (descriptor.getNumTArgs() >= 0 && this.numTArguments() < 1) {
            throw new ND4JIllegalStateException("Op failure for " + this.opName() + " Number of inputs is invalid for execution. Specified " + this.numTArguments() + " but should be " + descriptor.getNumTArgs());
        }
    }

    @Override
    public String opName() {
        return "fill";
    }

    @Override
    public String onnxName() {
        return "ConstantFill";
    }

    @Override
    public String tensorflowName() {
        return "Fill";
    }

    @Override
    public Op.Type opType() {
        return Op.Type.CUSTOM;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> gradients) {
        return Collections.singletonList(this.sameDiff.zerosLike(this.arg()));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        if (!this.dArguments.isEmpty()) {
            return Collections.singletonList(this.dArguments.get(0));
        }
        Preconditions.checkState(dataTypes != null && (dataTypes.size() == 1 || dataTypes.size() == 2), "Expected 1 or 2 input datatypes for %s, got %s", this.getClass(), dataTypes);
        Preconditions.checkNotNull((Object)this.dtype, "Output datatype was null (not set)");
        return Collections.singletonList(this.dtype);
    }
}

