/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.LogSoftMaxDerivative;
import org.nd4j.linalg.factory.Nd4j;

public class LogSoftMax
extends DynamicCustomOp {
    private Integer dimension = null;

    public LogSoftMax(SameDiff sameDiff, SDVariable i_v) {
        super(sameDiff, i_v);
    }

    public LogSoftMax() {
    }

    public LogSoftMax(INDArray x, INDArray z) {
        super(null, x, z, null, null);
    }

    public LogSoftMax(INDArray x) {
        this(x, x);
    }

    public LogSoftMax(INDArray x, int dimension) {
        this(x, null);
        this.dimension = dimension;
    }

    public LogSoftMax(SameDiff sameDiff, SDVariable i_v, int dimension) {
        this(sameDiff, i_v);
        this.dimension = dimension;
        this.addIArgument(dimension);
    }

    @Override
    public String opName() {
        return "log_softmax";
    }

    @Override
    public String tensorflowName() {
        return "LogSoftmax";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        if (this.dimension == null) {
            return new LogSoftMaxDerivative(this.sameDiff, this.arg(), i_v.get(0)).outputs();
        }
        return new LogSoftMaxDerivative(this.sameDiff, this.arg(), i_v.get(0), this.dimension).outputs();
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inTypes) {
        Preconditions.checkState(inTypes != null && inTypes.size() == 1, "Expected 1 input datatype for %s, got %s", this.getClass(), inTypes);
        if (inTypes.get(0).isFPType()) {
            return Collections.singletonList(inTypes.get(0));
        }
        return Collections.singletonList(Nd4j.defaultFloatingPointType());
    }
}

