/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.transforms.custom.ReverseBp;
import org.nd4j.shade.guava.primitives.Ints;

public class Reverse
extends DynamicCustomOp {
    public Reverse(@NonNull SameDiff sameDiff, @NonNull SDVariable i_v, int ... dimensions) {
        super(sameDiff, new SDVariable[]{i_v});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (i_v == null) {
            throw new NullPointerException("i_v is marked non-null but is null");
        }
        if (dimensions == null) {
            throw new NullPointerException("dimensions is marked non-null but is null");
        }
        this.dimensions = dimensions;
        this.addIArgument(dimensions);
    }

    public Reverse() {
    }

    public Reverse(INDArray x) {
        this(x, x);
        this.inPlace = true;
    }

    public Reverse(INDArray x, int ... axis) {
        super(new INDArray[]{x}, new INDArray[0]);
        this.inPlace = false;
        this.dimensions = axis;
        this.addIArgument(axis);
    }

    public Reverse(INDArray x, INDArray z, int ... axis) {
        super(new INDArray[]{x}, new INDArray[]{z});
        this.inPlace = false;
        this.dimensions = axis;
        this.addIArgument(axis);
    }

    public Reverse(INDArray x, INDArray z) {
        super(new INDArray[]{x}, new INDArray[]{z});
        this.dimensions = new int[x.rank()];
        for (int i = 0; i < this.dimensions.length; ++i) {
            this.dimensions[i] = i;
        }
        this.addIArgument(this.dimensions);
    }

    @Override
    public String opName() {
        return "reverse";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        return "Reverse";
    }

    @Override
    public void configureFromArguments() {
        if (!this.iArguments.isEmpty()) {
            this.dimensions = Ints.toArray(this.iArguments);
        }
    }

    @Override
    public void setPropertiesForFunction(Map<String, Object> properties) {
        super.setPropertiesForFunction(properties);
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return new ReverseBp(this.sameDiff, this.arg(0), f1.get(0), this.dimensions).outputs();
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState(dataTypes != null && (dataTypes.size() == 1 || dataTypes.size() == 2), "Expected 1 so 2 input datatype for %s, got %s", this.getClass(), dataTypes);
        return Collections.singletonList(dataTypes.get(0));
    }
}

