/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.custom;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.descriptors.properties.adapters.DataTypeAdapter;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class RandomPoisson
extends DynamicCustomOp {
    private DataType outputDataType = DataType.FLOAT;

    public RandomPoisson(@NonNull INDArray shape, @NonNull INDArray rate, int ... seeds) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        if (rate == null) {
            throw new NullPointerException("rate is marked non-null but is null");
        }
        this.addInputArgument(shape, rate);
        this.addIArgument(seeds);
    }

    public RandomPoisson(@NonNull INDArray shape, @NonNull INDArray rate) {
        this(shape, rate, 0, 0);
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        if (rate == null) {
            throw new NullPointerException("rate is marked non-null but is null");
        }
    }

    public RandomPoisson(@NonNull SameDiff sameDiff, @NonNull SDVariable shape, @NonNull SDVariable rate, int ... seeds) {
        super(null, sameDiff, new SDVariable[]{shape, rate});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        if (rate == null) {
            throw new NullPointerException("rate is marked non-null but is null");
        }
        this.addIArgument(seeds);
    }

    @Override
    public String opName() {
        return "random_poisson";
    }

    @Override
    public String[] tensorflowNames() {
        return new String[]{"RandomPoisson", "RandomPoissonV2"};
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        if (attributesForNode.containsKey("dtype")) {
            this.outputDataType = DataTypeAdapter.dtypeConv(attributesForNode.get("dtype").getType());
        }
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState(inputDataTypes.size() == 2, "Expected exactly 2 input datatypes for %s, got %s", this.getClass(), (Object)inputDataTypes.size());
        if (!this.dArguments.isEmpty()) {
            return Arrays.asList((DataType)((Object)this.dArguments.get(0)));
        }
        return Collections.singletonList(this.outputDataType);
    }

    public RandomPoisson() {
    }
}

