/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.api.ops.random.BaseRandomOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.factory.Nd4j;

public class GaussianDistribution
extends BaseRandomOp {
    private double mean;
    private double stddev;

    public GaussianDistribution(SameDiff sd, double mean, double stddev, long[] shape) {
        super(sd, shape);
        this.mean = mean;
        this.stddev = stddev;
        this.extraArgs = new Object[]{this.mean, this.stddev};
    }

    public GaussianDistribution(SameDiff sd, double mean, double stddev, DataType dataType, long[] shape) {
        super(sd, shape);
        this.mean = mean;
        this.stddev = stddev;
        this.dataType = dataType;
        this.extraArgs = new Object[]{this.mean, this.stddev};
    }

    public GaussianDistribution() {
    }

    public GaussianDistribution(double mean, double stddev, DataType datatype, long ... shape) {
        this(Nd4j.createUninitialized(datatype, shape), mean, stddev);
    }

    public GaussianDistribution(@NonNull INDArray z, double mean, double stddev) {
        super(z, z, z);
        if (z == null) {
            throw new NullPointerException("z is marked non-null but is null");
        }
        this.mean = mean;
        this.stddev = stddev;
        this.extraArgs = new Object[]{this.mean, this.stddev};
    }

    public GaussianDistribution(@NonNull INDArray z, @NonNull INDArray means, double stddev) {
        if (z == null) {
            throw new NullPointerException("z is marked non-null but is null");
        }
        if (means == null) {
            throw new NullPointerException("means is marked non-null but is null");
        }
        if (z.length() != means.length()) {
            throw new IllegalStateException("Result length should be equal to provided Means length");
        }
        if (means.elementWiseStride() < 1) {
            throw new IllegalStateException("Means array can't have negative EWS");
        }
        this.mean = 0.0;
        this.stddev = stddev;
        this.z = z;
        this.extraArgs = new Object[]{this.mean, this.stddev};
    }

    public GaussianDistribution(@NonNull INDArray z) {
        this(z, 0.0, 1.0);
        if (z == null) {
            throw new NullPointerException("z is marked non-null but is null");
        }
    }

    public GaussianDistribution(@NonNull INDArray z, double stddev) {
        this(z, 0.0, stddev);
        if (z == null) {
            throw new NullPointerException("z is marked non-null but is null");
        }
    }

    @Override
    public int opNum() {
        return 6;
    }

    @Override
    public String opName() {
        return "distribution_gaussian";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return Collections.emptyList();
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape(OpContext oc) {
        return this.calculateOutputShape();
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        LongShapeDescriptor longShapeDescriptor = LongShapeDescriptor.fromShape(this.shape, this.dataType);
        return Arrays.asList(longShapeDescriptor);
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState(inputDataTypes == null || inputDataTypes.isEmpty(), "Expected no input datatypes (no args) for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(this.dataType);
    }

    @Override
    public boolean isTripleArgRngOp() {
        return true;
    }
}

