/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu.ops;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.NonNull;
import org.bytedeco.javacpp.BooleanPointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.indexer.LongIndexer;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.serde.FlatBuffersMapper;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.primitives.AtomicBoolean;
import org.nd4j.common.primitives.Optional;
import org.nd4j.common.primitives.Pair;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.MemcpyDirection;
import org.nd4j.linalg.api.memory.pointers.PagedPointer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ndarray.INDArrayStatistics;
import org.nd4j.linalg.api.ops.BaseReduceBoolOp;
import org.nd4j.linalg.api.ops.BaseReduceOp;
import org.nd4j.linalg.api.ops.BroadcastOp;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.CustomOpDescriptor;
import org.nd4j.linalg.api.ops.IndexAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.api.ops.RandomOp;
import org.nd4j.linalg.api.ops.ReduceOp;
import org.nd4j.linalg.api.ops.ScalarOp;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.aggregates.Aggregate;
import org.nd4j.linalg.api.ops.aggregates.Batch;
import org.nd4j.linalg.api.ops.executioner.DefaultOpExecutioner;
import org.nd4j.linalg.api.ops.executioner.OpExecutioner;
import org.nd4j.linalg.api.ops.executioner.OpStatus;
import org.nd4j.linalg.api.ops.impl.scatter.ScatterUpdate;
import org.nd4j.linalg.api.ops.impl.summarystats.Variance;
import org.nd4j.linalg.api.ops.performance.PerformanceTracker;
import org.nd4j.linalg.api.ops.random.BaseRandomOp;
import org.nd4j.linalg.api.rng.Random;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.api.shape.TadPack;
import org.nd4j.linalg.api.shape.options.ArrayOptionsHelper;
import org.nd4j.linalg.api.shape.options.ArrayType;
import org.nd4j.linalg.cache.ConstantHandler;
import org.nd4j.linalg.cache.TADManager;
import org.nd4j.linalg.cpu.nativecpu.CpuTADManager;
import org.nd4j.linalg.cpu.nativecpu.bindings.Nd4jCpu;
import org.nd4j.linalg.cpu.nativecpu.buffer.BaseCpuDataBuffer;
import org.nd4j.linalg.cpu.nativecpu.buffer.LongBuffer;
import org.nd4j.linalg.cpu.nativecpu.buffer.Utf8Buffer;
import org.nd4j.linalg.cpu.nativecpu.ops.CpuOpContext;
import org.nd4j.linalg.cpu.nativecpu.rng.CpuNativeRandom;
import org.nd4j.linalg.exception.ND4JIllegalArgumentException;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.exception.ND4JOpProfilerException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.nativeblas.LongPointerWrapper;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.nd4j.nativeblas.OpaqueConstantShapeBuffer;
import org.nd4j.nativeblas.OpaqueDataBuffer;
import org.nd4j.nativeblas.OpaqueShapeList;
import org.nd4j.nativeblas.OpaqueTadPack;
import org.nd4j.nativeblas.OpaqueVariable;
import org.nd4j.nativeblas.OpaqueVariablesSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeOpExecutioner
extends DefaultOpExecutioner {
    private static final Logger log = LoggerFactory.getLogger(NativeOpExecutioner.class);
    private NativeOps loop = NativeOpsHolder.getInstance().getDeviceNativeOps();
    private ConstantHandler constantHandler = Nd4j.getConstantHandler();
    private CpuTADManager tadManager = new CpuTADManager();
    private ThreadLocal<Map<Integer, PointerPointer>> inputShapes = new ThreadLocal();
    private ThreadLocal<Map<Integer, PointerPointer>> inputBuffers = new ThreadLocal();
    private ThreadLocal<Map<Integer, PointerPointer>> outputShapes = new ThreadLocal();
    private ThreadLocal<Map<Integer, PointerPointer>> outputBuffers = new ThreadLocal();
    private ThreadLocal<Map<Integer, LongPointer>> iArgsPointer = new ThreadLocal();
    private ThreadLocal<Map<Integer, DoublePointer>> tArgsPointer = new ThreadLocal();
    private ThreadLocal<Map<Integer, BooleanPointer>> bArgsPointer = new ThreadLocal();
    private ThreadLocal<Map<Integer, ShortPointer>> halfArgsPointer = new ThreadLocal();
    protected Map<String, CustomOpDescriptor> customOps = null;
    protected ThreadLocal<PointerPointer> extraz = new ThreadLocal();
    protected AtomicBoolean experimentalMode = new AtomicBoolean(false);
    protected Map<String, Boolean> mklOverrides = new HashMap<String, Boolean>();
    private ThreadLocal<Map<Integer, Pointer>> batchPointers = new ThreadLocal();
    private ThreadLocal<Map<Integer, AggregateMemoryBlock>> memoryBlocks = new ThreadLocal();

    public NativeOpExecutioner() {
        this.tadManager.init(this.loop, this.constantHandler);
        this.experimentalMode.set(this.loop.isExperimentalEnabled());
        String env = System.getenv("ND4J_MKL_FALLBACK");
        if (env != null) {
            if (env.equalsIgnoreCase("true")) {
                Nd4jCpu.Environment.getInstance().setUseONEDNN(false);
            } else {
                String[] split2;
                for (String name : split2 = env.toLowerCase().split(",")) {
                    this.mklOverrides.put(name, new Boolean(true));
                }
            }
        }
    }

    @Override
    public INDArray exec(Op op) {
        return this.exec(op, null);
    }

    @Override
    public INDArray exec(Op op, OpContext opContext) {
        DifferentialFunction differentialFunction = (DifferentialFunction)((Object)op);
        String oldName = differentialFunction.getOwnName();
        this.checkForCompression(op);
        if (op instanceof ScalarOp) {
            ScalarOp s = (ScalarOp)op;
            this.exec(s, opContext);
        } else if (op instanceof TransformOp) {
            TransformOp t = (TransformOp)op;
            this.exec(t, opContext);
        } else if (op instanceof ReduceOp) {
            ReduceOp ac = (ReduceOp)op;
            this.exec(ac, opContext);
        } else if (op instanceof IndexAccumulation) {
            IndexAccumulation iac = (IndexAccumulation)op;
            this.exec(iac, opContext);
        } else if (op instanceof BroadcastOp) {
            BroadcastOp broadcastOp = (BroadcastOp)op;
            this.exec(broadcastOp, opContext);
        } else if (op instanceof RandomOp) {
            RandomOp rngOp = (RandomOp)op;
            this.exec(rngOp, opContext, Nd4j.getRandom());
        }
        return op.z();
    }

    @Override
    public INDArray exec(IndexAccumulation op) {
        return this.exec(op, null);
    }

    public INDArray exec(IndexAccumulation op, OpContext oc) {
        this.checkForCompression(op);
        INDArray x = this.getX(op, oc);
        INDArray z = this.getZ(op, oc);
        if (this.extraz.get() == null) {
            this.extraz.set(new PointerPointer(32L));
        }
        int[] dimension = Shape.normalizeAxis(x.rank(), op.dimensions().toIntVector());
        if (x.isEmpty()) {
            for (int d : dimension) {
                Preconditions.checkArgument(x.shape()[d] != 0L, "IndexReduce can't be issued along axis with 0 in shape");
            }
        }
        boolean keepDims = op.isKeepDims();
        long[] retShape = Shape.reductionShape(x, dimension, true, keepDims);
        if (z == null || x == z) {
            INDArray ret = Nd4j.createUninitialized(DataType.LONG, retShape);
            this.setZ(ret, op, oc);
            z = ret;
        } else if (!Arrays.equals(retShape, z.shape())) {
            throw new IllegalStateException("Z array shape does not match expected return type for op " + op + ": expected shape " + Arrays.toString(retShape) + ", z.shape()=" + Arrays.toString(z.shape()));
        }
        op.validateDataTypes();
        Pointer dimensionAddress = this.constantHandler.getConstantBuffer(dimension, DataType.INT).addressPointer();
        Pair<DataBuffer, DataBuffer> tadBuffers = this.tadManager.getTADOnlyShapeInfo(x, dimension);
        Pointer hostTadShapeInfo = tadBuffers.getFirst().addressPointer();
        DataBuffer offsets = tadBuffers.getSecond();
        Pointer hostTadOffsets = offsets == null ? null : offsets.addressPointer();
        PointerPointer dummy = this.extraz.get().put(new Pointer[]{hostTadShapeInfo, hostTadOffsets});
        long st = this.profilingConfigurableHookIn(op, tadBuffers.getFirst());
        OpaqueDataBuffer xb = ((BaseCpuDataBuffer)x.data()).getOpaqueDataBuffer();
        OpaqueDataBuffer zb = ((BaseCpuDataBuffer)z.data()).getOpaqueDataBuffer();
        if (z.isScalar()) {
            this.loop.execIndexReduceScalar(dummy, op.opNum(), xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, this.getPointerForExtraArgs(op, x.dataType()), zb, (LongPointer)z.shapeInfoDataBuffer().addressPointer(), null);
        } else {
            this.loop.execIndexReduce(dummy, op.opNum(), xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, this.getPointerForExtraArgs(op, x.dataType()), zb, (LongPointer)z.shapeInfoDataBuffer().addressPointer(), null, ((BaseCpuDataBuffer)op.dimensions().data()).getOpaqueDataBuffer(), (LongPointer)op.dimensions().shapeInfoDataBuffer().addressPointer(), null);
        }
        if (this.loop.lastErrorCode() != 0) {
            throw new RuntimeException(this.loop.lastErrorMessage());
        }
        this.profilingConfigurableHookOut(op, oc, st);
        return this.getZ(op, oc);
    }

    @Override
    public INDArray exec(Variance op) {
        return this.exec((ReduceOp)op);
    }

    @Override
    public INDArray exec(ReduceOp op) {
        return this.exec(op, null);
    }

    public INDArray exec(ReduceOp op, OpContext oc) {
        block50: {
            OpaqueDataBuffer zb;
            OpaqueDataBuffer xb;
            INDArray z;
            INDArray x;
            block49: {
                INDArray ret;
                block48: {
                    Pair<DataBuffer, DataBuffer> yTadBuffers;
                    Pair<DataBuffer, Object> tadBuffers;
                    int[] dimension;
                    INDArray y;
                    block47: {
                        x = this.getX(op, oc);
                        y = this.getY(op, oc);
                        z = this.getZ(op, oc);
                        Preconditions.checkNotNull((Object)x, "Op.x() cannot be null: Was null for op %s", (Object)op);
                        op.validateDataTypes(oc);
                        if (op instanceof BaseReduceOp && ((BaseReduceOp)op).isEmptyReduce()) {
                            if (z != null) {
                                if (!x.isScalar() && !z.isScalar()) {
                                    Preconditions.checkState(x.equalShapes(z), "For empty reductions, result (z) array must have same shape as x shape. Got: x=%ndShape, z=%ndShape", (Object)x, (Object)z);
                                }
                                z.assign(x);
                                return z;
                            }
                            this.setZ(x.dup(), op, oc);
                            return z;
                        }
                        dimension = Shape.normalizeAxis(x.rank(), op.dimensions() != null ? op.dimensions().toIntVector() : null);
                        if (op instanceof BaseReduceBoolOp && x.isEmpty() && (dimension == null || dimension.length == 1 && dimension[0] == Integer.MAX_VALUE)) {
                            if (z == null) {
                                this.setZ(Nd4j.scalar(((BaseReduceBoolOp)op).emptyValue()), op, oc);
                            } else {
                                z.assign(((BaseReduceBoolOp)op).emptyValue());
                            }
                            return z;
                        }
                        if (this.extraz.get() == null) {
                            this.extraz.set(new PointerPointer(32L));
                        }
                        boolean keepDims = op.isKeepDims();
                        long[] retShape = Shape.reductionShape(x, dimension, true, keepDims);
                        if (x.isVector() && x.length() == (long)ArrayUtil.prod(retShape) && ArrayUtil.prodLong(retShape) > 1L && y == null) {
                            return op.noOp();
                        }
                        if (z == null || z == x) {
                            if (op.isComplexAccumulation()) {
                                long xT = x.tensorsAlongDimension(dimension);
                                long yT = y.tensorsAlongDimension(dimension);
                                ret = Nd4j.create(op.resultType(), xT, yT);
                            } else {
                                if (y != null) {
                                    long xTADSize;
                                    if (x.length() == y.length()) {
                                        if (x.tensorsAlongDimension(dimension) != y.tensorsAlongDimension(dimension)) {
                                            throw new ND4JIllegalStateException("Number of TADs along dimension don't match: (x shape = " + Arrays.toString(x.shape()) + ", y shape = " + Arrays.toString(y.shape()) + ", dimension = " + Arrays.toString(dimension) + ")");
                                        }
                                    } else if (!(op instanceof ReduceOp) && (xTADSize = x.length() / x.tensorsAlongDimension(dimension)) != y.length()) {
                                        throw new ND4JIllegalStateException("Size of TADs along dimension don't match for pairwise execution: (x TAD size = " + xTADSize + ", y size = " + y.length());
                                    }
                                }
                                DataType dt = oc != null ? op.resultType(oc) : op.resultType();
                                ret = Nd4j.create(dt, retShape);
                            }
                            this.setZ(ret, op, oc);
                            z = ret;
                        } else {
                            long shapeProduct;
                            long l = shapeProduct = retShape.length == 0 ? 1L : ArrayUtil.prodLong(retShape);
                            if (!op.isComplexAccumulation() && z.length() != shapeProduct) {
                                if (!x.isEmpty() || !op.isKeepDims()) {
                                    throw new ND4JIllegalStateException("Shape of target array for reduction [" + Arrays.toString(z.shape()) + "] doesn't match expected [" + Arrays.toString(retShape) + "]");
                                }
                            } else if (op.isComplexAccumulation()) {
                                long xT = x.tensorsAlongDimension(dimension);
                                long yT = y.tensorsAlongDimension(dimension);
                                if (z.length() != xT * yT) {
                                    throw new ND4JIllegalStateException("Shape of target array for reduction [" + Arrays.toString(z.shape()) + "] doesn't match expected [" + xT * yT + "]");
                                }
                            }
                            ret = z;
                        }
                        tadBuffers = x.isEmpty() ? Pair.makePair(x.data(), null) : this.tadManager.getTADOnlyShapeInfo(x, dimension);
                        yTadBuffers = null;
                        long st = this.profilingConfigurableHookIn(op, tadBuffers.getFirst());
                        Pointer dimensionAddress = this.constantHandler.getConstantBuffer(dimension, DataType.INT).addressPointer();
                        xb = ((BaseCpuDataBuffer)x.data()).getOpaqueDataBuffer();
                        zb = ((BaseCpuDataBuffer)z.data()).getOpaqueDataBuffer();
                        if (!(op instanceof Variance)) break block47;
                        if (ret.isScalar()) {
                            this.loop.execSummaryStatsScalar(null, op.opNum(), xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, this.getPointerForExtraArgs(op, z.dataType()), zb, (LongPointer)z.shapeInfoDataBuffer().addressPointer(), null, ((Variance)op).isBiasCorrected());
                        } else {
                            Variance var = (Variance)op;
                            try {
                                this.loop.execSummaryStatsTad(null, op.opNum(), xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, this.getPointerForExtraArgs(op, z.dataType()), zb, (LongPointer)z.shapeInfoDataBuffer().addressPointer(), null, ((BaseCpuDataBuffer)op.dimensions().data()).getOpaqueDataBuffer(), (LongPointer)op.dimensions().shapeInfoDataBuffer().addressPointer(), null, var.isBiasCorrected(), null, null);
                            }
                            catch (Throwable t) {
                                String str = this.opInfoString(op, Optional.of(dimension));
                                throw new RuntimeException("Native AccumulationOp execution (double) failed: " + str, t);
                            }
                        }
                    }
                    if (y == null || op.getOpType() != Op.Type.REDUCE3) break block48;
                    OpaqueDataBuffer yb = ((BaseCpuDataBuffer)y.data()).getOpaqueDataBuffer();
                    yTadBuffers = this.tadManager.getTADOnlyShapeInfo(y, dimension);
                    if (op.isComplexAccumulation()) {
                        try {
                            this.loop.execReduce3All(null, op.opNum(), xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, this.getPointerForExtraArgs(op, z.dataType()), yb, (LongPointer)y.shapeInfoDataBuffer().addressPointer(), null, zb, (LongPointer)z.shapeInfoDataBuffer().addressPointer(), null, ((BaseCpuDataBuffer)op.dimensions().data()).getOpaqueDataBuffer(), (LongPointer)op.dimensions().shapeInfoDataBuffer().addressPointer(), null, (LongPointer)tadBuffers.getFirst().addressPointer(), new LongPointerWrapper(((DataBuffer)tadBuffers.getSecond()).addressPointer()), (LongPointer)yTadBuffers.getFirst().addressPointer(), new LongPointerWrapper(yTadBuffers.getSecond().addressPointer()));
                        }
                        catch (Throwable t) {
                            String str = this.opInfoString(op, Optional.of(dimension));
                            throw new RuntimeException("Native AccumulationOp execution (double) failed: " + str, t);
                        }
                    } else if (ret.isScalar()) {
                        this.loop.execReduce3Scalar(null, op.opNum(), xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, this.getPointerForExtraArgs(op, z.dataType()), yb, (LongPointer)y.shapeInfoDataBuffer().addressPointer(), null, zb, (LongPointer)ret.shapeInfoDataBuffer().addressPointer(), null);
                    } else {
                        try {
                            this.loop.execReduce3Tad(null, op.opNum(), xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, this.getPointerForExtraArgs(op, z.dataType()), yb, (LongPointer)y.shapeInfoDataBuffer().addressPointer(), null, zb, (LongPointer)z.shapeInfoDataBuffer().addressPointer(), null, ((BaseCpuDataBuffer)op.dimensions().data()).getOpaqueDataBuffer(), (LongPointer)op.dimensions().shapeInfoDataBuffer().addressPointer(), null, null, null, null, null);
                        }
                        catch (Throwable t) {
                            String str = this.opInfoString(op, Optional.of(dimension));
                            throw new RuntimeException("Native AccumulationOp execution (double) failed: " + str, t);
                        }
                    }
                }
                if (!ret.isScalar()) break block49;
                switch (op.getOpType()) {
                    case REDUCE_FLOAT: {
                        this.loop.execReduceFloat(null, op.opNum(), xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, this.getPointerForExtraArgs(op, z.dataType()), zb, (LongPointer)ret.shapeInfoDataBuffer().addressPointer(), null);
                        break block50;
                    }
                    case REDUCE_BOOL: {
                        this.loop.execReduceBool(null, op.opNum(), xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, this.getPointerForExtraArgs(op, x.dataType()), zb, (LongPointer)ret.shapeInfoDataBuffer().addressPointer(), null);
                        break block50;
                    }
                    case REDUCE_SAME: {
                        this.loop.execReduceSame(null, op.opNum(), xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, this.getPointerForExtraArgs(op, x.dataType()), zb, (LongPointer)ret.shapeInfoDataBuffer().addressPointer(), null);
                        break block50;
                    }
                    case REDUCE_LONG: {
                        this.loop.execReduceLong(null, op.opNum(), xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, this.getPointerForExtraArgs(op, x.dataType()), zb, (LongPointer)ret.shapeInfoDataBuffer().addressPointer(), null);
                        break block50;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported op used in reduce: " + (Object)((Object)op.getOpType()));
                    }
                }
            }
            switch (op.getOpType()) {
                case REDUCE_FLOAT: {
                    this.loop.execReduceFloat2(null, op.opNum(), xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, this.getPointerForExtraArgs(op, z.dataType()), zb, (LongPointer)z.shapeInfoDataBuffer().addressPointer(), null, ((BaseCpuDataBuffer)op.dimensions().data()).getOpaqueDataBuffer(), (LongPointer)op.dimensions().shapeInfoDataBuffer().addressPointer(), null);
                    break;
                }
                case REDUCE_LONG: {
                    this.loop.execReduceLong2(null, op.opNum(), xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, this.getPointerForExtraArgs(op, x.dataType()), zb, (LongPointer)z.shapeInfoDataBuffer().addressPointer(), null, ((BaseCpuDataBuffer)op.dimensions().data()).getOpaqueDataBuffer(), (LongPointer)op.dimensions().shapeInfoDataBuffer().addressPointer(), null);
                    break;
                }
                case REDUCE_SAME: {
                    this.loop.execReduceSame2(null, op.opNum(), xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, this.getPointerForExtraArgs(op, z.dataType()), zb, (LongPointer)z.shapeInfoDataBuffer().addressPointer(), null, ((BaseCpuDataBuffer)op.dimensions().data()).getOpaqueDataBuffer(), (LongPointer)op.dimensions().shapeInfoDataBuffer().addressPointer(), null);
                    break;
                }
                case REDUCE_BOOL: {
                    this.loop.execReduceBool2(null, op.opNum(), xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, this.getPointerForExtraArgs(op, x.dataType()), zb, (LongPointer)z.shapeInfoDataBuffer().addressPointer(), null, ((BaseCpuDataBuffer)op.dimensions().data()).getOpaqueDataBuffer(), (LongPointer)op.dimensions().shapeInfoDataBuffer().addressPointer(), null);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported op used in reduce: " + (Object)((Object)op.getOpType()));
                }
            }
        }
        if (this.loop.lastErrorCode() != 0) {
            throw new RuntimeException(this.loop.lastErrorMessage());
        }
        return this.getZ(op, oc);
    }

    private void invokeScalarAlongDimension(ScalarOp op) {
        this.invokeScalarAlongDimension(op, null);
    }

    private void invokeScalarAlongDimension(ScalarOp op, OpContext oc) {
        INDArray x = this.getX(op, oc);
        INDArray y = this.getY(op, oc);
        INDArray z = this.getZ(op, oc);
        int[] dimension = op.dimensions().toIntVector();
        Pair<DataBuffer, DataBuffer> tadBuffers = this.tadManager.getTADOnlyShapeInfo(op.x(), dimension);
        Pointer hostTadShapeInfo = tadBuffers.getFirst().addressPointer();
        Pointer hostTadOffsets = tadBuffers.getSecond().addressPointer();
        Pointer devTadShapeInfoZ = null;
        Pointer devTadOffsetsZ = null;
        Pair<DataBuffer, DataBuffer> tadBuffersZ = this.tadManager.getTADOnlyShapeInfo(op.z(), dimension);
        devTadShapeInfoZ = tadBuffersZ.getFirst().addressPointer();
        devTadOffsetsZ = tadBuffersZ.getSecond().addressPointer();
        if (this.extraz.get() == null) {
            this.extraz.set(new PointerPointer(32L));
        }
        OpaqueDataBuffer xb = ((BaseCpuDataBuffer)x.data()).getOpaqueDataBuffer();
        OpaqueDataBuffer yb = ((BaseCpuDataBuffer)y.data()).getOpaqueDataBuffer();
        OpaqueDataBuffer zb = ((BaseCpuDataBuffer)z.data()).getOpaqueDataBuffer();
        switch (op.getOpType()) {
            case SCALAR: {
                this.loop.execScalarTad(null, op.opNum(), xb, (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, zb, (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, yb, (LongPointer)y.shapeInfoDataBuffer().addressPointer(), null, this.getPointerForExtraArgs(op, op.z().dataType()), ((BaseCpuDataBuffer)op.dimensions().data()).getOpaqueDataBuffer(), (LongPointer)op.dimensions().shapeInfoDataBuffer().addressPointer(), null, (LongPointer)hostTadShapeInfo, (LongPointer)hostTadOffsets, (LongPointer)devTadShapeInfoZ, (LongPointer)devTadOffsetsZ);
                break;
            }
            case SCALAR_BOOL: {
                this.loop.execScalarBoolTad(null, op.opNum(), xb, (LongPointer)op.x().shapeInfoDataBuffer().addressPointer(), null, zb, (LongPointer)op.z().shapeInfoDataBuffer().addressPointer(), null, yb, (LongPointer)op.y().shapeInfoDataBuffer().addressPointer(), null, this.getPointerForExtraArgs(op, op.z().dataType()), ((BaseCpuDataBuffer)op.dimensions().data()).getOpaqueDataBuffer(), (LongPointer)op.dimensions().shapeInfoDataBuffer().addressPointer(), null, (LongPointer)hostTadShapeInfo, (LongPointer)hostTadOffsets, (LongPointer)devTadShapeInfoZ, (LongPointer)devTadOffsetsZ);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (this.loop.lastErrorCode() != 0) {
            throw new RuntimeException(this.loop.lastErrorMessage());
        }
    }

    @Override
    public INDArray exec(ScalarOp op) {
        return this.exec(op, null);
    }

    public INDArray exec(ScalarOp op, OpContext oc) {
        long st = this.profilingConfigurableHookIn(op, new DataBuffer[0]);
        if (oc != null && oc.getOutputArray(0) == null || this.getZ(op, oc) == null) {
            switch (op.getOpType()) {
                case SCALAR: {
                    this.setZ(this.getX(op, oc).ulike(), op, oc);
                    break;
                }
                case SCALAR_BOOL: {
                    this.setZ(Nd4j.createUninitialized(DataType.BOOL, this.getX(op, oc).shape()), op, oc);
                    break;
                }
                default: {
                    throw new ND4JIllegalStateException("Unknown op type: [" + (Object)((Object)op.getOpType()) + "]");
                }
            }
        }
        if (op.dimensions() != null) {
            this.invokeScalarAlongDimension(op);
            return this.getZ(op, oc);
        }
        OpaqueDataBuffer x = ((BaseCpuDataBuffer)this.getX(op, oc).data()).getOpaqueDataBuffer();
        OpaqueDataBuffer scalar = ((BaseCpuDataBuffer)op.scalar().data()).getOpaqueDataBuffer();
        OpaqueDataBuffer z = ((BaseCpuDataBuffer)this.getZ(op, oc).data()).getOpaqueDataBuffer();
        switch (op.getOpType()) {
            case SCALAR: {
                this.loop.execScalar(null, op.opNum(), x, (LongPointer)this.getX(op, oc).shapeInfoDataBuffer().addressPointer(), null, z, (LongPointer)this.getZ(op, oc).shapeInfoDataBuffer().addressPointer(), null, scalar, (LongPointer)op.scalar().shapeInfoDataBuffer().addressPointer(), null, this.getPointerForExtraArgs(op, this.getZ(op, oc).dataType()));
                break;
            }
            case SCALAR_BOOL: {
                this.loop.execScalarBool(null, op.opNum(), x, (LongPointer)this.getX(op, oc).shapeInfoDataBuffer().addressPointer(), null, z, (LongPointer)this.getZ(op, oc).shapeInfoDataBuffer().addressPointer(), null, scalar, (LongPointer)op.scalar().shapeInfoDataBuffer().addressPointer(), null, this.getPointerForExtraArgs(op, this.getX(op, oc).dataType()));
                break;
            }
            default: {
                throw new ND4JIllegalStateException("Unknown op type: [" + (Object)((Object)op.getOpType()) + "]");
            }
        }
        if (this.loop.lastErrorCode() != 0) {
            throw new RuntimeException("Op " + op.opName() + " failed with message:" + this.loop.lastErrorMessage());
        }
        this.profilingConfigurableHookOut(op, oc, st);
        return this.getZ(op, oc);
    }

    private Pointer getPointerForExtraArgs(Op op, DataType type) {
        if (op.extraArgs() != null) {
            DataBuffer eadb = op.extraArgsDataBuff(type);
            if (eadb != null) {
                return eadb.addressPointer();
            }
            return null;
        }
        return null;
    }

    private void exec(TransformOp op) {
        this.exec(op, null);
    }

    private void exec(TransformOp op, OpContext oc) {
        OpaqueDataBuffer xb;
        INDArray x = this.getX(op, oc);
        INDArray y = this.getY(op, oc);
        INDArray z = this.getZ(op, oc);
        long st = 0L;
        if (this.extraz.get() == null) {
            this.extraz.set(new PointerPointer(32L));
        }
        PointerPointer dummy = this.extraz.get();
        if (op.opNum() == 31 && y != null && y.isScalar()) {
            this.setY(Nd4j.valueArrayOf(x.shape(), y.getDouble(0L)), op, oc);
        }
        if (op.opName().equalsIgnoreCase("ismax") && op.extraArgs() != null && op.extraArgs().length > 0) {
            int[] dimension = new int[((Integer)op.extraArgs()[0]).intValue()];
            for (int i = 0; i < dimension.length; ++i) {
                dimension[i] = (Integer)op.extraArgs()[i + 1];
            }
            Pair<DataBuffer, DataBuffer> tadBuffers = this.tadManager.getTADOnlyShapeInfo(op.z(), dimension);
            Pointer tad = tadBuffers.getFirst().addressPointer();
            DataBuffer offsets = tadBuffers.getSecond();
            Pointer off = offsets == null ? null : offsets.addressPointer();
            dummy.put(0L, tad);
            dummy.put(1L, off);
            st = this.profilingConfigurableHookIn(op, tadBuffers.getFirst());
        } else {
            st = this.profilingConfigurableHookIn(op, new DataBuffer[0]);
        }
        if (y != null) {
            if (z == null) {
                this.setZ(Nd4j.create(op.resultType(), x.shape()), op, oc);
                z = this.getZ(op, oc);
            }
            op.validateDataTypes(oc, this.experimentalMode.get());
            xb = ((BaseCpuDataBuffer)x.data()).getOpaqueDataBuffer();
            OpaqueDataBuffer yb = ((BaseCpuDataBuffer)y.data()).getOpaqueDataBuffer();
            OpaqueDataBuffer zb = ((BaseCpuDataBuffer)z.data()).getOpaqueDataBuffer();
            switch (op.getOpType()) {
                case TRANSFORM_ANY: 
                case TRANSFORM_FLOAT: 
                case TRANSFORM_STRICT: 
                case TRANSFORM_SAME: {
                    if (!this.experimentalMode.get()) {
                        Preconditions.checkArgument(x.dataType() == y.dataType() || y.dataType() == DataType.BOOL, "Op.X and Op.Y must have the same data type, but got %s vs. %s", (Object)x.dataType(), (Object)y.dataType());
                    }
                    this.loop.execPairwiseTransform(dummy, op.opNum(), xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, yb, (LongPointer)y.shapeInfoDataBuffer().addressPointer(), null, zb, (LongPointer)z.shapeInfoDataBuffer().addressPointer(), null, this.getPointerForExtraArgs(op, z.dataType()));
                    break;
                }
                case TRANSFORM_BOOL: {
                    this.loop.execTransformBool(dummy, op.opNum(), xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, zb, (LongPointer)z.shapeInfoDataBuffer().addressPointer(), null, this.getPointerForExtraArgs(op, x.dataType()));
                    break;
                }
                case PAIRWISE_BOOL: {
                    this.loop.execPairwiseTransformBool(dummy, op.opNum(), xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, yb, (LongPointer)y.shapeInfoDataBuffer().addressPointer(), null, zb, (LongPointer)z.shapeInfoDataBuffer().addressPointer(), null, this.getPointerForExtraArgs(op, x.dataType()));
                }
            }
        } else {
            if (z == null) {
                this.setZ(Nd4j.createUninitialized(oc != null ? op.resultType(oc) : op.resultType(), x.shape()), op, oc);
                z = this.getZ(op, oc);
            }
            op.validateDataTypes(oc, this.experimentalMode.get());
            xb = ((BaseCpuDataBuffer)x.data()).getOpaqueDataBuffer();
            OpaqueDataBuffer zb = ((BaseCpuDataBuffer)z.data()).getOpaqueDataBuffer();
            switch (op.getOpType()) {
                case TRANSFORM_FLOAT: {
                    Pointer xtraz = this.getPointerForExtraArgs(op, z.dataType());
                    this.loop.execTransformFloat(dummy, op.opNum(), xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, zb, (LongPointer)z.shapeInfoDataBuffer().addressPointer(), null, xtraz);
                    break;
                }
                case TRANSFORM_STRICT: {
                    Pointer xtraz = this.getPointerForExtraArgs(op, z.dataType());
                    this.loop.execTransformStrict(dummy, op.opNum(), xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, zb, (LongPointer)z.shapeInfoDataBuffer().addressPointer(), null, xtraz);
                    break;
                }
                case TRANSFORM_SAME: {
                    Pointer xtraz = this.getPointerForExtraArgs(op, z.dataType());
                    this.loop.execTransformSame(dummy, op.opNum(), xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, zb, (LongPointer)z.shapeInfoDataBuffer().addressPointer(), null, xtraz);
                    break;
                }
                case TRANSFORM_ANY: {
                    Pointer xtraz = this.getPointerForExtraArgs(op, x.dataType());
                    int opNum = op.opNum();
                    this.loop.execTransformAny(dummy, opNum, xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, zb, (LongPointer)z.shapeInfoDataBuffer().addressPointer(), null, xtraz);
                    break;
                }
                case TRANSFORM_BOOL: {
                    Pointer xtraz = this.getPointerForExtraArgs(op, x.dataType());
                    int opNum = op.opNum();
                    this.loop.execTransformBool(dummy, opNum, xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, zb, (LongPointer)z.shapeInfoDataBuffer().addressPointer(), null, xtraz);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown transform type: [" + (Object)((Object)op.getOpType()) + "]");
                }
            }
        }
        if (this.loop.lastErrorCode() != 0) {
            throw new RuntimeException(this.loop.lastErrorMessage());
        }
        this.profilingConfigurableHookOut(op, oc, st);
    }

    @Override
    public INDArray exec(BroadcastOp op) {
        return this.exec(op, null);
    }

    public INDArray exec(BroadcastOp op, OpContext oc) {
        INDArray x = this.getX(op, oc);
        INDArray y = this.getY(op, oc);
        INDArray z = this.getZ(op, oc);
        long st = this.profilingConfigurableHookIn(op, new DataBuffer[0]);
        op.validateDataTypes(this.experimentalMode.get());
        int[] dimension = op.dimensions().toIntVector();
        Pair<DataBuffer, DataBuffer> tadBuffers = this.tadManager.getTADOnlyShapeInfo(x, dimension);
        Pointer hostTadShapeInfo = tadBuffers.getFirst().addressPointer();
        Pointer hostTadOffsets = tadBuffers.getSecond().addressPointer();
        Pointer devTadShapeInfoZ = null;
        Pointer devTadOffsetsZ = null;
        Pair<DataBuffer, DataBuffer> tadBuffersZ = this.tadManager.getTADOnlyShapeInfo(z, dimension);
        devTadShapeInfoZ = tadBuffersZ.getFirst().addressPointer();
        devTadOffsetsZ = tadBuffersZ.getSecond().addressPointer();
        if (this.extraz.get() == null) {
            this.extraz.set(new PointerPointer(32L));
        }
        PointerPointer dummy = this.extraz.get().put(new Pointer[]{hostTadShapeInfo, hostTadOffsets, devTadShapeInfoZ, devTadOffsetsZ});
        Pointer dimensionAddress = this.constantHandler.getConstantBuffer(dimension, DataType.INT).addressPointer();
        OpaqueDataBuffer xb = ((BaseCpuDataBuffer)x.data()).getOpaqueDataBuffer();
        OpaqueDataBuffer yb = ((BaseCpuDataBuffer)y.data()).getOpaqueDataBuffer();
        OpaqueDataBuffer zb = ((BaseCpuDataBuffer)z.data()).getOpaqueDataBuffer();
        switch (op.getOpType()) {
            case BROADCAST: {
                this.loop.execBroadcast(dummy, op.opNum(), xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, yb, (LongPointer)y.shapeInfoDataBuffer().addressPointer(), null, zb, (LongPointer)z.shapeInfoDataBuffer().addressPointer(), null, ((BaseCpuDataBuffer)op.dimensions().data()).getOpaqueDataBuffer(), (LongPointer)op.dimensions().shapeInfoDataBuffer().addressPointer(), null);
                break;
            }
            case BROADCAST_BOOL: {
                this.loop.execBroadcastBool(dummy, op.opNum(), xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, yb, (LongPointer)y.shapeInfoDataBuffer().addressPointer(), null, zb, (LongPointer)z.shapeInfoDataBuffer().addressPointer(), null, null, ((BaseCpuDataBuffer)op.dimensions().data()).getOpaqueDataBuffer(), (LongPointer)op.dimensions().shapeInfoDataBuffer().addressPointer(), null);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown operation type: [" + (Object)((Object)op.getOpType()) + "]");
            }
        }
        if (this.loop.lastErrorCode() != 0) {
            throw new RuntimeException(this.loop.lastErrorMessage());
        }
        return z;
    }

    protected <T extends Aggregate> Pointer getPointer(Batch<T> batch) {
        if (this.batchPointers.get() == null) {
            this.batchPointers.set(new HashMap());
        }
        if (!this.batchPointers.get().containsKey(batch.opNum())) {
            IntPointer pointer = new IntPointer(batch.getSample().getRequiredBatchMemorySize() / 4L);
            this.batchPointers.get().put(batch.opNum(), (Pointer)pointer);
            return pointer;
        }
        return this.batchPointers.get().get(batch.opNum());
    }

    @Override
    public <T extends Aggregate> void exec(Batch<T> batch) {
        IntPointer pointer = (IntPointer)this.getPointer(batch);
        int maxTypes = 5;
        int maxIntArrays = batch.getSample().maxIntArrays();
        int maxArraySize = batch.getSample().maxIntArraySize();
        int indexPos = maxTypes * Batch.getBatchLimit();
        int intArraysPos = indexPos + batch.getSample().maxIndexArguments() * Batch.getBatchLimit();
        int realPos = (intArraysPos + maxIntArrays * maxArraySize * Batch.getBatchLimit()) / (Nd4j.dataType() == DataType.DOUBLE ? 2 : 1);
        int argsPos = (realPos + batch.getSample().maxRealArguments() * Batch.getBatchLimit()) / (Nd4j.dataType() == DataType.DOUBLE ? 1 : 2);
        int shapesPos = argsPos + batch.getSample().maxArguments() * Batch.getBatchLimit();
        DataType dataType = null;
        for (int i = 0; i < batch.getNumAggregates(); ++i) {
            int e;
            Aggregate op = (Aggregate)batch.getAggregates().get(i);
            if (i == 0) {
                dataType = op.getArguments().get(0).dataType();
            }
            int idx = i * maxTypes;
            pointer.put((long)idx, op.getArguments().size());
            pointer.put((long)(idx + 1), op.getShapes().size());
            pointer.put((long)(idx + 2), op.getIndexingArguments().size());
            pointer.put((long)(idx + 3), op.getRealArguments().size());
            pointer.put((long)(idx + 4), op.getIntArrayArguments().size());
            for (int e2 = 0; e2 < op.getIndexingArguments().size(); ++e2) {
                idx = indexPos + i * batch.getSample().maxIndexArguments();
                pointer.put((long)(idx + e2), op.getIndexingArguments().get(e2).intValue());
            }
            int bsize = maxIntArrays * maxArraySize;
            for (int e3 = 0; e3 < op.getIntArrayArguments().size(); ++e3) {
                int step = i * bsize + e3 * maxArraySize;
                if (op.getIntArrayArguments().get(e3) == null) continue;
                for (int x = 0; x < op.getIntArrayArguments().get(e3).length; ++x) {
                    idx = intArraysPos + step + x;
                    pointer.put((long)idx, op.getIntArrayArguments().get(e3)[x]);
                }
            }
            switch (dataType) {
                case FLOAT: {
                    FloatPointer fPtr = new FloatPointer((Pointer)pointer);
                    for (e = 0; e < op.getRealArguments().size(); ++e) {
                        idx = realPos + i * op.maxRealArguments();
                        fPtr.put((long)(idx + e), op.getRealArguments().get(e).floatValue());
                    }
                    break;
                }
                case DOUBLE: {
                    DoublePointer dPtr = new DoublePointer((Pointer)pointer);
                    for (int e4 = 0; e4 < op.getRealArguments().size(); ++e4) {
                        idx = realPos + i * op.maxRealArguments();
                        dPtr.put((long)(idx + e4), op.getRealArguments().get(e4).doubleValue());
                    }
                    break;
                }
                default: {
                    throw new ND4JIllegalArgumentException("Only FLOAT and DOUBLE datatypes are supported");
                }
            }
            if (this.extraz.get() == null) {
                this.extraz.set(new PointerPointer(32L));
            }
            PointerPointer ptrPtr = new PointerPointer((Pointer)pointer);
            for (e = 0; e < op.getArguments().size(); ++e) {
                idx = argsPos + i * batch.getSample().maxArguments();
                if (op.getArguments().get(e) == null) continue;
                ptrPtr.put((long)(idx + e), op.getArguments().get(e).data().addressPointer());
            }
            for (e = 0; e < op.getShapes().size(); ++e) {
                idx = shapesPos + i * batch.getSample().maxShapes();
                if (op.getShapes().get(e) == null) continue;
                ptrPtr.put((long)(idx + e), op.getShapes().get(e).addressPointer());
            }
        }
        this.loop.execAggregateBatch(null, batch.getNumAggregates(), batch.opNum(), batch.getSample().maxArguments(), batch.getSample().maxShapes(), batch.getSample().maxIntArrays(), batch.getSample().maxIntArraySize(), batch.getSample().maxIndexArguments(), batch.getSample().maxRealArguments(), (Pointer)pointer, FlatBuffersMapper.getDataTypeAsByte(dataType));
        if (this.loop.lastErrorCode() != 0) {
            throw new RuntimeException(this.loop.lastErrorMessage());
        }
    }

    @Override
    public void exec(List<Aggregate> batch) {
        if (batch.size() == 0) {
            return;
        }
        List<Batch<Aggregate>> batches = Batch.getBatches(batch);
        for (Batch<Aggregate> single : batches) {
            this.exec(single);
        }
    }

    @Override
    public void exec(Aggregate op) {
        int x;
        if (this.memoryBlocks.get() == null) {
            this.memoryBlocks.set(new HashMap());
        }
        if (this.memoryBlocks.get().get(op.opNum()) == null) {
            this.memoryBlocks.get().put(op.opNum(), new AggregateMemoryBlock(op));
        }
        AggregateMemoryBlock block = this.memoryBlocks.get().get(op.opNum());
        int numArguments = op.getArguments().size();
        int numIndexArguments = op.getIndexingArguments().size();
        int numRealArguments = op.getRealArguments().size();
        int numShapes = op.getShapes().size();
        int numIntArrays = op.getIntArrayArguments().size();
        PointerPointer arguments = block.getArgumentsPointer();
        ArrayList<IntPointer> pointers = new ArrayList<IntPointer>();
        PointerPointer intArrays = block.getArraysPointer();
        DataType dataType = op.getArguments().get(0).dataType();
        for (int x2 = 0; x2 < numArguments; ++x2) {
            arguments.put((long)x2, op.getArguments().get(x2) == null ? null : op.getArguments().get(x2).data().addressPointer());
        }
        PointerPointer shapes = block.getShapesPointer();
        for (int x3 = 0; x3 < numShapes; ++x3) {
            if (op.getShapes().get(x3).dataType() != DataType.LONG) {
                throw new RuntimeException("ShapeBuffers should have LONG data opType");
            }
            shapes.put((long)x3, op.getShapes().get(x3) == null ? null : op.getShapes().get(x3).addressPointer());
        }
        IntPointer pointer = block.getIndexingPointer();
        for (int x4 = 0; x4 < numIndexArguments; ++x4) {
            pointer.put((long)x4, op.getIndexingArguments().get(x4).intValue());
        }
        double[] reals = new double[numRealArguments];
        block7: for (x = 0; x < numRealArguments; ++x) {
            switch (dataType) {
                case FLOAT: {
                    ((FloatPointer)block.getRealArgumentsPointer()).put((long)x, op.getRealArguments().get(x).floatValue());
                    continue block7;
                }
                case DOUBLE: {
                    ((DoublePointer)block.getRealArgumentsPointer()).put((long)x, op.getRealArguments().get(x).doubleValue());
                    continue block7;
                }
                default: {
                    throw new ND4JIllegalArgumentException("Only FLOAT and DOUBLE datatypes are supported");
                }
            }
        }
        for (x = 0; x < numIntArrays; ++x) {
            IntPointer intPtr = block.getIntArrays().get(x);
            intPtr.put(op.getIntArrayArguments().get(x), 0, op.getIntArrayArguments().get(x).length);
            intArrays.put((long)x, (Pointer)intPtr);
            pointers.add(intPtr);
        }
        this.loop.execAggregate(null, op.opNum(), arguments, numArguments, shapes, numShapes, pointer, numIndexArguments, intArrays, numIntArrays, block.getRealArgumentsPointer(), numRealArguments, FlatBuffersMapper.getDataTypeAsByte(dataType));
        if (this.loop.lastErrorCode() != 0) {
            throw new RuntimeException(this.loop.lastErrorMessage());
        }
    }

    @Override
    public Properties getEnvironmentInformation() {
        Properties properties = super.getEnvironmentInformation();
        properties.put("backend", "CPU");
        properties.put("omp.threads", (Object)this.loop.ompGetMaxThreads());
        properties.put("blas.threads", (Object)Nd4j.factory().blas().getMaxThreads());
        properties.put("blas.vendor", Nd4j.factory().blas().getBlasVendor().toString());
        properties.put("memory.free", (Object)(Pointer.maxBytes() - Pointer.totalBytes()));
        if (PerformanceTracker.getInstance() != null) {
            properties.put("memoryBandwidth", PerformanceTracker.getInstance().getCurrentBandwidth());
        }
        return properties;
    }

    @Override
    public INDArray exec(RandomOp op) {
        return this.exec(op, Nd4j.getRandom());
    }

    @Override
    public INDArray exec(RandomOp op, Random rng) {
        return this.exec(op, null, rng);
    }

    public INDArray exec(RandomOp op, OpContext oc, Random rng) {
        OpaqueDataBuffer zb;
        INDArray x = this.getX(op, oc);
        INDArray y = this.getY(op, oc);
        INDArray z = this.getZ(op, oc);
        if (op instanceof BaseRandomOp && ((BaseRandomOp)op).isTripleArgRngOp() && z != null && x == null && y == null) {
            x = z;
            y = z;
        }
        if (!(rng instanceof CpuNativeRandom)) {
            throw new IllegalStateException("You should use one of NativeRandom classes for NativeOperations execution. Op class: " + op.getClass().getName());
        }
        long st = this.profilingConfigurableHookIn(op, new DataBuffer[0]);
        if (z != null) {
            Preconditions.checkArgument(z.isR(), "Op.Z must have one of floating point types");
        }
        OpaqueDataBuffer xb = x == null ? null : ((BaseCpuDataBuffer)x.data()).getOpaqueDataBuffer();
        OpaqueDataBuffer yb = y == null ? null : ((BaseCpuDataBuffer)y.data()).getOpaqueDataBuffer();
        OpaqueDataBuffer opaqueDataBuffer = zb = z == null ? null : ((BaseCpuDataBuffer)z.data()).getOpaqueDataBuffer();
        if (x != null && y != null && z != null) {
            DataBuffer dataBuffer = op.extraArgsDataBuff(z.dataType());
            this.loop.execRandom3(null, op.opNum(), rng.getStatePointer(), xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, yb, (LongPointer)y.shapeInfoDataBuffer().addressPointer(), null, zb, (LongPointer)z.shapeInfoDataBuffer().addressPointer(), null, dataBuffer != null ? dataBuffer.addressPointer() : null);
        } else if (x != null && z != null) {
            DataBuffer dataBuffer = op.extraArgsDataBuff(z.dataType());
            this.loop.execRandom2(null, op.opNum(), rng.getStatePointer(), xb, (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, zb, (LongPointer)z.shapeInfoDataBuffer().addressPointer(), null, dataBuffer != null ? dataBuffer.addressPointer() : null);
        } else {
            this.loop.execRandom(null, op.opNum(), rng.getStatePointer(), zb, (LongPointer)z.shapeInfoDataBuffer().addressPointer(), null, op.extraArgsDataBuff(z.dataType()).addressPointer());
        }
        if (this.loop.lastErrorCode() != 0) {
            throw new RuntimeException(this.loop.lastErrorMessage());
        }
        this.profilingConfigurableHookOut(op, oc, st);
        return z;
    }

    @Override
    public TADManager getTADManager() {
        return this.tadManager;
    }

    @Override
    public synchronized Map<String, CustomOpDescriptor> getCustomOperations() {
        if (this.customOps == null) {
            String[] split2;
            String list = this.loop.getAllCustomOps();
            if (list == null || list.isEmpty()) {
                log.warn("No customs ops available!");
                this.customOps = Collections.emptyMap();
                return this.customOps;
            }
            HashMap<String, CustomOpDescriptor> map = new HashMap<String, CustomOpDescriptor>();
            for (String op : split2 = list.split(";")) {
                if (op == null || op.isEmpty()) continue;
                String[] another = op.split(":");
                CustomOpDescriptor descriptor = CustomOpDescriptor.builder().hash(Long.valueOf(another[1])).numInputs(Integer.valueOf(another[2])).numOutputs(Integer.valueOf(another[3])).allowsInplace(Integer.valueOf(another[4]) == 1).numTArgs(Integer.valueOf(another[5])).numIArgs(Integer.valueOf(another[6])).build();
                map.put(another[0], descriptor);
            }
            this.customOps = Collections.unmodifiableMap(map);
        }
        return this.customOps;
    }

    private PointerPointer getPointerPointerFrom(ThreadLocal<Map<Integer, PointerPointer>> map, int numArguments) {
        if (map.get() == null) {
            HashMap<Integer, PointerPointer> store = new HashMap<Integer, PointerPointer>();
            store.put(numArguments, new PointerPointer((long)numArguments));
            map.set(store);
            return map.get().get(numArguments);
        }
        if (map.get().get(numArguments) == null) {
            PointerPointer pointerPointer = new PointerPointer((long)numArguments);
            map.get().put(numArguments, pointerPointer);
            return pointerPointer;
        }
        return map.get().get(numArguments);
    }

    private ShortPointer getShortPointerFrom(ThreadLocal<Map<Integer, ShortPointer>> map, int numArguments) {
        if (map.get() == null) {
            HashMap<Integer, ShortPointer> store = new HashMap<Integer, ShortPointer>();
            store.put(numArguments, new ShortPointer((long)numArguments));
            map.set(store);
            return map.get().get(numArguments);
        }
        if (map.get().get(numArguments) == null) {
            ShortPointer pointerPointer = new ShortPointer((long)numArguments);
            map.get().put(numArguments, pointerPointer);
            return pointerPointer;
        }
        return map.get().get(numArguments);
    }

    private LongPointer getLongPointerFrom(ThreadLocal<Map<Integer, LongPointer>> map, int numArguments) {
        if (map.get() == null) {
            HashMap<Integer, LongPointer> store = new HashMap<Integer, LongPointer>();
            store.put(numArguments, new LongPointer((long)numArguments));
            map.set(store);
            return map.get().get(numArguments);
        }
        if (map.get().get(numArguments) == null) {
            LongPointer pointerPointer = new LongPointer((long)numArguments);
            map.get().put(numArguments, pointerPointer);
            return pointerPointer;
        }
        return map.get().get(numArguments);
    }

    private DoublePointer getDoublePointerFrom(ThreadLocal<Map<Integer, DoublePointer>> map, int numArguments) {
        if (map.get() == null) {
            HashMap<Integer, DoublePointer> store = new HashMap<Integer, DoublePointer>();
            store.put(numArguments, new DoublePointer((long)numArguments));
            map.set(store);
            return map.get().get(numArguments);
        }
        if (map.get().get(numArguments) == null) {
            DoublePointer pointerPointer = new DoublePointer((long)numArguments);
            map.get().put(numArguments, pointerPointer);
            return pointerPointer;
        }
        return map.get().get(numArguments);
    }

    private BooleanPointer getBooleanPointerFrom(ThreadLocal<Map<Integer, BooleanPointer>> map, int numArguments) {
        if (map.get() == null) {
            HashMap<Integer, BooleanPointer> store = new HashMap<Integer, BooleanPointer>();
            store.put(numArguments, new BooleanPointer((long)numArguments));
            map.set(store);
            return map.get().get(numArguments);
        }
        if (map.get().get(numArguments) == null) {
            BooleanPointer pointerPointer = new BooleanPointer((long)numArguments);
            map.get().put(numArguments, pointerPointer);
            return pointerPointer;
        }
        return map.get().get(numArguments);
    }

    private PointerPointer getInputShapes(int numArguments) {
        return this.getPointerPointerFrom(this.inputShapes, numArguments);
    }

    private PointerPointer getInputBuffers(int numArguments) {
        return this.getPointerPointerFrom(this.inputBuffers, numArguments);
    }

    private PointerPointer getOutputShapes(int numArguments) {
        return this.getPointerPointerFrom(this.outputShapes, numArguments);
    }

    private PointerPointer getOutputBuffers(int numArguments) {
        return this.getPointerPointerFrom(this.outputBuffers, numArguments);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public INDArray[] exec(@NonNull CustomOp op) {
        if (op == null) {
            throw new NullPointerException("op is marked non-null but is null");
        }
        DifferentialFunction differentialFunction = (DifferentialFunction)((Object)op);
        String ownName = differentialFunction.getOwnName();
        boolean shapeOverride = false;
        if (op.numOutputArguments() == 0 && !op.isInplaceCall()) {
            try {
                List<LongShapeDescriptor> list = this.calculateOutputShape(op);
                if (list.isEmpty()) {
                    throw new ND4JIllegalStateException("Op name " + op.opName() + " failed to calculate output shape and data types.");
                }
                for (LongShapeDescriptor shape : list) {
                    op.addOutputArgument(Nd4j.create(shape, false));
                }
                shapeOverride = true;
            }
            catch (ND4JIllegalStateException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ND4JIllegalStateException("Op name " + op.opName() + " - no output arrays were provided and calculateOutputShape failed to execute", e);
            }
        }
        String name = op.opName();
        try (OpContext context = this.buildContext();){
            if (shapeOverride) {
                context.shapeFunctionOverride(true);
            }
            context.markInplace(op.isInplaceCall());
            context.setRngStates(Nd4j.getRandom().rootState(), Nd4j.getRandom().nodeState());
            context.setInputArrays(op.inputArguments());
            context.setOutputArrays(op.outputArguments());
            context.setBArguments(op.bArgs());
            context.setIArguments(op.iArgs());
            context.setTArguments(op.tArgs());
            context.setDArguments(op.dArgs());
            INDArray[] result = this.exec(op, context);
            Pair<Long, Long> states = context.getRngStates();
            for (INDArray in : op.inputArguments()) {
                if (in.isEmpty()) continue;
                ((BaseCpuDataBuffer)in.data()).actualizePointerAndIndexer();
            }
            for (INDArray out : op.outputArguments()) {
                if (out.isEmpty()) continue;
                ((BaseCpuDataBuffer)out.data()).actualizePointerAndIndexer();
            }
            Nd4j.getRandom().setStates(states.getFirst(), states.getSecond());
            INDArray[] iNDArrayArray = result;
            return iNDArrayArray;
        }
        catch (ND4JOpProfilerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Op [" + name + "] execution failed", e);
        }
    }

    protected LongShapeDescriptor getShapeFromPointer(LongPointer ptr) {
        int rank2 = (int)ptr.get(0L);
        long[] shape = new long[rank2 * 2 + 4];
        for (int i = 0; i < shape.length; ++i) {
            shape[i] = ptr.get((long)i);
        }
        ArrayType t = ArrayOptionsHelper.arrayType(shape);
        return LongShapeDescriptor.fromShape(Shape.shape(shape), Shape.stride(shape), Shape.elementWiseStride(shape), Shape.order(shape), ArrayOptionsHelper.dataType(shape), t == ArrayType.EMPTY);
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape(@NonNull CustomOp op) {
        if (op == null) {
            throw new NullPointerException("op is marked non-null but is null");
        }
        return this.calculateOutputShape(op, null);
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape(@NonNull CustomOp op, OpContext opContext) {
        OpaqueShapeList ptrptr;
        Object object;
        int nIn;
        if (op == null) {
            throw new NullPointerException("op is marked non-null but is null");
        }
        DifferentialFunction func = (DifferentialFunction)((Object)op);
        String opName = func.getOwnName();
        String lc = op.opName().toLowerCase();
        long hash = op.opHash();
        ArrayList<LongShapeDescriptor> result = new ArrayList<LongShapeDescriptor>();
        int n = nIn = opContext != null ? opContext.numInputArguments() : op.numInputArguments();
        if (nIn == 0 && op.getDescriptor().getNumInputs() >= 1) {
            if (log.isTraceEnabled()) {
                log.trace("Could not calculate output shape for op {}: number of input args was 0", (Object)op.getClass().getName());
            }
            return Collections.emptyList();
        }
        PointerPointer inputBuffers = new PointerPointer((long)nIn);
        PointerPointer inputShapes = new PointerPointer((long)nIn);
        List<INDArray> inputArgs = opContext != null && opContext.getInputArrays() != null && !opContext.getInputArrays().isEmpty() ? opContext.getInputArrays() : op.inputArguments();
        int cnt = 0;
        for (INDArray in : inputArgs) {
            if (!in.isEmpty()) {
                inputBuffers.put((long)cnt, in.data().addressPointer());
            }
            inputShapes.put((long)cnt++, in.shapeInfoDataBuffer().addressPointer());
        }
        int nIArgs = opContext != null ? opContext.numIArguments() : op.numIArguments();
        LongPointer iArgs = nIArgs > 0 ? new LongPointer((long)nIArgs) : null;
        cnt = 0;
        if (opContext != null) {
            Object object2 = opContext.getIArguments().iterator();
            while (object2.hasNext()) {
                Long i = (Long)object2.next();
                iArgs.put((long)cnt++, i.longValue());
            }
        } else {
            for (long i : op.iArgs()) {
                iArgs.put((long)cnt++, i);
            }
        }
        int nTArgs = opContext != null ? opContext.numTArguments() : op.numTArguments();
        DoublePointer tArgs = nTArgs > 0 ? new DoublePointer((long)nTArgs) : null;
        int nBArgs = opContext != null ? opContext.numBArguments() : op.numBArguments();
        BooleanPointer bArgs = nBArgs > 0 ? new BooleanPointer((long)nBArgs) : null;
        int nDArgs = opContext != null ? opContext.numDArguments() : op.numDArguments();
        IntPointer dArgs = nDArgs > 0 ? new IntPointer((long)nDArgs) : null;
        cnt = 0;
        if (opContext != null) {
            object = opContext.getBArguments().iterator();
            while (object.hasNext()) {
                Boolean b = (Boolean)object.next();
                bArgs.put((long)cnt++, b.booleanValue());
            }
        } else {
            for (boolean b : op.bArgs()) {
                bArgs.put((long)cnt++, b);
            }
        }
        cnt = 0;
        if (opContext != null) {
            object = opContext.getTArguments().iterator();
            while (object.hasNext()) {
                Double b = (Double)object.next();
                tArgs.put((long)cnt++, b.doubleValue());
            }
        } else {
            for (Object b : (Object)op.tArgs()) {
                tArgs.put((long)cnt++, (double)b);
            }
        }
        cnt = 0;
        if (opContext != null) {
            for (DataType b : opContext.getDArguments()) {
                dArgs.put((long)cnt++, b.toInt());
            }
        } else {
            for (DataType b : op.dArgs()) {
                dArgs.put((long)cnt++, b.toInt());
            }
        }
        try {
            ptrptr = this.loop.calculateOutputShapes2(null, hash, inputBuffers, inputShapes, nIn, tArgs, nTArgs, iArgs, nIArgs, bArgs, nBArgs, dArgs, nDArgs);
            if (this.loop.lastErrorCode() != 0) {
                DifferentialFunction differentialFunction = (DifferentialFunction)((Object)op);
                if (opContext != null) {
                    throw new RuntimeException("Op " + op.opName() + " with name " + differentialFunction.getOwnName() + " failed to execute. Here is the error from c++: " + this.loop.lastErrorMessage());
                }
                throw new RuntimeException("Op " + op.opName() + " with name " + differentialFunction.getOwnName() + " failed to execute. Here is the error from c++: " + this.loop.lastErrorMessage());
            }
        }
        catch (Throwable t) {
            StringBuilder sb = new StringBuilder();
            sb.append("Inputs: [(");
            for (int i = 0; i < inputArgs.size(); ++i) {
                if (i > 0) {
                    sb.append("), (");
                }
                sb.append(Shape.shapeToStringShort(inputArgs.get(i)));
            }
            sb.append(")]");
            if (op instanceof DifferentialFunction && ((DifferentialFunction)((Object)op)).getSameDiff() != null) {
                this.appendSameDiffInfo(sb, (DifferentialFunction)((Object)op));
            }
            int nOut = opContext != null ? opContext.numOutputArguments() : op.numOutputArguments();
            log.error("Failed to calculate output shapes for op {}. Attempted to execute with {} inputs, {} outputs, {} targs, {} iargs, {} bargs and {} dargs. {} - Please see above message (printed out from c++) for a possible cause of error.", new Object[]{op.opName(), nIn, nOut, nTArgs, nIArgs, nBArgs, nDArgs, sb.toString()});
            throw t;
        }
        if (this.loop.lastErrorCode() != 0) {
            throw new RuntimeException(this.loop.lastErrorMessage());
        }
        if (ptrptr == null) {
            throw new RuntimeException();
        }
        int e = 0;
        while ((long)e < this.loop.getShapeListSize(ptrptr)) {
            result.add(this.getShapeFromPointer(new PagedPointer((Pointer)this.loop.getShape(ptrptr, e)).asLongPointer()));
            ++e;
        }
        this.loop.deleteShapeList(ptrptr);
        if (log.isTraceEnabled()) {
            Object[] arr = new String[result.size()];
            for (int i = 0; i < result.size(); ++i) {
                arr[i] = result.get(i).toString();
            }
            DifferentialFunction differentialFunction = (DifferentialFunction)((Object)op);
            log.trace("Calculated output shapes for op  of name {} and type {} - {}", new Object[]{differentialFunction.getOwnName(), op.getClass().getName(), Arrays.toString(arr)});
        }
        return result;
    }

    @Override
    public void enableDebugMode(boolean reallyEnable) {
        this.debug.set(reallyEnable);
        this.loop.enableDebugMode(reallyEnable);
    }

    @Override
    public void enableVerboseMode(boolean reallyEnable) {
        this.verbose.set(reallyEnable);
        this.loop.enableVerboseMode(reallyEnable);
    }

    @Override
    public void registerGraph(long id, Pointer graph) {
        this.loop.registerGraph(null, id, graph);
        if (this.loop.lastErrorCode() != 0) {
            throw new RuntimeException(this.loop.lastErrorMessage());
        }
    }

    @Override
    public Map<String, INDArray> executeGraph(long id, @NonNull Map<String, INDArray> map, @NonNull Map<String, Integer> reverseMap) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        if (reverseMap == null) {
            throw new NullPointerException("reverseMap is marked non-null but is null");
        }
        PointerPointer ptrBuffers = new PointerPointer((long)map.size());
        PointerPointer ptrShapes = new PointerPointer((long)map.size());
        IntPointer ptrIndices = new IntPointer((long)map.size());
        int cnt = 0;
        ArrayList<String> keySet = new ArrayList<String>(map.keySet());
        for (String key : keySet) {
            INDArray array = map.get(key);
            ptrBuffers.put((long)cnt, array.data().addressPointer());
            ptrShapes.put((long)cnt, array.shapeInfoDataBuffer().addressPointer());
            ptrIndices.put((long)cnt, reverseMap.get(key).intValue());
            ++cnt;
        }
        LinkedHashMap<String, INDArray> newMap = new LinkedHashMap<String, INDArray>();
        OpaqueVariablesSet result = this.loop.executeStoredGraph(null, id, ptrBuffers, ptrShapes, ptrIndices, map.size());
        if (this.loop.lastErrorCode() != 0) {
            throw new RuntimeException(this.loop.lastErrorMessage());
        }
        OpStatus status = OpStatus.byNumber(this.loop.getVariablesSetStatus(result));
        if (status != OpStatus.ND4J_STATUS_OK) {
            throw new ND4JIllegalStateException("Op execution failed: " + (Object)((Object)status));
        }
        int e = 0;
        while ((long)e < this.loop.getVariablesSetSize(result)) {
            OpaqueVariable var = this.loop.getVariable(result, e);
            int nodeId = this.loop.getVariableId(var);
            int index = this.loop.getVariableIndex(var);
            LongPointer shapeInfo = this.loop.getVariableShape(var);
            Pointer buffer = this.loop.getVariableBuffer(var);
            int rank2 = (int)shapeInfo.get(0L);
            long[] jshape = new long[rank2 * 2 + 4];
            for (int i = 0; i < jshape.length; ++i) {
                jshape[i] = shapeInfo.get((long)i);
            }
            long[] shapeOf = Shape.shapeOf(jshape);
            long[] stridesOf = Shape.stridesOf(jshape);
            char order2 = Shape.order(jshape);
            INDArray array = Nd4j.create(shapeOf, stridesOf, 0L, order2);
            long perfX = PerformanceTracker.getInstance().helperStartTransaction();
            Pointer.memcpy((Pointer)array.data().addressPointer(), (Pointer)buffer, (long)(Shape.lengthOf(shapeOf) * (long)Nd4j.sizeOfDataType(array.dataType())));
            PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, Shape.lengthOf(shapeOf) * (long)Nd4j.sizeOfDataType(array.dataType()), MemcpyDirection.HOST_TO_HOST);
            String nodeName = this.loop.getVariableName(var);
            newMap.put(nodeName, array);
            ++e;
        }
        this.loop.deleteVariablesSet(result);
        return newMap;
    }

    @Override
    public void forgetGraph(long id) {
        this.loop.unregisterGraph(null, id);
        if (this.loop.lastErrorCode() != 0) {
            throw new RuntimeException(this.loop.lastErrorMessage());
        }
    }

    @Override
    public void setElementsThreshold(int threshold) {
        this.loop.setElementThreshold(threshold);
    }

    @Override
    public void setTadThreshold(int threshold) {
        this.loop.setTADThreshold(threshold);
    }

    @Override
    public String getString(DataBuffer buffer, long index) {
        Preconditions.checkArgument(buffer instanceof Utf8Buffer, "Expected Utf8Buffer");
        long addr = ((LongIndexer)buffer.indexer()).get(index);
        PagedPointer ptr = new PagedPointer(addr);
        Nd4jCpu.utf8string str = new Nd4jCpu.utf8string(ptr);
        return str._buffer().capacity((long)str._length()).getString();
    }

    @Override
    public OpExecutioner.ExecutionerType type() {
        return OpExecutioner.ExecutionerType.NATIVE_CPU;
    }

    @Override
    public boolean isExperimentalMode() {
        return this.experimentalMode.get();
    }

    @Override
    public void scatterUpdate(ScatterUpdate.UpdateOp op, @NonNull INDArray array, @NonNull INDArray indices, @NonNull INDArray updates, @NonNull int[] axis) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (indices == null) {
            throw new NullPointerException("indices is marked non-null but is null");
        }
        if (updates == null) {
            throw new NullPointerException("updates is marked non-null but is null");
        }
        if (axis == null) {
            throw new NullPointerException("axis is marked non-null but is null");
        }
        Pair<DataBuffer, DataBuffer> tadX = this.tadManager.getTADOnlyShapeInfo(array, axis);
        Pair<DataBuffer, DataBuffer> tadY = this.tadManager.getTADOnlyShapeInfo(updates, axis);
        if (tadY.getSecond().length() != indices.length()) {
            throw new IllegalStateException("Number of updates doesn't match number of indices. Bad dimensions used?");
        }
        this.loop.scatterUpdate(null, op.ordinal(), (int)indices.length(), array.data().addressPointer(), (LongPointer)tadX.getFirst().addressPointer(), (LongPointer)tadX.getSecond().addressPointer(), null, null, null, updates.data().addressPointer(), (LongPointer)tadY.getFirst().addressPointer(), (LongPointer)tadY.getSecond().addressPointer(), null, null, null, indices.data().addressPointer(), (LongPointer)indices.shapeInfoDataBuffer().addressPointer(), null, null);
        if (this.loop.lastErrorCode() != 0) {
            throw new RuntimeException(this.loop.lastErrorMessage());
        }
    }

    @Override
    public OpContext buildContext() {
        return new CpuOpContext();
    }

    @Override
    public INDArray[] exec(CustomOp op, @NonNull OpContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        long st = this.profilingConfigurableHookIn(op, context);
        boolean mklOverride = false;
        try {
            INDArray[] differentialFunction;
            int status;
            if (Nd4jCpu.Environment.getInstance().isUseONEDNN()) {
                String opName = op.opName();
                Boolean state = this.mklOverrides.get(op);
                if (state != null && state.booleanValue()) {
                    mklOverride = true;
                    Nd4jCpu.Environment.getInstance().setUseONEDNN(true);
                }
            }
            if ((status = this.loop.execCustomOp2(null, op.opHash(), context.contextPointer())) != 0) {
                differentialFunction = (INDArray[])op;
                throw new RuntimeException("Op with name " + differentialFunction.getOwnName() + " and op type [" + op.opName() + "] execution failed with message " + this.loop.lastErrorMessage());
            }
            if (context.getOutputArrays().isEmpty()) {
                differentialFunction = new INDArray[]{};
                return differentialFunction;
            }
            differentialFunction = context.getOutputArrays().toArray(new INDArray[context.getOutputArrays().size()]);
            return differentialFunction;
        }
        catch (Exception e) {
            String n;
            int nB;
            int nI;
            int nT;
            StringBuilder sb = new StringBuilder();
            sb.append("Inputs: [(");
            int nIn = context.getInputArrays() == null ? 0 : context.getInputArrays().size();
            for (int i = 0; i < nIn; ++i) {
                if (i > 0) {
                    sb.append("), (");
                }
                sb.append(Shape.shapeToStringShort(context.getInputArrays().get(i)));
            }
            sb.append(")]. Outputs: [(");
            int nOut = context.getOutputArrays() == null ? 0 : context.getOutputArrays().size();
            for (int i = 0; i < nOut; ++i) {
                if (i > 0) {
                    sb.append("), (");
                }
                sb.append(Shape.shapeToStringShort(context.getOutputArrays().get(i)));
            }
            sb.append(")]. tArgs: ");
            int n2 = nT = context.getTArguments() == null ? 0 : context.getTArguments().size();
            if (nT > 0) {
                sb.append(context.getTArguments());
            } else {
                sb.append("-");
            }
            sb.append(". iArgs: ");
            int n3 = nI = context.getIArguments() == null ? 0 : context.getIArguments().size();
            if (nI > 0) {
                sb.append(context.getIArguments());
            } else {
                sb.append("-");
            }
            sb.append(". bArgs: ");
            int n4 = nB = context.getBArguments() == null ? 0 : context.getBArguments().size();
            if (nB > 0) {
                sb.append(context.getBArguments());
            } else {
                sb.append("-");
            }
            if (op instanceof DifferentialFunction && (n = ((DifferentialFunction)((Object)op)).getOwnName()) != null && !n.equals(op.opName())) {
                sb.append(". Op own name: \"").append(n).append("\"");
            }
            if (op instanceof DifferentialFunction && ((DifferentialFunction)((Object)op)).getSameDiff() != null) {
                this.appendSameDiffInfo(sb, (DifferentialFunction)((Object)op));
            }
            log.error("Failed to execute op " + op.opName() + ". Attempted to execute with " + nIn + " inputs, " + nOut + " outputs, " + nT + " targs," + nB + " bargs and " + nI + " iargs. " + sb.toString() + " - Please see above message (printed out from c++) for a possible cause of error.");
            throw e;
        }
        finally {
            if (mklOverride) {
                Nd4jCpu.Environment.getInstance().setUseONEDNN(true);
            }
            this.profilingConfigurableHookOut(op, context, st);
        }
    }

    @Override
    public INDArrayStatistics inspectArray(INDArray array) {
        Nd4jCpu.DebugInfo debugInfo = new Nd4jCpu.DebugInfo();
        this.loop.inspectArray(null, array.data().addressPointer(), (LongPointer)array.shapeInfoDataBuffer().addressPointer(), null, null, debugInfo);
        if (this.loop.lastErrorCode() != 0) {
            throw new RuntimeException(this.loop.lastErrorMessage());
        }
        return INDArrayStatistics.builder().minValue(debugInfo._minValue()).maxValue(debugInfo._maxValue()).meanValue(debugInfo._meanValue()).stdDevValue(debugInfo._stdDevValue()).countInf(debugInfo._infCount()).countNaN(debugInfo._nanCount()).countNegative(debugInfo._negativeCount()).countPositive(debugInfo._positiveCount()).countZero(debugInfo._zeroCount()).build();
    }

    @Override
    public DataBuffer createShapeInfo(long[] shape, long[] stride, long elementWiseStride, char order2, DataType dtype, boolean empty) {
        OpaqueConstantShapeBuffer dbf = this.loop.shapeBuffer(shape.length, new LongPointer(shape), new LongPointer(stride), dtype.toInt(), order2, elementWiseStride, empty);
        if (this.loop.lastErrorCode() != 0) {
            throw new RuntimeException(this.loop.lastErrorMessage());
        }
        LongBuffer result = new LongBuffer(this.loop.getConstantShapeBufferPrimary(dbf), (long)Shape.shapeInfoLength(shape.length));
        this.loop.deleteConstantShapeBuffer(dbf);
        return result;
    }

    @Override
    public DataBuffer createShapeInfo(long[] shape, long[] stride, long elementWiseStride, char order2, DataType dtype, long extras) {
        OpaqueConstantShapeBuffer dbf = this.loop.shapeBufferEx(shape.length, new LongPointer(shape), new LongPointer(stride), dtype.toInt(), order2, elementWiseStride, extras);
        if (this.loop.lastErrorCode() != 0) {
            throw new RuntimeException(this.loop.lastErrorMessage());
        }
        LongBuffer result = new LongBuffer(this.loop.getConstantShapeBufferPrimary(dbf), (long)Shape.shapeInfoLength(shape.length));
        this.loop.deleteConstantShapeBuffer(dbf);
        return result;
    }

    @Override
    public TadPack tadShapeInfoAndOffsets(INDArray array, int[] dimension) {
        OpaqueTadPack pack = this.loop.tadOnlyShapeInfo((LongPointer)array.shapeInfoDataBuffer().addressPointer(), new IntPointer(dimension), dimension.length);
        if (this.loop.lastErrorCode() != 0) {
            throw new RuntimeException(this.loop.lastErrorMessage());
        }
        LongBuffer tadShape = new LongBuffer((Pointer)this.loop.getPrimaryShapeInfo(pack), (long)this.loop.getShapeInfoLength(pack));
        LongBuffer tadOffsets = new LongBuffer((Pointer)this.loop.getPrimaryOffsets(pack), this.loop.getNumberOfTads(pack));
        this.loop.deleteTadPack(pack);
        return new TadPack(tadShape, tadOffsets);
    }

    protected void appendSameDiffInfo(StringBuilder sb, DifferentialFunction df) {
        Object[] inNames = df.argNames();
        Object[] outNames = df.outputVariablesNames();
        if (inNames != null) {
            sb.append(". Input var names: ").append(Arrays.toString(inNames));
        }
        if (outNames != null) {
            sb.append(". Output var names: ").append(Arrays.toString(outNames));
        }
    }

    private static class AggregateMemoryBlock {
        private List<IntPointer> intArrays = new ArrayList<IntPointer>();
        private IntPointer indexingPointer;
        private Pointer realArgumentsPointer;
        private PointerPointer shapesPointer;
        private PointerPointer argumentsPointer;
        private PointerPointer arraysPointer;
        private final int opNum;

        private AggregateMemoryBlock(@NonNull Aggregate op) {
            if (op == null) {
                throw new NullPointerException("op is marked non-null but is null");
            }
            this.opNum = op.opNum();
            for (int i = 0; i < op.maxIntArrays(); ++i) {
                this.intArrays.add(new IntPointer((long)op.maxIntArraySize()));
            }
            this.indexingPointer = new IntPointer((long)op.maxIndexArguments());
            this.realArgumentsPointer = Nd4j.dataType() == DataType.DOUBLE ? new DoublePointer((long)op.maxRealArguments()) : new FloatPointer((long)op.maxRealArguments());
            this.shapesPointer = new PointerPointer((long)op.maxShapes());
            this.argumentsPointer = new PointerPointer((long)op.maxArguments());
            this.arraysPointer = new PointerPointer((long)op.maxIntArrays());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AggregateMemoryBlock that = (AggregateMemoryBlock)o;
            return this.opNum == that.opNum;
        }

        public int hashCode() {
            return this.opNum;
        }

        public List<IntPointer> getIntArrays() {
            return this.intArrays;
        }

        public IntPointer getIndexingPointer() {
            return this.indexingPointer;
        }

        public Pointer getRealArgumentsPointer() {
            return this.realArgumentsPointer;
        }

        public PointerPointer getShapesPointer() {
            return this.shapesPointer;
        }

        public PointerPointer getArgumentsPointer() {
            return this.argumentsPointer;
        }

        public PointerPointer getArraysPointer() {
            return this.arraysPointer;
        }

        public int getOpNum() {
            return this.opNum;
        }

        public void setIntArrays(List<IntPointer> intArrays) {
            this.intArrays = intArrays;
        }

        public void setIndexingPointer(IntPointer indexingPointer) {
            this.indexingPointer = indexingPointer;
        }

        public void setRealArgumentsPointer(Pointer realArgumentsPointer) {
            this.realArgumentsPointer = realArgumentsPointer;
        }

        public void setShapesPointer(PointerPointer shapesPointer) {
            this.shapesPointer = shapesPointer;
        }

        public void setArgumentsPointer(PointerPointer argumentsPointer) {
            this.argumentsPointer = argumentsPointer;
        }

        public void setArraysPointer(PointerPointer arraysPointer) {
            this.arraysPointer = arraysPointer;
        }

        public String toString() {
            return "NativeOpExecutioner.AggregateMemoryBlock(intArrays=" + this.getIntArrays() + ", indexingPointer=" + this.getIndexingPointer() + ", realArgumentsPointer=" + this.getRealArgumentsPointer() + ", shapesPointer=" + this.getShapesPointer() + ", argumentsPointer=" + this.getArgumentsPointer() + ", arraysPointer=" + this.getArraysPointer() + ", opNum=" + this.getOpNum() + ")";
        }
    }
}

