/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.preprocessor;

import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;

public class CompositeDataSetPreProcessor
implements DataSetPreProcessor {
    private final boolean stopOnEmptyDataSet;
    private DataSetPreProcessor[] preProcessors;

    public CompositeDataSetPreProcessor(DataSetPreProcessor ... preProcessors) {
        this(false, preProcessors);
    }

    public CompositeDataSetPreProcessor(boolean stopOnEmptyDataSet, DataSetPreProcessor ... preProcessors) {
        this.stopOnEmptyDataSet = stopOnEmptyDataSet;
        this.preProcessors = preProcessors;
    }

    @Override
    public void preProcess(DataSet dataSet) {
        Preconditions.checkNotNull(dataSet, "Encountered null dataSet");
        if (this.stopOnEmptyDataSet && dataSet.isEmpty()) {
            return;
        }
        for (DataSetPreProcessor p : this.preProcessors) {
            p.preProcess(dataSet);
            if (!this.stopOnEmptyDataSet || !dataSet.isEmpty()) continue;
            return;
        }
    }
}

