/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing.conditions;

import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.conditions.BaseCondition;
import org.nd4j.linalg.indexing.conditions.Conditions;

public class EpsilonNotEquals
extends BaseCondition {
    private double eps = Nd4j.EPS_THRESHOLD;

    public EpsilonNotEquals() {
        this(0.0);
    }

    public EpsilonNotEquals(Number value) {
        this(value, Nd4j.EPS_THRESHOLD);
    }

    public EpsilonNotEquals(Number value, Number eps) {
        super(value);
        this.eps = eps.doubleValue();
    }

    @Override
    public void setValue(Number value) {
    }

    @Override
    public Conditions.ConditionMode conditionType() {
        return Conditions.ConditionMode.EPSILON_NOT_EQUALS;
    }

    @Override
    public double epsThreshold() {
        return this.eps;
    }

    @Override
    public Boolean apply(Number input) {
        return (double)Math.abs(input.floatValue() - this.value.floatValue()) < Nd4j.EPS_THRESHOLD;
    }
}

