/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.util;

import org.nd4j.common.base.Preconditions;

public class ConvConfigUtil {
    public static void validate2D(long kH, long kW, long sH, long sW, long pH, long pW, long dH, long dW) {
        Preconditions.checkArgument(kH != 0L, "Kernel height can not be 0");
        Preconditions.checkArgument(kW != 0L, "Kernel width can not be 0");
        Preconditions.checkArgument(sH > 0L, "Stride height can not be negative or 0, got: %s", sH);
        Preconditions.checkArgument(sW > 0L, "Stride width can not be negative or 0, got: %s", sW);
        Preconditions.checkArgument(pH >= 0L, "Padding height can not be negative, got: %s", pH);
        Preconditions.checkArgument(pW >= 0L, "Padding width can not be negative, got: %s", pW);
        Preconditions.checkArgument(dH > 0L, "Dilation height can not be negative or 0, got: %s", dH);
        Preconditions.checkArgument(dW > 0L, "Dilation width can not be negative or 0, got: %s", dW);
    }

    public static void validate3D(long kH, long kW, long kD, long sH, long sW, long sD, long pH, long pW, long pD, long dH, long dW, long dD) {
        Preconditions.checkArgument(kH != 0L, "Kernel height can not be 0");
        Preconditions.checkArgument(kW != 0L, "Kernel width can not be 0");
        Preconditions.checkArgument(kD != 0L, "Kernel depth can not be 0");
        Preconditions.checkArgument(sH > 0L, "Stride height can not be negative or 0, got: %s", sH);
        Preconditions.checkArgument(sW > 0L, "Stride width can not be negative or 0, got: %s", sW);
        Preconditions.checkArgument(sD > 0L, "Stride depth can not be negative or 0, got: %s", sD);
        Preconditions.checkArgument(pH >= 0L, "Padding height can not be negative, got: %s", pH);
        Preconditions.checkArgument(pW >= 0L, "Padding width can not be negative, got: %s", pW);
        Preconditions.checkArgument(pD >= 0L, "Padding depth can not be negative, got: %s", pD);
        Preconditions.checkArgument(dH > 0L, "Dilation height can not be negative or 0, got: %s", dH);
        Preconditions.checkArgument(dW > 0L, "Dilation width can not be negative or 0, got: %s", dW);
        Preconditions.checkArgument(dD > 0L, "Dilation depth can not be negative or 0, got: %s", dD);
    }

    public static void validateExtra3D(long aH, long aW, long aD) {
        Preconditions.checkArgument(aH >= 0L, "Output padding height can not be negative, got: %s", aH);
        Preconditions.checkArgument(aW >= 0L, "Output padding width can not be negative, got: %s", aW);
        Preconditions.checkArgument(aD >= 0L, "Output padding depth can not be negative, got: %s", aD);
    }

    public static void validate1D(long k, long s, long p, long d) {
        Preconditions.checkArgument(k != 0L, "Kernel can not be 0");
        Preconditions.checkArgument(s > 0L, "Stride can not be negative or 0, got: %s", s);
        Preconditions.checkArgument(d > 0L, "Dilation can not be negative or 0, got: %s", s);
        Preconditions.checkArgument(p >= 0L, "Padding can not be negative, got: %s", p);
    }

    public static void validateLRN(double alpha, double beta, double bias, int depth) {
        Preconditions.checkArgument(depth > 0, "Depth can not be 0 or negative, got: %s", depth);
    }

    private ConvConfigUtil() {
    }
}

