/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.presets;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Scanner;
import org.bytedeco.javacpp.tools.Info;
import org.bytedeco.javacpp.tools.InfoMap;
import org.bytedeco.javacpp.tools.Logger;

public class OpExclusionUtils {
    public static void processOps(Logger logger, Properties properties, InfoMap infoMap) {
        String separator = properties.getProperty("platform.path.separator");
        String[] includePaths = properties.getProperty("platform.includepath").split(separator);
        File file = null;
        File opFile = null;
        boolean foundCustom = false;
        boolean foundOps = false;
        for (String string : includePaths) {
            if (!foundCustom && (file = new File(string, "ops/declarable/CustomOperations.h")).exists()) {
                foundCustom = true;
            }
            if (!foundOps && (opFile = new File(string, "generated/include_ops.h")).exists()) {
                foundOps = true;
            }
            if (foundCustom && foundOps) break;
        }
        boolean allOps = false;
        HashSet<String> opsToExclude = new HashSet<String>();
        try {
            Throwable throwable = null;
            try (Scanner scanner = new Scanner(opFile, "UTF-8");){
                String line;
                while (scanner.hasNextLine() && !(line = scanner.nextLine().trim()).contains("#ifndef")) {
                    if (line.contains("#endif")) {
                        break;
                    }
                    if (line.contains("SD_ALL_OPS")) {
                        allOps = true;
                        System.out.println("All ops found.");
                        break;
                    }
                    String[] lineSplit = line.split(" ");
                    if (lineSplit.length < 2) {
                        System.err.println("Unable to add op to exclude. Invalid op found: " + line);
                        continue;
                    }
                    String opName = lineSplit[1].replace("OP_", "");
                    opsToExclude.add(opName);
                    opsToExclude.add(opName + "_bp");
                }
            }
            catch (Throwable line) {
                Throwable throwable2 = line;
                throw line;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not parse CustomOperations.h and headers", e);
        }
        if (opsToExclude.isEmpty()) {
            System.out.println("No ops found for exclusion setting all ops to true");
            allOps = true;
        }
        ArrayList<File> files = new ArrayList<File>();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (file == null) {
            throw new IllegalStateException("No file found in include paths. Please ensure one of the include paths leads to path/ops/declarable/CustomOperations.h");
        }
        files.add(file);
        File[] headers = new File(file.getParent(), "headers").listFiles();
        if (headers == null) {
            throw new IllegalStateException("No headers found for file " + file.getAbsolutePath());
        }
        files.addAll(Arrays.asList(headers));
        Collections.sort(files);
        block26: for (File f : files) {
            try {
                Scanner scanner = new Scanner(f, "UTF-8");
                Throwable throwable = null;
                block27: while (true) {
                    try {
                        while (scanner.hasNextLine()) {
                            String line = scanner.nextLine().trim();
                            if (!line.startsWith("DECLARE_")) continue;
                            try {
                                int start = line.indexOf(40) + 1;
                                int end = line.indexOf(44);
                                if (end < start) {
                                    end = line.indexOf(41);
                                }
                                String name = line.substring(start, end).trim();
                                arrayList.add(name);
                                continue block27;
                            }
                            catch (Exception e) {
                                throw new RuntimeException("Could not parse line from CustomOperations.h and headers: \"" + line + "\"", e);
                            }
                        }
                        continue block26;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                finally {
                    if (scanner == null) continue;
                    if (throwable != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    scanner.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not parse CustomOperations.h and headers", e);
            }
        }
        Collections.sort(arrayList);
        logger.info("Ops found in CustomOperations.h and headers: " + arrayList);
        if (!allOps) {
            logger.info("Found ops to only include " + opsToExclude);
            for (String op : arrayList) {
                if (!opsToExclude.contains(op)) {
                    logger.info("Excluding op " + op);
                    infoMap.put(new Info(new String[]{"NOT_EXCLUDED(OP_" + op + ")"}).skip(true).define(false));
                    continue;
                }
                logger.info("Including " + op);
                infoMap.put(new Info(new String[]{"NOT_EXCLUDED(OP_" + op + ")"}).define(true));
                infoMap.put(new Info(new String[]{"NOT_EXCLUDED(OP_" + op + "_bp)"}).define(true));
            }
        }
    }
}

