/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.protobuf.common.collect;

import org.nd4j.shade.protobuf.common.annotations.GwtCompatible;
import org.nd4j.shade.protobuf.common.annotations.VisibleForTesting;
import org.nd4j.shade.protobuf.common.base.Preconditions;
import org.nd4j.shade.protobuf.common.collect.ImmutableList;

@GwtCompatible(serializable=true, emulated=true)
class RegularImmutableList<E>
extends ImmutableList<E> {
    static final ImmutableList<Object> EMPTY = new RegularImmutableList<Object>(new Object[0], 0);
    @VisibleForTesting
    final transient Object[] array;
    private final transient int size;

    RegularImmutableList(Object[] array, int size2) {
        this.array = array;
        this.size = size2;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    Object[] internalArray() {
        return this.array;
    }

    @Override
    int internalArrayStart() {
        return 0;
    }

    @Override
    int internalArrayEnd() {
        return this.size;
    }

    @Override
    int copyIntoArray(Object[] dst, int dstOff) {
        System.arraycopy(this.array, 0, dst, dstOff, this.size);
        return dstOff + this.size;
    }

    @Override
    public E get(int index) {
        Preconditions.checkElementIndex(index, this.size);
        return (E)this.array[index];
    }
}

