/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.weightinit.impl;

import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.weightinit.BaseWeightInitScheme;
import org.nd4j.weightinit.WeightInit;

public class UniformInitScheme
extends BaseWeightInitScheme {
    private double fanIn;

    public UniformInitScheme(char order2, double fanIn) {
        super(order2);
        this.fanIn = fanIn;
    }

    @Override
    public INDArray doCreate(DataType dataType, long[] shape, INDArray paramsView) {
        double a = 1.0 / Math.sqrt(this.fanIn);
        return Nd4j.rand(Nd4j.getDistributions().createUniform(-a, a), shape);
    }

    @Override
    public WeightInit type() {
        return WeightInit.UNIFORM;
    }

    public static UniformInitSchemeBuilder builder() {
        return new UniformInitSchemeBuilder();
    }

    public static class UniformInitSchemeBuilder {
        private char order;
        private double fanIn;

        UniformInitSchemeBuilder() {
        }

        public UniformInitSchemeBuilder order(char order2) {
            this.order = order2;
            return this;
        }

        public UniformInitSchemeBuilder fanIn(double fanIn) {
            this.fanIn = fanIn;
            return this;
        }

        public UniformInitScheme build() {
            return new UniformInitScheme(this.order, this.fanIn);
        }

        public String toString() {
            return "UniformInitScheme.UniformInitSchemeBuilder(order=" + this.order + ", fanIn=" + this.fanIn + ")";
        }
    }
}

