/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.weightinit.impl;

import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.weightinit.BaseWeightInitScheme;
import org.nd4j.weightinit.WeightInit;

public class ZeroInitScheme
extends BaseWeightInitScheme {
    public ZeroInitScheme(char order2) {
        super(order2);
    }

    @Override
    public INDArray doCreate(DataType dataType, long[] shape, INDArray paramsView) {
        if (shape == null) {
            throw new ND4JIllegalStateException("Shape must not be null!");
        }
        return Nd4j.createUninitialized(dataType, shape, this.order()).assign(Float.valueOf(0.0f));
    }

    @Override
    public WeightInit type() {
        return WeightInit.ZERO;
    }

    public static ZeroInitSchemeBuilder builder() {
        return new ZeroInitSchemeBuilder();
    }

    public ZeroInitScheme() {
    }

    public static class ZeroInitSchemeBuilder {
        private char order;

        ZeroInitSchemeBuilder() {
        }

        public ZeroInitSchemeBuilder order(char order2) {
            this.order = order2;
            return this;
        }

        public ZeroInitScheme build() {
            return new ZeroInitScheme(this.order);
        }

        public String toString() {
            return "ZeroInitScheme.ZeroInitSchemeBuilder(order=" + this.order + ")";
        }
    }
}

