/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.core.listener;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import lombok.NonNull;
import org.deeplearning4j.core.listener.DeviceMetric;
import org.deeplearning4j.core.listener.DiskInfo;
import org.nd4j.linalg.api.memory.MemcpyDirection;
import org.nd4j.linalg.api.ops.performance.PerformanceTracker;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.dataformat.yaml.YAMLFactory;
import oshi.hardware.CentralProcessor;
import oshi.json.SystemInfo;
import oshi.json.hardware.CentralProcessor;
import oshi.json.hardware.GlobalMemory;
import oshi.json.hardware.HWDiskStore;
import oshi.json.software.os.NetworkParams;
import oshi.util.Util;

public class HardwareMetric
implements Serializable {
    private static ObjectMapper yamlMapper = new ObjectMapper(new YAMLFactory());
    private Map<Integer, DeviceMetric> perCoreMetrics;
    private long physicalProcessorCount;
    private long logicalProcessorCount;
    private long currentMemoryUse;
    private Map<Integer, DeviceMetric> gpuMetrics;
    private String hostName;
    private long ioWaitTime;
    private long averagedCpuLoad;
    private Map<Integer, DiskInfo> diskInfo;
    private String name;

    private HardwareMetric() {
    }

    public static HardwareMetric fromSystem() {
        return HardwareMetric.fromSystem(new SystemInfo());
    }

    public static HardwareMetric fromSystem(SystemInfo systemInfo) {
        return HardwareMetric.fromSystem(systemInfo, UUID.randomUUID().toString());
    }

    public static HardwareMetric fromSystem(SystemInfo systemInfo, String name) {
        HardwareMetricBuilder builder = HardwareMetric.builder();
        CentralProcessor processor = systemInfo.getHardware().getProcessor();
        long[] prevTicks = processor.getSystemCpuLoadTicks();
        Util.sleep((long)1000L);
        long[] ticks = processor.getSystemCpuLoadTicks();
        long iowait = ticks[CentralProcessor.TickType.IOWAIT.getIndex()] - prevTicks[CentralProcessor.TickType.IOWAIT.getIndex()];
        GlobalMemory globalMemory = systemInfo.getHardware().getMemory();
        NetworkParams networkParams = systemInfo.getOperatingSystem().getNetworkParams();
        double[] processorCpuLoadBetweenTicks = processor.getProcessorCpuLoadBetweenTicks();
        LinkedHashMap<Integer, DeviceMetric> cpuMetrics = new LinkedHashMap<Integer, DeviceMetric>();
        for (int i = 0; i < processorCpuLoadBetweenTicks.length; ++i) {
            cpuMetrics.put(i, DeviceMetric.builder().load(processorCpuLoadBetweenTicks[i]).build());
        }
        LinkedHashMap<Integer, DiskInfo> diskInfoMap = new LinkedHashMap<Integer, DiskInfo>();
        HWDiskStore[] diskStores = systemInfo.getHardware().getDiskStores();
        for (int i = 0; i < diskStores.length; ++i) {
            HWDiskStore diskStore = diskStores[i];
            DiskInfo diskInfo = DiskInfo.builder().bytesRead(diskStore.getReadBytes()).bytesWritten(diskStore.getWriteBytes()).name(diskStore.getName()).modelName(diskStore.getModel()).transferTime(diskStore.getTransferTime()).build();
            diskInfoMap.put(i, diskInfo);
        }
        HashMap<Integer, DeviceMetric> gpuMetric = new HashMap<Integer, DeviceMetric>();
        if (Nd4j.getBackend().getClass().getName().toLowerCase().contains("cublas")) {
            Properties info = Nd4j.getExecutioner().getEnvironmentInformation();
            List devicesList = (List)info.get("cuda.devicesInformation");
            for (int i = 0; i < devicesList.size(); ++i) {
                double available = Double.parseDouble(((Map)devicesList.get(i)).get("cuda.freeMemory").toString());
                Map<MemcpyDirection, Long> memcpyDirectionLongMap = PerformanceTracker.getInstance().getCurrentBandwidth().get(i);
                DeviceMetric deviceMetric = DeviceMetric.builder().bandwidthHostToDevice(memcpyDirectionLongMap.get((Object)MemcpyDirection.HOST_TO_DEVICE)).bandwidthDeviceToHost(memcpyDirectionLongMap.get((Object)MemcpyDirection.DEVICE_TO_HOST)).bandwidthDeviceToDevice(memcpyDirectionLongMap.get((Object)MemcpyDirection.DEVICE_TO_DEVICE)).memAvailable(available).totalMemory(Double.parseDouble(((Map)devicesList.get(i)).get("cuda.totalMemory").toString())).deviceName(((Map)devicesList.get(i)).get("cuda.deviceName").toString()).build();
                gpuMetric.put(i, deviceMetric);
            }
        }
        return builder.logicalProcessorCount(processor.getLogicalProcessorCount()).physicalProcessorCount(processor.getPhysicalProcessorCount()).name(name).averagedCpuLoad((long)(processor.getSystemCpuLoad() * 100.0)).ioWaitTime(iowait).gpuMetrics(gpuMetric).hostName(networkParams.getHostName()).diskInfo(diskInfoMap).currentMemoryUse(globalMemory.getTotal() - globalMemory.getAvailable()).perCoreMetrics(cpuMetrics).build();
    }

    public String toYaml() {
        try {
            return yamlMapper.writeValueAsString(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static HardwareMetric fromYaml(@NonNull String yaml) {
        if (yaml == null) {
            throw new NullPointerException("yaml is marked non-null but is null");
        }
        try {
            return yamlMapper.readValue(yaml, HardwareMetric.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static HardwareMetricBuilder builder() {
        return new HardwareMetricBuilder();
    }

    public Map<Integer, DeviceMetric> getPerCoreMetrics() {
        return this.perCoreMetrics;
    }

    public long getPhysicalProcessorCount() {
        return this.physicalProcessorCount;
    }

    public long getLogicalProcessorCount() {
        return this.logicalProcessorCount;
    }

    public long getCurrentMemoryUse() {
        return this.currentMemoryUse;
    }

    public Map<Integer, DeviceMetric> getGpuMetrics() {
        return this.gpuMetrics;
    }

    public String getHostName() {
        return this.hostName;
    }

    public long getIoWaitTime() {
        return this.ioWaitTime;
    }

    public long getAveragedCpuLoad() {
        return this.averagedCpuLoad;
    }

    public Map<Integer, DiskInfo> getDiskInfo() {
        return this.diskInfo;
    }

    public String getName() {
        return this.name;
    }

    public void setPerCoreMetrics(Map<Integer, DeviceMetric> perCoreMetrics) {
        this.perCoreMetrics = perCoreMetrics;
    }

    public void setPhysicalProcessorCount(long physicalProcessorCount) {
        this.physicalProcessorCount = physicalProcessorCount;
    }

    public void setLogicalProcessorCount(long logicalProcessorCount) {
        this.logicalProcessorCount = logicalProcessorCount;
    }

    public void setCurrentMemoryUse(long currentMemoryUse) {
        this.currentMemoryUse = currentMemoryUse;
    }

    public void setGpuMetrics(Map<Integer, DeviceMetric> gpuMetrics) {
        this.gpuMetrics = gpuMetrics;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setIoWaitTime(long ioWaitTime) {
        this.ioWaitTime = ioWaitTime;
    }

    public void setAveragedCpuLoad(long averagedCpuLoad) {
        this.averagedCpuLoad = averagedCpuLoad;
    }

    public void setDiskInfo(Map<Integer, DiskInfo> diskInfo) {
        this.diskInfo = diskInfo;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HardwareMetric)) {
            return false;
        }
        HardwareMetric other = (HardwareMetric)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPhysicalProcessorCount() != other.getPhysicalProcessorCount()) {
            return false;
        }
        if (this.getLogicalProcessorCount() != other.getLogicalProcessorCount()) {
            return false;
        }
        if (this.getCurrentMemoryUse() != other.getCurrentMemoryUse()) {
            return false;
        }
        if (this.getIoWaitTime() != other.getIoWaitTime()) {
            return false;
        }
        if (this.getAveragedCpuLoad() != other.getAveragedCpuLoad()) {
            return false;
        }
        Map<Integer, DeviceMetric> this$perCoreMetrics = this.getPerCoreMetrics();
        Map<Integer, DeviceMetric> other$perCoreMetrics = other.getPerCoreMetrics();
        if (this$perCoreMetrics == null ? other$perCoreMetrics != null : !((Object)this$perCoreMetrics).equals(other$perCoreMetrics)) {
            return false;
        }
        Map<Integer, DeviceMetric> this$gpuMetrics = this.getGpuMetrics();
        Map<Integer, DeviceMetric> other$gpuMetrics = other.getGpuMetrics();
        if (this$gpuMetrics == null ? other$gpuMetrics != null : !((Object)this$gpuMetrics).equals(other$gpuMetrics)) {
            return false;
        }
        String this$hostName = this.getHostName();
        String other$hostName = other.getHostName();
        if (this$hostName == null ? other$hostName != null : !this$hostName.equals(other$hostName)) {
            return false;
        }
        Map<Integer, DiskInfo> this$diskInfo = this.getDiskInfo();
        Map<Integer, DiskInfo> other$diskInfo = other.getDiskInfo();
        if (this$diskInfo == null ? other$diskInfo != null : !((Object)this$diskInfo).equals(other$diskInfo)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HardwareMetric;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $physicalProcessorCount = this.getPhysicalProcessorCount();
        result = result * 59 + (int)($physicalProcessorCount >>> 32 ^ $physicalProcessorCount);
        long $logicalProcessorCount = this.getLogicalProcessorCount();
        result = result * 59 + (int)($logicalProcessorCount >>> 32 ^ $logicalProcessorCount);
        long $currentMemoryUse = this.getCurrentMemoryUse();
        result = result * 59 + (int)($currentMemoryUse >>> 32 ^ $currentMemoryUse);
        long $ioWaitTime = this.getIoWaitTime();
        result = result * 59 + (int)($ioWaitTime >>> 32 ^ $ioWaitTime);
        long $averagedCpuLoad = this.getAveragedCpuLoad();
        result = result * 59 + (int)($averagedCpuLoad >>> 32 ^ $averagedCpuLoad);
        Map<Integer, DeviceMetric> $perCoreMetrics = this.getPerCoreMetrics();
        result = result * 59 + ($perCoreMetrics == null ? 43 : ((Object)$perCoreMetrics).hashCode());
        Map<Integer, DeviceMetric> $gpuMetrics = this.getGpuMetrics();
        result = result * 59 + ($gpuMetrics == null ? 43 : ((Object)$gpuMetrics).hashCode());
        String $hostName = this.getHostName();
        result = result * 59 + ($hostName == null ? 43 : $hostName.hashCode());
        Map<Integer, DiskInfo> $diskInfo = this.getDiskInfo();
        result = result * 59 + ($diskInfo == null ? 43 : ((Object)$diskInfo).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "HardwareMetric(perCoreMetrics=" + this.getPerCoreMetrics() + ", physicalProcessorCount=" + this.getPhysicalProcessorCount() + ", logicalProcessorCount=" + this.getLogicalProcessorCount() + ", currentMemoryUse=" + this.getCurrentMemoryUse() + ", gpuMetrics=" + this.getGpuMetrics() + ", hostName=" + this.getHostName() + ", ioWaitTime=" + this.getIoWaitTime() + ", averagedCpuLoad=" + this.getAveragedCpuLoad() + ", diskInfo=" + this.getDiskInfo() + ", name=" + this.getName() + ")";
    }

    public HardwareMetric(Map<Integer, DeviceMetric> perCoreMetrics, long physicalProcessorCount, long logicalProcessorCount, long currentMemoryUse, Map<Integer, DeviceMetric> gpuMetrics, String hostName, long ioWaitTime, long averagedCpuLoad, Map<Integer, DiskInfo> diskInfo, String name) {
        this.perCoreMetrics = perCoreMetrics;
        this.physicalProcessorCount = physicalProcessorCount;
        this.logicalProcessorCount = logicalProcessorCount;
        this.currentMemoryUse = currentMemoryUse;
        this.gpuMetrics = gpuMetrics;
        this.hostName = hostName;
        this.ioWaitTime = ioWaitTime;
        this.averagedCpuLoad = averagedCpuLoad;
        this.diskInfo = diskInfo;
        this.name = name;
    }

    public static class HardwareMetricBuilder {
        private Map<Integer, DeviceMetric> perCoreMetrics;
        private long physicalProcessorCount;
        private long logicalProcessorCount;
        private long currentMemoryUse;
        private Map<Integer, DeviceMetric> gpuMetrics;
        private String hostName;
        private long ioWaitTime;
        private long averagedCpuLoad;
        private Map<Integer, DiskInfo> diskInfo;
        private String name;

        HardwareMetricBuilder() {
        }

        public HardwareMetricBuilder perCoreMetrics(Map<Integer, DeviceMetric> perCoreMetrics) {
            this.perCoreMetrics = perCoreMetrics;
            return this;
        }

        public HardwareMetricBuilder physicalProcessorCount(long physicalProcessorCount) {
            this.physicalProcessorCount = physicalProcessorCount;
            return this;
        }

        public HardwareMetricBuilder logicalProcessorCount(long logicalProcessorCount) {
            this.logicalProcessorCount = logicalProcessorCount;
            return this;
        }

        public HardwareMetricBuilder currentMemoryUse(long currentMemoryUse) {
            this.currentMemoryUse = currentMemoryUse;
            return this;
        }

        public HardwareMetricBuilder gpuMetrics(Map<Integer, DeviceMetric> gpuMetrics) {
            this.gpuMetrics = gpuMetrics;
            return this;
        }

        public HardwareMetricBuilder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public HardwareMetricBuilder ioWaitTime(long ioWaitTime) {
            this.ioWaitTime = ioWaitTime;
            return this;
        }

        public HardwareMetricBuilder averagedCpuLoad(long averagedCpuLoad) {
            this.averagedCpuLoad = averagedCpuLoad;
            return this;
        }

        public HardwareMetricBuilder diskInfo(Map<Integer, DiskInfo> diskInfo) {
            this.diskInfo = diskInfo;
            return this;
        }

        public HardwareMetricBuilder name(String name) {
            this.name = name;
            return this;
        }

        public HardwareMetric build() {
            return new HardwareMetric(this.perCoreMetrics, this.physicalProcessorCount, this.logicalProcessorCount, this.currentMemoryUse, this.gpuMetrics, this.hostName, this.ioWaitTime, this.averagedCpuLoad, this.diskInfo, this.name);
        }

        public String toString() {
            return "HardwareMetric.HardwareMetricBuilder(perCoreMetrics=" + this.perCoreMetrics + ", physicalProcessorCount=" + this.physicalProcessorCount + ", logicalProcessorCount=" + this.logicalProcessorCount + ", currentMemoryUse=" + this.currentMemoryUse + ", gpuMetrics=" + this.gpuMetrics + ", hostName=" + this.hostName + ", ioWaitTime=" + this.ioWaitTime + ", averagedCpuLoad=" + this.averagedCpuLoad + ", diskInfo=" + this.diskInfo + ", name=" + this.name + ")";
        }
    }
}

