/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.optimize.optimizations;

import java.util.ArrayList;
import java.util.List;
import org.nd4j.autodiff.samediff.ArrayHolder;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.VariableType;
import org.nd4j.autodiff.samediff.internal.SameDiffOp;
import org.nd4j.autodiff.samediff.internal.Variable;
import org.nd4j.autodiff.samediff.optimize.OptimizationHelper;
import org.nd4j.autodiff.samediff.optimize.Optimizer;
import org.nd4j.autodiff.samediff.optimize.optimizations.BaseOptimizerSet;
import org.nd4j.common.function.Supplier;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnusedFunctionOptimizations
extends BaseOptimizerSet {
    private static final Logger log = LoggerFactory.getLogger(UnusedFunctionOptimizations.class);

    public static class RemoveUnusedConstants
    implements Optimizer {
        @Override
        public boolean checkAndApply(SameDiff sd, OptimizationHelper helper, SameDiffOp op, ArrayHolder constantArrays, ArrayHolder variablesArrays) {
            ArrayList variables = new ArrayList(sd.getVariables().values());
            boolean anyRemoved = false;
            for (Variable v : variables) {
                List<String> inputFor;
                if (v.getVariable().getVariableType() != VariableType.CONSTANT || (inputFor = v.getInputsForOp()) != null && !inputFor.isEmpty()) continue;
                final INDArray arr = v.getVariable().getArr();
                helper.arrayRecoveryFunction(v.getName(), new Supplier<INDArray>(){

                    @Override
                    public INDArray get() {
                        return arr;
                    }
                });
                sd.getVariables().remove((Object)v.getName());
                log.info("Removed unused constant: {}", (Object)v.getName());
                anyRemoved = true;
            }
            return anyRemoved;
        }
    }
}

