/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.compression.impl;

import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.compression.impl.AbstractCompressor;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.buffer.DataTypeEx;
import org.nd4j.linalg.api.memory.MemcpyDirection;
import org.nd4j.linalg.api.ops.performance.PerformanceTracker;
import org.nd4j.linalg.compression.CompressedDataBuffer;
import org.nd4j.linalg.compression.CompressionDescriptor;
import org.nd4j.linalg.compression.CompressionType;
import org.nd4j.linalg.factory.Nd4j;

public class NoOp
extends AbstractCompressor {
    @Override
    public String getDescriptor() {
        return "NOOP";
    }

    @Override
    public CompressionType getCompressionType() {
        return CompressionType.LOSSLESS;
    }

    @Override
    public DataBuffer decompress(DataBuffer buffer, DataType type) {
        CompressedDataBuffer comp = (CompressedDataBuffer)buffer;
        DataBuffer result = Nd4j.createBuffer(comp.length(), false);
        Nd4j.getMemoryManager().memcpy(result, buffer);
        return result;
    }

    @Override
    public DataBuffer compress(DataBuffer buffer) {
        CompressionDescriptor descriptor = new CompressionDescriptor(buffer, this);
        BytePointer ptr = new BytePointer(buffer.length() * (long)buffer.getElementSize());
        CompressedDataBuffer result = new CompressedDataBuffer((Pointer)ptr, descriptor);
        Nd4j.getMemoryManager().memcpy(result, buffer);
        return result;
    }

    @Override
    protected CompressedDataBuffer compressPointer(DataTypeEx srcType, Pointer srcPointer, int length, int elementSize) {
        CompressionDescriptor descriptor = new CompressionDescriptor();
        descriptor.setCompressionType(this.getCompressionType());
        descriptor.setOriginalLength(length * elementSize);
        descriptor.setCompressionAlgorithm(this.getDescriptor());
        descriptor.setOriginalElementSize(elementSize);
        descriptor.setCompressedLength(length * elementSize);
        descriptor.setNumberOfElements(length);
        BytePointer ptr = new BytePointer((long)(length * elementSize));
        long perfD = PerformanceTracker.getInstance().helperStartTransaction();
        Pointer.memcpy((Pointer)ptr, (Pointer)srcPointer, (long)(length * elementSize));
        PerformanceTracker.getInstance().helperRegisterTransaction(0, perfD, length * elementSize, MemcpyDirection.HOST_TO_HOST);
        CompressedDataBuffer buffer = new CompressedDataBuffer((Pointer)ptr, descriptor);
        return buffer;
    }
}

